/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;

public class BasicArticleWithConversionAddedConverter
implements Converter<BasicArticleLight, String> {
    @Override
    public String convert(BasicArticleLight o, Node<BasicArticleLight> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        String t = o.getNumber() + " - " + o.getName();
        t = t + " (" + this.createConversionString(o) + ")";
        return t;
    }

    private String createConversionString(BasicArticleLight article) {
        PackagingQuantityBaseComplete conversion = (PackagingQuantityBaseComplete)article.getPackingQuantitiesVariant(new Timestamp(System.currentTimeMillis()));
        List packagingQuantity = conversion.getPackingQuantities();
        Collections.sort(packagingQuantity);
        String retString = "";
        double amount = 1.0;
        for (PackagingQuantityComplete q : packagingQuantity) {
            QuantityComplete currentAmount = new QuantityComplete(Double.valueOf(amount *= (double)q.getAmount().intValue()), q.getUnit());
            currentAmount = (QuantityComplete)UnitCalculator.normalizeQuantity((IQuantity)currentAmount);
            String fr = this.formatDouble(currentAmount.getAmount(), "#.##");
            retString = retString + fr + " " + currentAmount.getUnit().getShortName() + " = ";
        }
        if (retString.length() > 3) {
            retString = retString.substring(0, retString.length() - 3);
        }
        return retString;
    }

    private String formatDouble(double d, String pattern) {
        DecimalFormat df = new DecimalFormat(pattern);
        df.setRoundingMode(RoundingMode.HALF_UP);
        String f = df.format(d);
        return f;
    }

    @Override
    public Class<? extends BasicArticleLight> getParameterClass() {
        return BasicArticleLight.class;
    }
}

