/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.OrderPositionTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderRecipientTransactionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.RequisitionOrderTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.AFlightStockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.FlightStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.util.ArrayList;

public class StockTransactionRemarkConverter
implements Converter<StockTransactionComplete, String> {
    @Override
    public String convert(StockTransactionComplete o, Node<StockTransactionComplete> currentNode, Object ... param) {
        FlightStockCheckoutComplete t1;
        Object t;
        if (o == null) {
            return NULL_RETURN;
        }
        ArrayList docs = new ArrayList();
        if (o instanceof OrderPositionTransactionComplete) {
            if (o instanceof PurchaseOrderTransactionComplete) {
                if (o instanceof PurchaseOrderAcceptationComplete) {
                    t = (PurchaseOrderAcceptationComplete)o;
                    docs.addAll(t.getCustomsDocs());
                }
            } else if (o instanceof RequisitionOrderTransactionComplete && o instanceof RequisitionOrderRecipientTransactionComplete && (t = (RequisitionOrderRecipientTransactionComplete)o).getBatch() != null) {
                docs.addAll(t.getBatch().getCharge().getDocuments());
            }
        } else if (o instanceof StockCheckinComplete) {
            ManualStockCheckinComplete t2;
            t = (StockCheckinComplete)o;
            docs.addAll(t.getCustomsDocs());
            if (o instanceof ManualStockCheckinComplete && (t2 = (ManualStockCheckinComplete)o).getContainingGroup() != null && t2.getContainingGroup() instanceof StockCheckinGroupComplete) {
                docs.addAll(((StockCheckinGroupComplete)t2.getContainingGroup()).getDocuments());
            }
        } else if (o instanceof StockCheckoutComplete) {
            t = (StockCheckoutComplete)o;
            docs.addAll(t.getCharge().getDocuments());
            if (o instanceof FlightStockCheckoutComplete) {
                t1 = (FlightStockCheckoutComplete)o;
                docs.addAll(t1.getFlight().getCustomsDocuments());
            }
            if (o instanceof ManualStockCheckoutComplete && (t1 = (ManualStockCheckoutComplete)o).getContainingGroup() != null && t1.getContainingGroup() instanceof StockCheckoutGroupComplete) {
                docs.addAll(((StockCheckoutGroupComplete)t1.getContainingGroup()).getDocuments());
            }
        } else if (o instanceof StockInventoryComplete) {
            t = (StockInventoryComplete)o;
            docs.addAll(t.getCharge().getDocuments());
        } else if (o instanceof StockMovementComplete) {
            t = (StockMovementComplete)o;
            docs.addAll(t.getCharge().getDocuments());
            if (o instanceof AFlightStockTransactionComplete) {
                t1 = (AFlightStockTransactionComplete)o;
                docs.addAll(t1.getFlight().getCustomsDocuments());
            }
            if (o instanceof ManualStockMovementComplete && (t1 = (ManualStockMovementComplete)o).getContainingMovement() != null && t1.getContainingMovement() instanceof StockMovementGroupLight) {
                docs.addAll(((StockMovementGroupLight)t1.getContainingMovement()).getDocuments());
            }
        } else if (o instanceof FlightStockCheckinComplete) {
            FlightStockCheckinComplete c = (FlightStockCheckinComplete)o;
            docs.addAll(c.getCharge().getDocuments());
        }
        t = "";
        for (CustomsDocumentComplete d : docs) {
            t = (String)t + d.getCustomsDocumentType().getName() + ": " + d.getCustomsDocumentId() + ", ";
        }
        if (!StringUtil.isBlank((String)o.getComment())) {
            t = (String)t + o.getComment() + ", ";
        }
        if (o.getRemark() != null) {
            t = (String)t + o.getRemark().getDescription() + ", ";
        }
        if (!StringUtil.isBlank((String)t)) {
            t = ((String)t).substring(0, ((String)t).length() - 2);
        }
        return t;
    }

    @Override
    public Class<? extends StockTransactionComplete> getParameterClass() {
        return StockTransactionComplete.class;
    }
}

