/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.ejb;

import ch.icit.pegasus.client.ejb.ProxyToolkit;
import ch.icit.pegasus.client.util.CATITFilePathConfig;
import ch.icit.pegasus.client.util.ConfigHelper;
import ch.icit.pegasus.client.util.PropertyReader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.services.ServiceImplementation;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.exception.ServiceExceptionMessages;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.commons.io.FileUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.omg.CORBA.NO_PERMISSION;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.MatchRule;

public class EjbContextFactory {
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:38.0) Gecko/20100101 Firefox/38.0";
    private static final String STORE_PWD = "catit1234";
    private static final String APP_NAME = "catit-server";
    private static final String MODULE_NAME = "core-services-impl";
    private static final String DISTINCT_NAME = "";
    private static final String HTTP_SERVICES = "/pegasus-services";
    private static final String SCOPED_CONTEXT = "org.jboss.ejb.client.scoped.context";
    private static final String LAST_VERSION_FILE = "lastWorkingDownloadServerIP.txt";
    private static final String WS_NAME_SPACE = "https://icit.ch/pegasus/";
    private static final Logger log = LoggerFactory.getLogger(EjbContextFactory.class);
    private static Boolean initialized = false;
    private static Context context;
    private boolean useWebServices;
    private String wsEndpointUrl = "http://localhost:8081/ws/";
    private String userName;
    private String userPassword;
    private Map<String, Object> wsPortCache = new HashMap<String, Object>();
    private boolean webServiceInUse;
    private int selectedServer = 0;
    private List<EjbContextConfig> currentEjbConfigs;

    private EjbContextFactory() {
    }

    public static EjbContextFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public boolean isWebServiceInUse() {
        return this.webServiceInUse;
    }

    public void initEjbContext(String user, String password) throws Exception {
        this.userName = user;
        this.userPassword = password;
        EjbContextConfig config = this.getOrbConfig();
        String customerCode = System.getProperty("pegasus.client.customercode");
        if (config == null) {
            throw new IOException("EJBContextConfig is empty");
        }
        log.info("Init ConnectionFactory = load certificates");
        this.copyCertificates(customerCode, config.getHost());
        String forceWebServiceString = System.getProperty("pegasus.client.forceWebService");
        if (config.getProxyActive()) {
            if (forceWebServiceString == null) {
                this.useWebServices = false;
                log.info("Init ConnectionFactory = proxy active but legacy app launcher -> Use ejb");
            } else {
                this.useWebServices = true;
                log.info("Init ConnectionFactory = proxy active -> Use ws");
            }
        } else {
            boolean forceWebService;
            boolean bl = forceWebService = forceWebServiceString != null && Boolean.TRUE.toString().toLowerCase().equals(forceWebServiceString);
            if (forceWebService) {
                this.useWebServices = true;
                log.info("Init ConnectionFactory = proxy not active -> force using ws instead of ejb");
            } else {
                log.info("Init ConnectionFactory = proxy not active -> Use ejb");
            }
        }
        if (config.getSsl()) {
            File trustStoreFile = CATITFilePathConfig.getTrustStore(customerCode);
            if (!trustStoreFile.exists()) {
                throw new RuntimeException("Trust Store not found at " + trustStoreFile.getAbsolutePath() + "!");
            }
            System.setProperty("javax.net.ssl.trustStore", trustStoreFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStorePassword", STORE_PWD);
            File keyStoreFile = CATITFilePathConfig.getKeyStore(customerCode);
            if (!keyStoreFile.exists()) {
                throw new RuntimeException("Key Store not found at " + keyStoreFile.getAbsolutePath() + "!");
            }
            System.setProperty("javax.net.ssl.keyStore", keyStoreFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.keyStorePassword", STORE_PWD);
        }
        if (this.useWebServices) {
            this.webServiceInUse = true;
            initialized = true;
            if (!"localhost".equals(config.getHost())) {
                this.wsEndpointUrl = "https://" + config.getHost() + ":8444/ws/";
            }
            log.info("Init ConnectionFactory = JAX-WS Endpoint URL: " + this.wsEndpointUrl);
        } else {
            AuthenticationConfiguration authConfig = AuthenticationConfiguration.empty();
            AuthenticationContext authContext = AuthenticationContext.empty().with(MatchRule.ALL.matchHost(config.getHost()), authConfig);
            Callable<Void> callable = () -> {
                Properties properties = new Properties();
                properties.put("java.naming.factory.initial", "org.wildfly.naming.client.WildFlyInitialContextFactory");
                properties.put(SCOPED_CONTEXT, (Object)true);
                properties.put("java.naming.security.principal", user);
                properties.put("java.naming.security.credentials", password);
                String address = config.getProtocol() + "://" + config.getHost() + ":" + config.getPort();
                if (config.getEjbOverHttp()) {
                    address = address + HTTP_SERVICES;
                }
                properties.put("java.naming.provider.url", address);
                context = (Context)new InitialContext(properties).lookup("ejb:");
                log.info("Init ConnectionFactory = EJB Endpoint URL: " + address + " with SSL " + (config.getSsl() ? "enabled." : "disabled."));
                initialized = true;
                return null;
            };
            authContext.runCallable(callable);
        }
    }

    public <T, E extends T> T getService(Class<T> service) throws ServiceException {
        if (this.useWebServices) {
            return this.getWebService(service);
        }
        return this.getStatelessService(service);
    }

    public <T> T getStatelessService(Class<T> service) throws ServiceException {
        if (this.useWebServices) {
            return this.getWebService(service);
        }
        return this.doGetService(service, TYPE.STATELESS);
    }

    public <T> T getStatefulService(Class<T> service) throws ServiceException {
        if (this.useWebServices) {
            return null;
        }
        return this.doGetService(service, TYPE.STATEFUL);
    }

    public <T> T getWebService(Class<T> myService) throws ServiceException {
        String myServiceName = myService.getSimpleName();
        Object port = this.wsPortCache.get(myServiceName);
        if ("SessionService".equals(myServiceName)) {
            port = null;
        }
        if (port == null) {
            String endPoint = this.wsEndpointUrl + myServiceName + "/" + myServiceName;
            QName serviceName = new QName(WS_NAME_SPACE + myServiceName.toLowerCase(), myServiceName);
            Service service = null;
            try {
                URL wsdlURL = new URL(endPoint + "?wsdl");
                service = Service.create((URL)wsdlURL, (QName)serviceName);
            }
            catch (MalformedURLException e) {
                log.error(DISTINCT_NAME, (Throwable)e);
                throw new ClientServerCallException("Server not reachable!", e);
            }
            catch (WebServiceException e) {
                log.error(DISTINCT_NAME, (Throwable)e);
                throw new ClientServerCallException("Server not reachable!", (Exception)((Object)e));
            }
            port = service.getPort(myService);
            BindingProvider bp = (BindingProvider)port;
            bp.getRequestContext().put("javax.xml.ws.security.auth.username", this.userName);
            bp.getRequestContext().put("javax.xml.ws.security.auth.password", this.userPassword);
            this.wsPortCache.put(myServiceName, port);
        }
        return (T)port;
    }

    private <T> T doGetService(Class<T> service, TYPE type) throws ServiceException {
        ServiceImplementation annotation = service.getAnnotation(ServiceImplementation.class);
        ServiceImplementation serviceImplementation = annotation;
        if (serviceImplementation == null || serviceImplementation.implementation() == null) {
            throw new ServiceException("There is no implementation specified for Service " + service.getSimpleName() + ". Please use the ServiceImplementation Annotation on the Interface", ServiceExceptionMessages.TODO_0000, new String[0]);
        }
        String simpleImplementationName = serviceImplementation.implementation();
        String fullInterfaceName = service.getName();
        String name = DISTINCT_NAME;
        if (type == TYPE.STATELESS) {
            name = "catit-server/core-services-impl//" + simpleImplementationName + "!" + fullInterfaceName;
        } else if (type == TYPE.STATEFUL) {
            name = "catit-server/core-services-impl//" + simpleImplementationName + "!" + fullInterfaceName + "?stateful";
        }
        Object s = this.lookup(name);
        if (s != null) {
            return (T)s;
        }
        int retries = 5;
        try {
            while (s == null && --retries >= 0) {
                Thread.sleep(5000L);
                log.info("Retrying to lookup service '" + service.getSimpleName() + "' ... (retries left: " + retries + ")");
                s = this.lookup(name);
            }
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (s != null) {
            return (T)s;
        }
        String msg = "Failed to lookup Service '" + service.getSimpleName() + "'! Server connection lost?";
        log.error(msg);
        throw new RuntimeException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookup(String name) throws ServiceException {
        Context lookup = null;
        try {
            if (!initialized.booleanValue()) {
                throw new ServiceException("InitialContext not instantiated", ServiceExceptionMessages.TODO_0000, new String[0]);
            }
            String pre = name.split("/", 2)[0];
            String post = name.split("/", 2)[1];
            lookup = (Context)context.lookup(pre);
            Object object = lookup.lookup(post);
            return object;
        }
        catch (NamingException e) {
            Throwable t;
            for (t = e; ((Throwable)t).getCause() != null && ((Throwable)t).getCause() != t; t = ((Throwable)t).getCause()) {
            }
            if (t instanceof NO_PERMISSION) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ServiceException("Access denied or wrong password!", ServiceExceptionMessages.TODO_0000, new String[0]);
            }
            log.error("failed to lookup ejb " + name + "(" + e.getMessage() + ")!", (Throwable)e);
            Object var5_8 = null;
            return var5_8;
        }
        finally {
            if (lookup != null) {
                try {
                    lookup.close();
                }
                catch (NamingException e) {
                    log.error("failed to close ejb client context" + name + "(" + e.getMessage() + ")!", (Throwable)e);
                }
            }
        }
    }

    private void copyCertificates(String customer, String host) {
        if (customer == null || host == null) {
            log.info("Failed to copy certificates because customer or host is not set");
            return;
        }
        if ("dev".equals(customer) || "host".equals("localhost")) {
            return;
        }
        if (host.split("\\.").length > 1) {
            host = host.split("\\.")[0];
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            InputStream originTrustStoreStream = classLoader.getResourceAsStream("certs/" + host + "/truststore.jks");
            InputStream originKeyStoreStream = classLoader.getResourceAsStream("certs/" + host + "/keystore.jks");
            String trustStorePath = CATITFilePathConfig.getTrustStore(customer).getAbsolutePath();
            if (originTrustStoreStream != null) {
                File tsp = new File(trustStorePath);
                if (!tsp.exists()) {
                    tsp.getParentFile().mkdirs();
                } else {
                    FileUtils.forceDelete((File)tsp);
                }
                FileUtils.copyInputStreamToFile((InputStream)originTrustStoreStream, (File)tsp);
            }
            String keyStorePath = CATITFilePathConfig.getKeyStore(customer).getAbsolutePath();
            if (originKeyStoreStream != null) {
                File ksp = new File(keyStorePath);
                if (!ksp.exists()) {
                    ksp.getParentFile().mkdirs();
                } else {
                    FileUtils.forceDelete((File)ksp);
                }
                FileUtils.copyInputStreamToFile((InputStream)originKeyStoreStream, (File)ksp);
            }
        }
        catch (Exception e) {
            log.error("Error while copy Trust/Key Store", (Throwable)e);
        }
    }

    public void setSelectedServer(int i) {
        this.selectedServer = i;
    }

    public int getSelectedServer() {
        return this.selectedServer;
    }

    public EjbContextConfig getOrbConfig() throws IOException {
        return this.getOrbConfigs().get(this.getSelectedServer());
    }

    public List<EjbContextConfig> getOrbConfigs() throws IOException {
        if (this.currentEjbConfigs == null) {
            this.currentEjbConfigs = this.getOrbConfigsByRemote();
        }
        return this.currentEjbConfigs;
    }

    public List<EjbContextConfig> getOrbConfigsAndReload() throws IOException {
        this.currentEjbConfigs = this.getOrbConfigsByRemote();
        return this.currentEjbConfigs;
    }

    public String getSelectedServerMSG() throws IOException {
        return this.getOrbConfig().getUserMSG();
    }

    public String getApplicationServer() {
        ConfigHelper confHelper = ConfigHelper.getInstance();
        return confHelper.getProperty("orb.applicationserver");
    }

    private ArrayList<EjbContextConfig> getOrbConfigsByProperties() {
        ConfigHelper confHelper = ConfigHelper.getInstance();
        ArrayList<EjbContextConfig> orbConfigs = new ArrayList<EjbContextConfig>();
        String[] hosts = confHelper.getProperty("orb.hosts").split(",");
        String[] ports = confHelper.getProperty("orb.ports").split(",");
        String[] ssls = confHelper.getProperty("orb.useSSL").split(",");
        String[] descriptions = null;
        if (confHelper.getProperty("orb.description") != null) {
            descriptions = confHelper.getProperty("orb.description").split(",");
        }
        String[] userMSGs = null;
        if (confHelper.getProperty("orb.usermsg") != null) {
            userMSGs = confHelper.getProperty("orb.usermsg").split(",");
        }
        descriptions = descriptions == null ? new String[]{} : descriptions;
        String[] stringArray = userMSGs = userMSGs == null ? new String[]{} : userMSGs;
        if (ports.length < 1) {
            throw new RuntimeException("No port number(s) defined!");
        }
        String[] names = confHelper.getProperty("orb.names") != null ? confHelper.getProperty("orb.names").split(",") : new String[]{};
        for (int i = 0; i < hosts.length; ++i) {
            String name;
            int port;
            String host = hosts[i];
            try {
                port = Integer.parseInt(ports.length < i + 1 ? ports[ports.length - 1] : ports[i]);
                if (port < 0 || port > 65535) {
                    throw new RuntimeException("Invalid port number for ORB number " + i + "!");
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid port number for ORB number " + i + "!", e);
            }
            String string = name = names.length < i + 1 ? "<no name defined>" : names[i];
            if (host == null || host.isEmpty()) {
                throw new RuntimeException("Failed to initialize the ORB with the number " + i + "!");
            }
            boolean test = Boolean.valueOf(confHelper.getProperty("orb.testing"));
            String description = descriptions.length > i ? descriptions[i] : null;
            String userMSG = userMSGs.length > i ? userMSGs[i] : null;
            boolean ssl = Boolean.valueOf(ssls[i]);
            String protocol = ssl ? "remote+https" : "remote+http";
            EjbContextConfig orb = new EjbContextConfig(host, port, name, test, description, userMSG, ssl, false, protocol, ProxyToolkit.useProxy());
            orbConfigs.add(orb);
            log.debug("Found ORB configuration #" + (i + 1) + ": " + orb);
        }
        return orbConfigs;
    }

    private List<EjbContextConfig> getOrbConfigsByRemote() throws IOException {
        log.info("Load Orb Configs by Remote");
        ArrayList<EjbContextConfig> configs = new ArrayList<EjbContextConfig>();
        String serverName = System.getProperty("pegasus.client.servername");
        String serverUrl = System.getProperty("pegasus.client.serverurl");
        String serverPort = System.getProperty("pegasus.client.serverPort");
        if (StringUtil.isBlank((String)serverName) || StringUtil.isBlank((String)serverUrl) || StringUtil.isBlank((String)serverPort)) {
            log.info("Server Name is empty => use legacy mode!!!!");
            System.out.println("server Name from props: " + serverName);
            System.out.println("server URL from props: " + serverUrl);
            System.out.println("server Port from props: " + serverPort);
            if (this.loadLoginPropertiesFromMaster(configs)) {
                return this.getOrbConfigsByProperties();
            }
            return configs;
        }
        log.info("Server Name is set => use https mode!!!!");
        String description = System.getProperty("pegasus.client.description");
        String useSSL = System.getProperty("pegasus.client.useSSL");
        String protocol = System.getProperty("pegasus.client.protocol");
        String ejbOverHttp = System.getProperty("pegasus.client.ejbOverHttp");
        boolean proxyActive = ProxyToolkit.useProxy();
        log.info("Server Name = " + serverName);
        log.info("Server URL = " + serverUrl);
        log.info("Server Port = " + serverPort);
        log.info("Server Description = " + description);
        log.info("Server User Message = null");
        log.info("Server useSSL = " + useSSL);
        log.info("Server protocol = " + protocol);
        log.info("EJB over HTTP = " + ejbOverHttp);
        log.info("Proxy Active = " + proxyActive);
        EjbContextConfig config = new EjbContextConfig(serverUrl, Integer.valueOf(serverPort), serverName, false, description, null, Boolean.valueOf(useSSL), Boolean.valueOf(ejbOverHttp), protocol, proxyActive);
        configs.add(config);
        return configs;
    }

    private boolean loadLoginPropertiesFromMaster(List<EjbContextConfig> configs) throws IOException {
        PropertyReader propertyReader = new PropertyReader();
        String server = propertyReader.getProperty("pegasus.client.customercode");
        if (server == null || server.equals("dev")) {
            log.warn("No Customer Code provided as argument or in pegasus.xml. Using Old Properties as Workaround. This is only recommended on Developer Environments");
            return true;
        }
        log.info("Using Customer Code " + server + " to download Login information");
        String loginServer = propertyReader.getProperty("pegasus.client.loginserverurl");
        if (loginServer == null || loginServer.equals(DISTINCT_NAME)) {
            log.info("No Login Server url provided as argument.");
        }
        log.info("Using Master Server URL " + loginServer + " to download Login information");
        String tempServer = CATITFilePathConfig.getCustomerSpecificTempDir(server).getAbsolutePath() + File.separator + LAST_VERSION_FILE;
        BufferedReader rd = this.tryToConnectToLoginServer(loginServer, server);
        if (rd == null) {
            log.warn("(Fallback) No Connection to Master Server possible. Trying to use the last working Server");
            loginServer = new String(Files.readAllBytes(Paths.get(tempServer, new String[0])));
            log.warn("(Fallback) Last working Server was " + loginServer);
            rd = this.tryToConnectToLoginServer(loginServer, server);
        }
        if (rd == null) {
            log.warn("No Login Server Connection Parameters found");
            throw new RuntimeException("No Connection Parameters Cmp found");
        }
        File file = new File(tempServer);
        file.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(file);
        try (PrintWriter output = new PrintWriter(writer);){
            output.print(loginServer);
        }
        writer.close();
        try {
            JSONObject rootObject = (JSONObject)JSONValue.parse((String)rd.readLine());
            JSONArray servers = (JSONArray)rootObject.get((Object)"servers");
            for (Object object : servers) {
                JSONObject innerObject = (JSONObject)object;
                String name = innerObject.get((Object)"name").toString();
                String serverUrl = innerObject.get((Object)"url").toString();
                int port = ((Long)innerObject.get((Object)"port")).intValue();
                boolean test = (Boolean)innerObject.get((Object)"test");
                String description = innerObject.get((Object)"description").toString();
                String usermsg = innerObject.get((Object)"usermsg").toString();
                boolean ssl = (Boolean)innerObject.get((Object)"ssl");
                boolean ejbOverHttp = (Boolean)innerObject.get((Object)"ejbOverHttp");
                String protocol = ssl ? "https-remoting" : "http-remoting";
                if (ejbOverHttp) {
                    protocol = "https";
                }
                EjbContextConfig config = new EjbContextConfig(serverUrl, port, name, test, description, usermsg, ssl, ejbOverHttp, protocol, ProxyToolkit.useProxy());
                configs.add(config);
                log.info("Server configuration downloaded: " + name);
            }
        }
        catch (Exception e) {
            throw new IOException("Response from Master-Server malformed or customercode invalid");
        }
        return false;
    }

    private BufferedReader tryToConnectToLoginServer(String urlString, String server) {
        String loginServer = urlString;
        if (loginServer == null || loginServer.equals(DISTINCT_NAME)) {
            log.info("No Login Server url provided as argument.");
        }
        log.info("Using Master Server URL " + loginServer + " to download Login information");
        JSONObject send = new JSONObject();
        send.put((Object)"server", (Object)server);
        try {
            URL url = new URL(loginServer + "?server=" + send.toString());
            log.info("Build connection to Master Server: " + url.toString());
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("user-agent", USER_AGENT);
            log.info("Open connection with user-agent: " + conn.getRequestProperty("user-agent"));
            conn.connect();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            return rd;
        }
        catch (Exception e) {
            log.info("Unable to connect to Master Server: " + e.getMessage());
            if (ProxyToolkit.useProxy()) {
                log.info("Try to connect to Master Server with Proxy");
                try {
                    URL url = new URL(loginServer + "?server=" + send.toString());
                    Proxy proxy = ProxyToolkit.createProxyForURL(urlString);
                    URLConnection conn = url.openConnection(proxy);
                    conn.setRequestProperty("user-agent", USER_AGENT);
                    log.info("Open proxy connection with user-agent: " + conn.getRequestProperty("user-agent"));
                    conn.connect();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    return rd;
                }
                catch (Exception e1) {
                    log.info("Unable to connect to Master Server with Proxy: " + e.getMessage());
                    return null;
                }
            }
            return null;
        }
    }

    public void closeInitialContext() {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException e) {
                log.warn(e.getMessage());
            }
        }
        context = null;
        initialized = false;
    }

    public boolean getUseWebServices() {
        return this.useWebServices;
    }

    public class EjbContextConfig {
        private final String host;
        private final int port;
        private final String name;
        private final boolean test;
        private final String description;
        private final String userMSG;
        private final boolean ssl;
        private final boolean ejbOverHttp;
        private final String protocol;
        private final boolean proxyActive;

        EjbContextConfig(String host, int port, String name, boolean test, String description, String userMSG, boolean ssl, boolean ejbOverHttp, String protocol, boolean proxyActive) {
            this.host = host;
            this.port = port;
            this.name = name;
            this.test = test;
            this.description = description;
            this.userMSG = userMSG;
            this.ssl = ssl;
            this.ejbOverHttp = ejbOverHttp;
            this.protocol = protocol;
            this.proxyActive = proxyActive;
        }

        public boolean getSsl() {
            return this.ssl;
        }

        public boolean getEjbOverHttp() {
            return this.ejbOverHttp;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUserMSG() {
            return this.userMSG;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getName() {
            return this.name;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String toString() {
            return this.host + ":" + this.port + " (" + this.name + ")";
        }

        public boolean getTest() {
            return this.test;
        }

        public boolean getProxyActive() {
            return this.proxyActive;
        }
    }

    private static final class InstanceHolder {
        static final EjbContextFactory INSTANCE = new EjbContextFactory();

        private InstanceHolder() {
        }
    }

    private static enum TYPE {
        STATEFUL,
        STATELESS;

    }
}

