/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.node.impls;

import ch.icit.pegasus.client.node.ViewNodeDataChangeHandler;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.AEmbeddedDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ViewNode<T>
extends Node<T>
implements NodeListener {
    private final List<Node<?>> viewChilds = new ArrayList();
    private ViewNodeDataChangeHandler<T> changeHandler;
    private Long id;

    public ViewNode(String name, T value) {
        this(name);
        this.setValue(value, 0L);
    }

    public ViewNode(String name) {
        this.setName(name);
        if (AEmbeddedDTO.currentID == null) {
            new AEmbeddedDTO();
        }
        this.id = AEmbeddedDTO.currentID = Long.valueOf(AEmbeddedDTO.currentID + 1L);
    }

    @Override
    public Node[] getChildsAsArray() {
        Node[] ns = this.viewChilds.toArray(new Node[0]);
        return ns;
    }

    @Override
    public void removeAllChilds() {
        for (Node<?> n : this.viewChilds) {
            n.removeNodeListener(this);
            this.fireChildRemovedEvent(n);
        }
        this.viewChilds.clear();
        this.updateValue();
    }

    public void updateValue(boolean isSilent) {
        if (this.changeHandler != null) {
            T v = this.changeHandler.calculateNewValue(this);
            if (!isSilent) {
                this.setValue(v, 0L);
            } else {
                this.setValueSilent(v, true, 0L, null);
            }
        }
    }

    public void updateValue() {
        this.updateValue(false);
    }

    public void clearNode() {
    }

    @Override
    public void removeNodeListenerRecursively(NodeListener l) {
        this.listeners.remove(l);
        for (Node<?> n : this.viewChilds) {
            n.removeNodeListenerRecursively(l);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ViewNodeDataChangeHandler<T> getChangeHandler() {
        return this.changeHandler;
    }

    public void setChangeHandler(ViewNodeDataChangeHandler<T> changeHandler) {
        this.changeHandler = changeHandler;
    }

    @Override
    public void sortChilds(Comparator<Node<?>> comp) {
        Collections.sort(this.viewChilds, comp);
    }

    private void add(Node<?> node) {
        if (!this.contains(node)) {
            this.viewChilds.add(node);
        }
    }

    private void remove(Node<?> node) {
        this.viewChilds.remove(node);
    }

    @Override
    public void addChild(Node<?> child, long id) {
        this.add(child);
        this.fireChildAddedEvent(child, null);
    }

    public void addChildren(List<Node<?>> list) {
        for (Node<?> n : list) {
            this.add(n);
        }
    }

    @Override
    public void addChildSilent(Node<?> child, NodeListener l, boolean all, long id) {
        this.add(child);
        if (!all) {
            this.fireChildAddedEvent(child, l);
        }
    }

    @Override
    public void removeChild(Node<?> child, long id) {
        this.remove(child);
        this.fireChildRemovedEvent(child);
    }

    @Override
    public int getChildCount() {
        return this.viewChilds.size();
    }

    @Override
    public void getAllChildAddEventsFor(NodeListener listener, String ... childs) {
        this.getAllChildAddEvents(listener);
    }

    @Override
    public void getAllChildAddEvents(NodeListener listener) {
        for (Node<?> v : this.viewChilds) {
            listener.childAdded(this, v);
        }
    }

    @Override
    public Iterator<Node<?>> getAllChildsNamed(String name) {
        ArrayList a = new ArrayList();
        for (Node<?> node : this.viewChilds) {
            if (node == null || node.getName() == null || !node.getName().equals(name)) continue;
            a.add(node);
        }
        return a.iterator();
    }

    @Override
    public Node<?> getChildAt(int i) {
        return this.viewChilds.get(i);
    }

    @Override
    public int getChildIndex(Node<?> child) {
        return this.viewChilds.indexOf(child);
    }

    @Override
    public Node<?> getChildNamed(String ... names) {
        String name = "";
        if (names.length > 1) {
            for (String n : names) {
                name = name + n + "-";
            }
            if (name.length() > 1) {
                name = name.substring(0, name.length() - 1);
            }
        } else {
            name = names[0];
        }
        String name2search = "";
        String paraName = "";
        int i = name.indexOf("-");
        if (i == -1) {
            name2search = name;
        } else {
            name2search = name.substring(0, i);
            paraName = name.substring(i + 1, name.length());
        }
        for (Node<?> node : this.viewChilds) {
            if (node.getName() == null || !node.getName().equals(name2search)) continue;
            if (i == -1) {
                return node;
            }
            return node.getChildNamed(paraName);
        }
        return null;
    }

    @Override
    public Iterator<Node<?>> getFailSafeChildIterator() {
        return ((List)((ArrayList)this.viewChilds).clone()).iterator();
    }

    @Override
    public Iterator<Node<?>> getChilds() {
        return this.viewChilds.iterator();
    }

    @Override
    public List<Node<?>> getChildsAsList() {
        return this.viewChilds;
    }

    @Override
    public void kill() {
        for (Node<?> n : this.viewChilds) {
            n.removeAllListenersRecursivley();
            if (!(n instanceof ViewNode)) continue;
            n.kill();
        }
        this.viewChilds.clear();
        this.changeHandler = null;
    }

    @Override
    public boolean contains(Node<?> o) {
        for (Node<?> n : this.viewChilds) {
            if (o instanceof ViewNode && n instanceof ViewNode) {
                ViewNode v1 = (ViewNode)o;
                ViewNode v2 = (ViewNode)n;
                if (!v1.id.equals(v2.id)) continue;
                return true;
            }
            if (n == null || !n.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void commit() {
        for (Node<?> n : this.viewChilds) {
            n.commit();
        }
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
        this.updateValue();
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
        this.updateValue();
    }

    @Override
    public void valueChanged(Node<?> node) {
        this.updateValue();
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean isSwingOnly() {
        return false;
    }
}

