/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.CateringServiceTypeConverter;
import ch.icit.pegasus.client.converter.LegInfoConverter;
import ch.icit.pegasus.client.converter.LoadingGroupConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.ServiceDeliverableComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ACateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartChoiceComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.DayOfMonthRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.DayOfMonthRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixDurationRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixPeriodRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.IMealplanLegComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MonthRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MonthRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.PeriodRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.RotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.WeekdayRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.WeekdayRotationStrategyComplete;
import ch.icit.pegasus.server.core.exception.ValidationException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class MealPlanToolkit {
    public static List<ScreenValidationObject> validateLoadingGroupMapping(Map<ALoadingGroupComplete, ALoadingGroupComplete> mt, List<ALoadingGroupComplete> sourceGroups, List<ALoadingGroupComplete> targetGroups) {
        return MealPlanToolkit.validateLoadingGroupMapping(mt, sourceGroups, targetGroups, false);
    }

    public static List<ScreenValidationObject> validateLoadingGroupMapping(Map<ALoadingGroupComplete, ALoadingGroupComplete> mt, List<ALoadingGroupComplete> sourceGroups, List<ALoadingGroupComplete> targetGroups, boolean isTargetOptional) {
        return MealPlanToolkit.validateLoadingGroupMapping(mt, sourceGroups, targetGroups, isTargetOptional, null);
    }

    public static List<ScreenValidationObject> validateLoadingGroupMapping(Map<ALoadingGroupComplete, ALoadingGroupComplete> mt, List<ALoadingGroupComplete> sourceGroups, List<ALoadingGroupComplete> targetGroups, boolean isTargetOptional, List<ALoadingGroupComplete> stowedGroups) {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        LoadingGroupConverter converter = ConverterRegistry.getConverter(LoadingGroupConverter.class);
        if (!isTargetOptional) {
            for (ALoadingGroupComplete t : targetGroups) {
                if (mt.containsValue(t)) continue;
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Target Loading Group " + converter.convert(t, (Node<ALoadingGroupComplete>)null, new Object[0]) + " has not source"));
            }
        }
        for (ALoadingGroupComplete t : sourceGroups) {
            if (stowedGroups == null || !stowedGroups.contains(t) || mt.get(t) != null) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Source Loading Group " + converter.convert(t, (Node<ALoadingGroupComplete>)null, new Object[0]) + " has not target"));
        }
        HashSet<ALoadingGroupComplete> controlSet = new HashSet<ALoadingGroupComplete>();
        for (Map.Entry<ALoadingGroupComplete, ALoadingGroupComplete> entry : mt.entrySet()) {
            if (controlSet.add(entry.getValue())) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Duplicate Target Loading Group " + converter.convert(entry.getValue(), (Node<ALoadingGroupComplete>)null, new Object[0])));
        }
        return a;
    }

    public static String createPostfixServicePartString(CabinClassComplete cc, IMealplanLegComplete leg, ALoadingGroupComplete partType, CateringServiceTypeComplete type, boolean inList, CateringServicePartComplete pt) {
        String t = "";
        if (inList) {
            if (partType == null) {
                return "";
            }
            t = partType.getName();
        } else {
            t = MealPlanToolkit.createPrefixServicePartString(cc, leg, type);
            if (partType != null) {
                t = t + " " + partType.getName();
            }
        }
        if (partType.getMealType() != null) {
            t = t + " (" + partType.getMealType().getCode() + ")";
        }
        if (pt != null) {
            String p = "";
            for (CateringServicePartChoiceComplete c : pt.getChoices()) {
                switch (c.getCalculationType()) {
                    case FIX: {
                        p = p + ", Fix " + c.getFixAmount();
                        break;
                    }
                    case RATIO: {
                        DecimalFormat f = new DecimalFormat("0.##");
                        p = p + ", Ratio " + f.format(c.getRatio()) + "%";
                        break;
                    }
                    case STEP: {
                        p = p + ", Steps " + c.getSteps().size();
                    }
                }
            }
            if (!p.isEmpty()) {
                p = p.substring(2, p.length());
                t = t + " (" + p + ")";
            }
        }
        return t;
    }

    public static String createPostfixServicePartString(CabinClassComplete cc, List<? extends IMealplanLegComplete> legs, ALoadingGroupComplete partType, CateringServiceTypeComplete type, boolean inList, CateringServicePartComplete pt) {
        String t = "";
        if (inList) {
            if (partType == null) {
                return "";
            }
            t = partType.getName();
        } else {
            t = MealPlanToolkit.createPrefixServicePartString(cc, legs, type);
            if (partType != null) {
                t = t + " " + partType.getName();
            }
        }
        if (partType.getMealType() != null) {
            t = t + " " + partType.getMealType().getCode();
        }
        if (pt != null) {
            String p = "";
            for (CateringServicePartChoiceComplete c : pt.getChoices()) {
                switch (c.getCalculationType()) {
                    case FIX: {
                        p = p + ", Fix " + c.getFixAmount();
                        break;
                    }
                    case RATIO: {
                        DecimalFormat f = new DecimalFormat("0.##");
                        p = p + ", Ratio " + f.format(c.getRatio()) + "%";
                        break;
                    }
                    case STEP: {
                        p = p + ", Steps " + c.getSteps().size();
                    }
                }
            }
            if (!p.isEmpty()) {
                p = p.substring(2, p.length());
                t = t + " (" + p + ")";
            }
        }
        return t;
    }

    public static String createPrefixServicePartString(CabinClassComplete cc, IMealplanLegComplete leg, CateringServiceTypeComplete type) {
        return cc.getCode() + " " + leg.getDepartureAirport().getCode() + " " + leg.getArrivalAirport().getCode() + " " + type.getCode();
    }

    public static String createPrefixServicePartString(CabinClassComplete cc, List<? extends IMealplanLegComplete> legs, CateringServiceTypeComplete type) {
        String t = cc.getCode();
        for (IMealplanLegComplete iMealplanLegComplete : legs) {
            t = t + ", " + iMealplanLegComplete.getDepartureAirport().getCode() + " " + iMealplanLegComplete.getArrivalAirport().getCode();
        }
        t = t + " " + type.getCode();
        return t;
    }

    public static String createServicePartString(Node<?> type, boolean inList) {
        Node<?> p = null;
        if (type.getParent().getValue() instanceof ServiceDeliverableComplete) {
            p = type.getParent();
            ServiceDeliverableComplete d = (ServiceDeliverableComplete)p.getValue();
            if (d.getLoadingGroup().getContainingService() instanceof CateringServiceScheduleVariantComplete) {
                CabinClassComplete cc = d.getLoadingGroup().getContainingService().getCabinClass();
                List leg = ((CateringServiceScheduleVariantComplete)d.getLoadingGroup().getContainingService()).getLegs();
                ALoadingGroupComplete partType = d.getLoadingGroup();
                CateringServicePartComplete cpt = null;
                CateringServiceScheduleVariantComplete cssc = (CateringServiceScheduleVariantComplete)d.getLoadingGroup().getContainingService();
                if (!cssc.getRotations().isEmpty()) {
                    for (CateringServicePartComplete pt : ((CateringServiceRotationComplete)cssc.getRotations().get(0)).getParts()) {
                        if (pt.getLoadingGroup() == null || !pt.getLoadingGroup().equals((Object)partType)) continue;
                        cpt = pt;
                    }
                }
                return MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, d.getLoadingGroup().getContainingService().getType(), inList, cpt);
            }
            if (d.getLoadingGroup().getContainingService() instanceof CateringServiceComplete) {
                CabinClassComplete cc = d.getLoadingGroup().getContainingService().getCabinClass();
                List leg = ((CateringServiceComplete)d.getLoadingGroup().getContainingService()).getLegs();
                ALoadingGroupComplete partType = d.getLoadingGroup();
                CateringServicePartComplete cpt = null;
                CateringServiceComplete csc = (CateringServiceComplete)d.getLoadingGroup().getContainingService();
                for (CateringServicePartComplete pt : csc.getParts()) {
                    if (!pt.getLoadingGroup().equals((Object)partType)) continue;
                    cpt = pt;
                }
                return MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, d.getLoadingGroup().getContainingService().getType(), inList, cpt);
            }
        } else if (type.getParent().getParent().getParent().getValue() instanceof ACateringServiceComplete) {
            ACateringServiceComplete ser = (ACateringServiceComplete)type.getParent().getParent().getParent().getValue();
            if (ser instanceof CateringServiceScheduleVariantComplete) {
                CabinClassComplete cc = ser.getCabinClass();
                List leg = ((CateringServiceScheduleVariantComplete)ser).getLegs();
                ALoadingGroupComplete partType = ((CateringServicePartComplete)type.getParent().getParent().getParent().getValue()).getLoadingGroup();
                CateringServicePartComplete cpt = null;
                CateringServiceScheduleVariantComplete cssc = (CateringServiceScheduleVariantComplete)ser;
                for (CateringServicePartComplete pt : ((CateringServiceRotationComplete)cssc.getRotations().get(0)).getParts()) {
                    if (!pt.getLoadingGroup().equals((Object)partType)) continue;
                    cpt = pt;
                }
                return MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, ser.getType(), inList, cpt);
            }
            if (ser instanceof CateringServiceComplete) {
                CabinClassComplete cc = ser.getCabinClass();
                List leg = ((CateringServiceComplete)ser).getLegs();
                ALoadingGroupComplete partType = ((CateringServicePartComplete)type.getParent().getValue()).getLoadingGroup();
                CateringServicePartComplete cpt = null;
                CateringServiceComplete csc = (CateringServiceComplete)ser;
                for (CateringServicePartComplete pt : csc.getParts()) {
                    if (!pt.getLoadingGroup().equals((Object)partType)) continue;
                    cpt = pt;
                }
                return MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, ser.getType(), inList, cpt);
            }
        } else {
            p = type.getParent().getParent().getParent().getParent().getParent();
            CateringServiceScheduleVariantComplete ser = (CateringServiceScheduleVariantComplete)p.getValue();
            CabinClassComplete cc = ser.getCabinClass();
            List leg = ser.getLegs();
            ALoadingGroupComplete partType = (ALoadingGroupComplete)type.getValue();
            CateringServicePartComplete pt = (CateringServicePartComplete)type.getParent().getValue();
            return MealPlanToolkit.createPostfixServicePartString(cc, leg, partType, ser.getType(), inList, pt);
        }
        return "";
    }

    public static String createServiceGroupString(CabinClassComplete cc, ALegComplete leg, CateringServiceTypeComplete type) {
        CabinClassConverter ccConv = ConverterRegistry.getConverter(CabinClassConverter.class);
        LegInfoConverter legConv = ConverterRegistry.getConverter(LegInfoConverter.class);
        CateringServiceTypeConverter typeConv = ConverterRegistry.getConverter(CateringServiceTypeConverter.class);
        return (String)ccConv.convert(cc, null, new Object[]{false}) + " " + (String)legConv.convert(leg, null, new Object[0]) + " " + (String)typeConv.convert(type, null, new Object[0]);
    }

    public static String createServiceGroupString(CabinClassComplete cc, List<? extends ALegComplete> leg, CateringServiceTypeComplete type) {
        CabinClassConverter ccConv = ConverterRegistry.getConverter(CabinClassConverter.class);
        LegInfoConverter legConv = ConverterRegistry.getConverter(LegInfoConverter.class);
        CateringServiceTypeConverter typeConv = ConverterRegistry.getConverter(CateringServiceTypeConverter.class);
        String t = (String)ccConv.convert(cc, null, new Object[]{false});
        for (ALegComplete aLegComplete : leg) {
            t = t + ", " + (String)legConv.convert(aLegComplete, null, new Object[0]);
        }
        t = t + " " + (String)typeConv.convert(type, null, new Object[0]);
        return t;
    }

    public static List<CateringServiceRotationComplete> resolveRotations(CateringServiceScheduleVariantComplete s, Timestamp validity) {
        ArrayList<CateringServiceRotationComplete> rs = new ArrayList<CateringServiceRotationComplete>();
        DateTime stdDateTime = new DateTime(validity.getTime());
        RotationStrategyComplete strategy = s.getRotationStrategy();
        List rotations = s.getRotations();
        Collections.sort(rotations);
        CateringServiceRotationComplete rotation = null;
        if (strategy instanceof DayOfMonthRotationStrategyComplete) {
            rotation = MealPlanToolkit.resolveDayOfMonthRotation(rotations, stdDateTime);
        } else if (strategy instanceof FixPeriodRotationStrategyComplete) {
            rotation = MealPlanToolkit.resolveFixPeriodRotation((FixPeriodRotationStrategyComplete)strategy, stdDateTime);
        } else if (strategy instanceof FixRotationStrategyComplete) {
            FixRotationStrategyComplete fixStrategy = (FixRotationStrategyComplete)strategy;
            DateTime startDate = new DateTime(fixStrategy.getStartDate().getTime());
            rotation = MealPlanToolkit.resolveFixRotation(rotations, startDate, stdDateTime);
        } else if (strategy instanceof MonthRotationStrategyComplete) {
            rotation = MealPlanToolkit.resolveMonthRotation(rotations, stdDateTime);
        } else if (strategy instanceof WeekdayRotationStrategyComplete) {
            rotation = MealPlanToolkit.resolveWeekdayRotation(rotations, stdDateTime);
        }
        if (rotation != null) {
            rs.add(rotation);
        }
        return rs;
    }

    public static CateringServiceRotationComplete resolveFixRotation(List<CateringServiceRotationComplete> rotations, DateTime startDate, DateTime std) {
        DateTime currentDate;
        int numRotations;
        int n = numRotations = rotations == null ? 0 : rotations.size();
        if (numRotations == 0) {
            return null;
        }
        if (startDate.isEqual((ReadableInstant)std) || numRotations == 1) {
            return rotations.get(0);
        }
        Period[] periods = new Period[numRotations];
        int i = 0;
        for (CateringServiceRotationComplete r : rotations) {
            FixDurationRotationComplete fdr = (FixDurationRotationComplete)r.getRotationStrategy();
            Period p = CalendarUtil.getPeriod(fdr.getDuration());
            periods[i++] = p;
        }
        DateTime oldDate = currentDate = startDate;
        assert (currentDate.isBefore((ReadableInstant)std));
        while (currentDate.isBefore((ReadableInstant)std)) {
            for (i = 0; i < numRotations; ++i) {
                Period p = periods[i];
                if (oldDate.equals((Object)(currentDate = currentDate.plus((ReadablePeriod)p)))) {
                    throw new ValidationException("Invalid Fix Rotation Duration for '" + rotations.get(i) + "'!");
                }
                oldDate = currentDate;
                if (!currentDate.equals((Object)std) && !currentDate.isAfter((ReadableInstant)std)) continue;
                return rotations.get(i);
            }
        }
        throw new IllegalStateException();
    }

    public static CateringServiceRotationComplete resolveWeekdayRotation(List<CateringServiceRotationComplete> rotations, DateTime std) {
        int day = std.getDayOfWeek() - 1;
        for (CateringServiceRotationComplete rotation : rotations) {
            WeekdayRotationComplete wr = (WeekdayRotationComplete)rotation.getRotationStrategy();
            Boolean res = wr.getDates()[day];
            if (res == null || !res.booleanValue()) continue;
            return rotation;
        }
        return null;
    }

    public static CateringServiceRotationComplete resolveDayOfMonthRotation(List<CateringServiceRotationComplete> rotations, DateTime std) {
        int day = std.getDayOfMonth();
        int month = std.getMonthOfYear();
        boolean even = month % 2 == 0;
        for (CateringServiceRotationComplete rotation : rotations) {
            DayOfMonthRotationComplete domr = (DayOfMonthRotationComplete)rotation.getRotationStrategy();
            if (!even ? domr.getUseOddMonths() == false : domr.getUseEvenMonths() == false) continue;
            Boolean res = domr.getDates()[day - 1];
            if (res == null || !res.booleanValue()) continue;
            return rotation;
        }
        return null;
    }

    public static CateringServiceRotationComplete resolveMonthRotation(List<CateringServiceRotationComplete> rotations, DateTime std) {
        int month = std.getMonthOfYear() - 1;
        for (CateringServiceRotationComplete rotation : rotations) {
            MonthRotationComplete mr = (MonthRotationComplete)rotation.getRotationStrategy();
            Boolean res = mr.getDates()[month];
            if (res == null || !res.booleanValue()) continue;
            return rotation;
        }
        return null;
    }

    public static CateringServiceRotationComplete resolveFixPeriodRotation(FixPeriodRotationStrategyComplete strategy, DateTime std) {
        List periods = strategy.getPeriods();
        Collections.sort(periods);
        for (PeriodRotationComplete p : periods) {
            if (!CalendarUtil.isBetween(p.getPeriod(), std)) continue;
            return p.getRotation();
        }
        return null;
    }

    public static Integer getCurrentCycle(Node<CateringServiceScheduleVariantComplete> node, Timestamp timestamp) {
        List<CateringServiceRotationComplete> rs = MealPlanToolkit.resolveRotations(node.getValue(), timestamp);
        if (rs.isEmpty()) {
            return null;
        }
        return rs.get(0).getNumber();
    }
}

