/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.ejb;

import ch.icit.pegasus.server.core.util.StringUtil;
import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.selector.misc.BufferedProxySelector;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyToolkit {
    private static final Logger log = LoggerFactory.getLogger(ProxyToolkit.class);

    public static boolean useProxy() {
        boolean useProxy = ProxySearch.getDefaultProxySearch().getProxySelector() != null;
        return useProxy;
    }

    public static Proxy createProxyForURL(String url) {
        if (!ProxyToolkit.useProxy()) {
            return null;
        }
        log.info("Search Proxy Configuration for " + url);
        try {
            System.setProperty("java.net.useSystemProxies", "true");
            ProxySearch ps = ProxySearch.getDefaultProxySearch();
            ps.setPacCacheSettings(32, 300000L, BufferedProxySelector.CacheScope.CACHE_SCOPE_HOST);
            if (ps.getProxySelector() == null) {
                log.info("No Proxy selector found");
                return null;
            }
            List<Proxy> l = ps.getProxySelector().select(new URI(url));
            for (Proxy proxy : l) {
                log.info("Found Proxy with Type : " + (Object)((Object)proxy.type()));
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null) {
                    log.info("No Proxy address found");
                } else {
                    log.info("Proxy Hostname : " + addr.getHostName());
                    log.info("Proxy Port : " + addr.getPort());
                }
                if (proxy.type() != Proxy.Type.HTTP) continue;
                log.info("Take HTTP Proxy");
                return proxy;
            }
        }
        catch (Exception e) {
            log.error("Unable to create Proxy for URL", (Throwable)e);
        }
        return null;
    }

    public static void tryToSetProxyByProperty(String url) {
        if (!ProxyToolkit.useProxy()) {
            return;
        }
        log.info("Try to install Proxy to Property " + url);
        Proxy proxyForURL = ProxyToolkit.createProxyForURL(url);
        if (proxyForURL != null) {
            InetSocketAddress addr = (InetSocketAddress)proxyForURL.address();
            if (addr != null) {
                log.info("Found Proxy for URL: " + url + " = " + addr.getAddress());
                ProxyToolkit.initProxyByProperty(addr.getHostName(), "" + addr.getPort());
            } else {
                log.info("No Proxy found for URL: " + url);
            }
        } else {
            log.info("No Proxy found for URL: " + url);
        }
    }

    public static void initProxyByProperty(String proxyHost, String proxyPort) {
        if (!ProxyToolkit.useProxy()) {
            return;
        }
        System.setProperty("java.net.useSystemProxies", "true");
        if (!StringUtil.isBlank((String)proxyHost) && !StringUtil.isBlank((String)proxyPort)) {
            System.getProperties().setProperty("http.proxyHost", proxyHost);
            System.getProperties().setProperty("http.proxyPort", proxyPort);
            System.getProperties().setProperty("https.proxyHost", proxyHost);
            System.getProperties().setProperty("https.proxyPort", proxyPort);
            log.info("System Proxies are set: " + proxyHost + ":" + proxyPort);
        }
    }

    public static String getProxyHostFromProperty() {
        return (String)System.getProperties().get("http.proxyHost");
    }

    public static String getProxyPortFromProperty() {
        return (String)System.getProperties().get("http.proxyPort");
    }
}

