/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.node.impls;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.node.LogicNodeOperation;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.utils.OperationSorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HumanNodeOperation {
    private Long timestamp;
    private List<LogicNodeOperation> operations = new ArrayList<LogicNodeOperation>();
    private String id;

    public HumanNodeOperation(String id) {
        this.id = id;
        this.timestamp = System.currentTimeMillis();
    }

    public void addLogicNodeOperation(LogicNodeOperation op) {
        this.operations.add(op);
    }

    public void getScheduledEvents() {
        Collections.sort(this.operations, ComparatorRegistry.getComparator(OperationSorter.class));
        for (LogicNodeOperation op : this.operations) {
            switch (op.getSelectedOperation()) {
                case 5: {
                    Node<?> newChild = op.getCurrentNode();
                    Node newParent = op.getNewParent();
                    newParent.fireChildAddedEvent(newChild, null);
                    break;
                }
                case 7: {
                    Node<?> oldChild = op.getCurrentNode();
                    Node oldParent = op.getOldParent();
                    oldParent.fireChildRemovedEvent(oldChild);
                    break;
                }
                case 3: {
                    Node<?> currentNode = op.getCurrentNode();
                    Object newValue = op.getNewValue();
                    currentNode.fireDataChangedEvent(false, new NodeListener[0]);
                }
            }
        }
    }
}

