/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.node.impls;

import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.ObjectWrapper;
import ch.icit.pegasus.client.node.impls.CommitNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.AEmbeddedDTO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListNode<T extends Collection<V>, V>
extends CommitNode<T> {
    private static final Logger log = LoggerFactory.getLogger(ListNode.class);

    public ListNode() {
    }

    public ListNode(Field f) {
        super(f);
    }

    @Override
    public void addChild(Node<?> child, long id) {
        child.setListChild(true);
        super.addChild(child, id);
    }

    public void initList() {
        for (Collection child : this.data) {
            for (Object c : child) {
                Node n = INodeCreator.getDefaultImpl().getNode4DTO(c, true, false);
                this.children.add(n);
            }
        }
    }

    @Override
    public void getAllChildAddEventsFor(NodeListener listener, String ... childs) {
        Collection l = this.getValue(Collection.class);
        if (l != null) {
            for (Object o : l) {
                if (o == null || this.hasChild4Value(o)) continue;
                Node n = INodeCreator.getDefaultImpl().getNode4DTO(o, true, this.isProxyList());
                this.addChildSilent(n, null, true, 0L);
            }
        }
        if (listener != null) {
            this.getAllChildAddEvents(listener);
        }
    }

    @Override
    public void propagateCommit(Object d, List<Node<?>> list, boolean ignorProx, Map<Class<?>, Class<?>> classMapping) {
        if (!list.contains(this)) {
            list.add(this);
            ArrayList nl = new ArrayList();
            Iterator<Node<?>> it = this.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node<?> n = it.next();
                if (n != null) {
                    Class<?> nc;
                    Object dto = d;
                    dto = n.getValue();
                    if (classMapping != null && dto != null && (nc = classMapping.get(dto.getClass())) != null) {
                        Object ndto = n.getValue(nc);
                        if (ndto != null) {
                            dto = ndto;
                        } else {
                            ndto = n.getValue(dto.getClass());
                            if (ndto != null) {
                                dto = ndto;
                            }
                        }
                    }
                    if (n instanceof CommitNode) {
                        CommitNode n2 = (CommitNode)n;
                        n2.propagateCommit(dto, list, ignorProx, classMapping);
                    }
                }
                if (n == null) continue;
                Object a = n.getValue();
                nl.add(a);
            }
            this.setValueSilent(nl, true, 0L, null);
        }
    }

    @Override
    public void updateNode(List<Node<?>> registry) {
        if (registry == null) {
            registry = new ArrayList();
        }
        if (!registry.contains(this)) {
            registry.add(this);
            ArrayList l = null;
            try {
                ArrayList value = (ArrayList)this.getValue();
                if (value instanceof Collection) {
                    l = value;
                }
                if (l == null) {
                    l = new ArrayList();
                }
            }
            catch (ClassCastException e) {
                log.error("Unable to update Node", (Throwable)e);
            }
            if (l != null) {
                for (Object o : l) {
                    if (this.hasChild4Value(o)) continue;
                    Node nc = INodeCreator.getDefaultImpl().getNode4DTO(o, true, this.isProxyList());
                    this.addChild(nc, 0L);
                }
            }
            Iterator<Node<?>> it = this.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node<?> n = it.next();
                Object o = n.getValue();
                boolean found = false;
                if (o instanceof ADTO || o instanceof AEmbeddedDTO) {
                    ObjectWrapper ow = new ObjectWrapper(o);
                    for (Object oo : new ArrayList(l)) {
                        if (!o.equals(oo)) {
                            ObjectWrapper oow = new ObjectWrapper(oo);
                            if (!ow.equals(oow)) continue;
                            found = true;
                            n.setValue(oo, 0L);
                            if (n instanceof ProxyNode) continue;
                            n.updateNode(registry);
                            continue;
                        }
                        found = true;
                        n.removeExistingValues();
                        n.setValue(oo, 0L);
                        if (n instanceof ProxyNode) continue;
                        n.updateNode(registry);
                    }
                } else {
                    for (Object oo : l) {
                        if (oo == null || !oo.equals(o)) continue;
                        found = true;
                        n.setValue(oo, 0L);
                        if (n instanceof ProxyNode) continue;
                        n.updateNode(registry);
                    }
                }
                if (found) continue;
                this.removeChild(n, 0L);
            }
        }
    }
}

