/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.file;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.file.FileServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.services.file.FileService;
import java.net.URI;
import javax.activation.DataHandler;

public class FileServiceManagerImpl
implements FileServiceManager {
    public DataHandler downloadFile(URI uri) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FileService.class).downloadFile(uri);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.LOAD);
        }
    }

    public void uploadFile(PegasusFileComplete fileReference, byte[] imageBytes) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FileService.class).uploadFile(fileReference, imageBytes);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.CREATE);
        }
    }

    @Override
    public void remove(PegasusFileComplete file) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(FileService.class).remove(file);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.ACTION);
        }
    }

    @Override
    public PegasusFileComplete find(URI uri) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FileService.class).find(uri);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.SEARCH);
        }
    }

    @Override
    public PegasusFileComplete update(PegasusFileComplete file) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FileService.class).update(file);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public boolean exists(URI uri) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FileService.class).exists(uri);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public <T extends PegasusFileComplete> T create(T file) throws ClientServerCallException {
        try {
            return (T)EjbContextFactory.getInstance().getStatelessService(FileService.class).create(file);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e, ClientExceptionType.CREATE);
        }
    }

    @Override
    public PegasusFileComplete clone(PegasusFileComplete file) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(FileService.class).clone(file);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e, ClientExceptionType.ACTION);
        }
    }
}

