/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.report;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCountReceiptComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionReference;
import ch.icit.pegasus.server.core.dtos.report.InOutAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.InventoryDetailsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.InventoryDifferenceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.InventoryReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.report.InventoryReportService;

public class InventoryReportServiceManagerImpl
implements InventoryReportServiceManager {
    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryOverviewReport(InventoryDifferenceReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryOverviewReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getCustomerInventoryReport(InventoryLight inventory, CustomerLight customer, boolean customerOwnedOnly, boolean nominatedOnly, boolean bondedOnly) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getCustomerInventoryReport(inventory, customer, customerOwnedOnly, nominatedOnly, bondedOnly);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryTransactionsChargeReport(ListWrapper<InventoryReference> transitions) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryTransactionsChargeReport(transitions);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryTransactionsDetailsReport(ListWrapper<InventoryTransitionReference> transitions) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryTransactionsDetailsReport(transitions);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryDifferenceReport(InventoryDifferenceReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryDifferenceReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryTransactionsReport(InventoryDetailsReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryTransactionsReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryStoreOverviewReport(InventoryReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryStoreOverviewReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryStoreDetailsReport(InventoryReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryStoreDetailsReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInOutAnalysisReport(InOutAnalysisReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInOutAnalysisReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryHistory(InventoryDetailsReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryHistory(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getInventoryTransactionsIncludeExcludeReport(InventoryDetailsReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryTransactionsIncludeExcludeReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<InventoryCountReceiptComplete> getInventoryCountReceipts(InventoryReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryReportService.class).getInventoryCountReceipts(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void addInventoryCountReceipt(InventoryReference ref, PegasusFileComplete file, StoreReference storeReference, boolean hasErrors) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(InventoryReportService.class).addInventoryCountReceipt(ref, file, storeReference, hasErrors);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

