/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.report;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.template.OrderTemplateReference;
import ch.icit.pegasus.server.core.dtos.report.ArticleLabelsOnStockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ChargeLabelConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ManualMovementLabelConfiguration;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderLabelConfiguration;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderOpenPositionReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderReceivingReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.RequisitionOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.SupplierPurchaseDetailsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.PurchaseAllergenAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.PurchaseHACCPAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapBatchPositionConfiguration;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapLabelConfiguration;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.report.OrderReportService;

public class OrderReportServiceManagerImpl
implements OrderReportServiceManager {
    @Override
    public void sendPurchaseOrderMail(PurchaseOrderReference purchaseOrderReference, UserReference user) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(OrderReportService.class).sendPurchaseOrderMail(purchaseOrderReference, user);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createArticleLabelsForMovement(ManualMovementLabelConfiguration conf) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createArticleLabelsForMovement(conf);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createHalalCheckReport(PurchaseAllergenAnalysisReportConfiguration reportConfiguration) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createHalalCheckReport(reportConfiguration);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createAllergenCheckReport(PurchaseAllergenAnalysisReportConfiguration reportConfiguration) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createAllergenCheckReport(reportConfiguration);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createHACCPCheckReport(PurchaseHACCPAnalysisReportConfiguration reportConfiguration) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createHACCPCheckReport(reportConfiguration);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDailyOpsSheetCACP(PurchaseOrderOpenPositionReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createDailyOpsSheetCACP(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDailyOpsSheetHACCP(PurchaseOrderOpenPositionReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createDailyOpsSheetHACCP(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createStockSwapBatchPositionReport(ArticleStockSwapBatchPositionConfiguration conf) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createStockSwapBatchPositionReport(conf);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createArticleLabelsForStockSwap(ArticleStockSwapLabelConfiguration conf) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createArticleLabelsForStockSwap(conf);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPurchaseReceiveList(PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createPurchaseReceiveList(period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRequisitionDeliverDailyOps(RequisitionOrderReportConfiguration p) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createRequisitionDeliverDailyOps(p);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createArticleLabels(StockCheckinGroupReference order, ReportFileComplete file, int startPosition, boolean includeBarCode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createArticleLabels(order, file, startPosition, includeBarCode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDailyLabels(PurchaseOrderOpenPositionReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createDailyLabels(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createOpenRequisitionPositionReport(ListWrapper<RequisitionOrderReference> references) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createOpenRequisitionPositionReport(references);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createReceiveReport(ListWrapper<PurchaseOrderReference> purchaseOrderReferences, BondedStateE value) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createReceiveReport(purchaseOrderReferences, value);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createOpenPositionReport(ListWrapper<PurchaseOrderReference> purchaseOrderReferences, BondedStateE value) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createOpenPositionReport(purchaseOrderReferences, value);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPurchaseOrderPreview(ListWrapper<PurchaseOrderComplete> orders) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createPurchaseOrderPreview(orders);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRequisitionDetailsReport(ListWrapper<RequisitionOrderReference> references) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createRequisitionDetailsReport(references);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createArticleLabelsForCharge(ChargeLabelConfiguration conf) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createArticleLabelsForCharge(conf);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getPurchaseOrderTemplatePositions(ListWrapper<OrderTemplateReference> flights) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).getPurchaseOrderTemplatePositions(flights);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPurchaseAnalysisByArticle(ListWrapper<BasicArticleReference> articles, PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createPurchaseAnalysisByArticle(articles, period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createArticleLabelsForPurchase(PurchaseOrderLabelConfiguration conf) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createArticleLabelsForPurchase(conf);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createArticleLabelsForArticlesOnStock(ArticleLabelsOnStockReportConfiguration conf) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createArticleLabelsForArticlesOnStock(conf);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDailyOpsSheet(PurchaseOrderOpenPositionReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createDailyOpsSheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPurchaseOrderReceivingWorksheet(PurchaseOrderReceivingReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createPurchaseOrderReceivingWorksheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPurchaseOrderSheet(PurchaseOrderReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createPurchaseOrderSheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPurchaseOrderDetailsAnalysis(SupplierPurchaseDetailsReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createPurchaseOrderDetailsAnalysis(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRequisitionOrderDeliverSheet(RequisitionOrderReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createRequisitionOrderDeliverSheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRequisitionOrderReceiveSheet(RequisitionOrderReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createRequisitionOrderReceiveSheet(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getRequisitionOrder(RequisitionOrderReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).getRequisitionOrder(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createRequisitionOrderChanges(RequisitionOrderReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createRequisitionOrderChanges(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createPurchaseOrderChanges(PurchaseOrderReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderReportService.class).createPurchaseOrderChanges(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

