/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceWithBarCodeSupportManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.RequisitionPositionInfoComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.system.OrderServiceWithBarCodeSupportService;

public class OrderServiceWithBarCodeSupportManagerImpl
implements OrderServiceWithBarCodeSupportManager {
    @Override
    public OptionalWrapper<RequisitionOrderComplete> getRequisitionForBarCode(String requisitionBarcode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderServiceWithBarCodeSupportService.class).getRequisitionForBarCode(requisitionBarcode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StoreLight> getStoreForBarCode(String storeBarcode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderServiceWithBarCodeSupportService.class).getStoreForBarCode(storeBarcode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionPositionInfoComplete> getPositionForBarCode(String orderPositionBarcode, StoreLight store, RequisitionOrderLight order) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderServiceWithBarCodeSupportService.class).getPositionForBarCode(orderPositionBarcode, store, order);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RequisitionOrderPositionComplete> savePositionForBarCode(RequisitionOrderPositionComplete position, ArticleChargeLight charge, StorePositionLight storePosition, QuantityComplete quantity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(OrderServiceWithBarCodeSupportService.class).savePositionForBarCode(position, charge, storePosition, quantity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void closeDeliverRequisition(RequisitionOrderReference requisition, StoreLight deliverStore) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(OrderServiceWithBarCodeSupportService.class).closeDeliverRequisition(requisition, deliverStore);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void closeReceiveRequisition(RequisitionOrderReference requisitionRef) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(OrderServiceWithBarCodeSupportService.class).closeReceiveRequisition(requisitionRef);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

