/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.tradegoods;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tradegoods.TradeGoodsServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsComplete;
import ch.icit.pegasus.server.core.dtos.tradegoods.TradeGoodsLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.tradegoods.TradeGoodsService;

public class TradeGoodsServiceManagerImpl
implements TradeGoodsServiceManager {
    @Override
    public OptionalWrapper<TradeGoodsComplete> createTradeGoods(TradeGoodsComplete goods) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(TradeGoodsService.class).createTradeGoods(goods);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<TradeGoodsComplete> updateTradeGoods(TradeGoodsComplete goods) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(TradeGoodsService.class).updateTradeGoods(goods);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<TradeGoodsComplete> getComplete(TradeGoodsLight goods) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(TradeGoodsService.class).getComplete(goods);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

