/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;

public class SupplierConditionOrderCostsConverter
implements Converter<SupplierConditionComplete, String> {
    @Override
    public String convert(SupplierConditionComplete o, Node<SupplierConditionComplete> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        Node<?> currentArticle = currentNode.getChildNamed("currentArticle");
        UnitComplete priceUnit = null;
        if (currentArticle != null && currentArticle.getValue() != null) {
            priceUnit = ((BasicArticleLight)currentArticle.getValue()).getPriceUnit();
        }
        if (priceUnit == null) {
            priceUnit = currentNode.getValue().getOrderUnit();
        }
        String preForm = o.getSupplier().getNumber() + " " + o.getSupplier().getName();
        if (o.getStepPrice().getSteps().isEmpty()) {
            PriceComplete np = new PriceComplete(o.getSupplier().getPaymentCurrency(), Double.valueOf(0.0));
            return preForm + " => " + np.getFormattedPrice() + " " + np.getCurrency().getCode() + "/" + priceUnit.getShortName();
        }
        PriceComplete np = ((StepPriceFunctionComplete)o.getStepPrice().getSteps().get(0)).getPrice();
        preForm = preForm + " => " + np.getFormattedPrice() + " " + np.getCurrency().getCode() + "/" + priceUnit.getShortName();
        if (o.getCategoryTaxZone() != null) {
            preForm = preForm + " " + o.getCategoryTaxZone().getCode();
        }
        if (o.getCategoryComment() != null) {
            preForm = preForm + ", " + o.getCategoryComment();
        }
        return preForm;
    }

    @Override
    public Class<? extends SupplierConditionComplete> getParameterClass() {
        return SupplierConditionComplete.class;
    }
}

