/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.node.impls;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.LogicNodeOperation;
import ch.icit.pegasus.client.node.NodeValidator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.PegasusNode;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import ch.icit.util.Invoker;
import ch.icit.util.InvokerException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class Node<T> {
    private boolean manuallyAdded;
    protected Converter<T, String> converter;
    protected List<T> data = new ArrayList<T>();
    protected boolean isListChild = false;
    private Node<?> parent;
    private static boolean disableEvents = false;
    private Field originField;
    private String name = "";
    protected NodeValidator<T> validator;
    protected List<Node<?>> allAddedChilds = new ArrayList();
    protected List<Node<?>> children = new ArrayList();
    protected List<NodeListener> listeners = new ArrayList<NodeListener>();
    private boolean isPermanent;
    private boolean eventsEnabled = true;
    private boolean isProxyList = false;
    private boolean haveChanges;

    public Node(Field originField) {
        this();
        this.originField = originField;
    }

    public Node() {
        NodeToolkit.treeOfLife.add(this);
    }

    public Field getOriginField() {
        return this.originField;
    }

    public void setOriginField(Field field) {
        this.originField = field;
    }

    public boolean isManuallyAdded() {
        return this.manuallyAdded;
    }

    public void setManuallyAdded(boolean b) {
        this.manuallyAdded = b;
    }

    protected Object getObjectFromList4Node(List<Object> list) {
        T v = this.getValue();
        if (list != null) {
            for (Object o : list) {
                if (!o.equals(v)) continue;
                return o;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String t) {
        this.name = t;
    }

    public void setName(DtoField t) {
        this.name = t.getFieldName();
    }

    public void updateView() {
        this.updateView(new ArrayList<Node>());
    }

    public void updateView(List<Node> registry) {
        if (registry == null) {
            registry = new ArrayList<Node>();
        }
        registry.add(this);
        for (Node<?> c : this.children) {
            if (registry.contains(c)) continue;
            c.updateView(registry);
        }
        this.fireDataChangedEvent(false, new NodeListener[0]);
    }

    public void kill() {
        if (this.isPermanent) {
            throw new IllegalStateException();
        }
        INodeCreator.getDefaultImpl().removeNodeFromList(this, this.getValue());
        NodeToolkit.treeOfLife.remove(this);
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.converter = null;
        this.parent = null;
        this.originField = null;
        this.name = null;
        this.validator = null;
        this.allAddedChilds.clear();
        this.children.clear();
        this.listeners.clear();
    }

    public Node<?> getParent() {
        return this.parent;
    }

    public void setParent(Node<?> parent) {
        this.parent = parent;
    }

    public T getValue() {
        if (this.data.size() > 0) {
            try {
                return this.data.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public <V> V getValue(Class<V> searchedType) {
        for (int i = 0; i < this.data.size(); ++i) {
            T o = this.data.get(i);
            if (o == null || searchedType == null || !searchedType.isAssignableFrom(o.getClass())) continue;
            return (V)o;
        }
        return null;
    }

    public Object getValueForNamed(DtoField dtoField) {
        return this.getValueForNamed(dtoField.getFieldName());
    }

    public Object getValueForNamed(String vName) {
        if (this.data != null && vName != null) {
            int ii = vName.indexOf("-");
            if (ii != -1) {
                int i;
                String[] s = vName.split("-");
                Object currentO = null;
                for (i = 0; i < this.data.size(); ++i) {
                    try {
                        T d = this.data.get(i);
                        if (d == null) continue;
                        Object o = Invoker.getFieldValue((String)s[0], this.data.get(i));
                        if (o == null) {
                            o = Invoker.getMethodValue((String)s[0], this.data.get(i));
                        }
                        if (o == null) continue;
                        currentO = o;
                        continue;
                    }
                    catch (InvokerException d) {
                        // empty catch block
                    }
                }
                if (currentO != null) {
                    for (i = 1; i < s.length; ++i) {
                        try {
                            Object o = Invoker.getFieldValue((String)s[i], currentO);
                            if (o == null) {
                                o = Invoker.getMethodValue((String)s[i], (Object)currentO);
                            }
                            currentO = o;
                            continue;
                        }
                        catch (InvokerException invokerException) {
                            // empty catch block
                        }
                    }
                }
                return currentO;
            }
            for (int i = 0; i < this.data.size(); ++i) {
                T d = this.data.get(i);
                if (d == null) continue;
                try {
                    Object o = Invoker.getFieldValue((String)vName, d);
                    if (o == null) {
                        o = Invoker.getMethodValue((String)vName, d);
                    }
                    if (o != null) {
                        return o;
                    }
                    continue;
                }
                catch (InvokerException invokerException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setConverter(Converter<T, String> c) {
        this.converter = c;
    }

    public void setConverter(Class<? extends Converter<T, String>> clazz) {
        this.converter = ConverterRegistry.getConverter(clazz);
    }

    public Converter<T, String> getConverter() {
        return this.converter;
    }

    public boolean isListChild() {
        return this.isListChild;
    }

    public void setListChild(boolean b) {
        this.isListChild = b;
    }

    public String toString() {
        Object o = this.getFormattedValue();
        if (o instanceof String) {
            return (String)o;
        }
        return "-";
    }

    public Object getFormattedValue() {
        if (this.getConverter() == null) {
            return this.getValue();
        }
        Class<T> parameterClass = this.getConverter().getParameterClass();
        T value = parameterClass == null ? this.getValue() : this.getValue(parameterClass);
        return this.getConverter().convert(value, this, null);
    }

    public <E> Node<E> getChildNamed(DtoField<E> dtoField) {
        return this.getChildNamed(dtoField.getFieldName());
    }

    public Node<?> getChildNamed(DtoField<?> ... dtoField) {
        ArrayList<String> strings = new ArrayList<String>();
        for (DtoField<?> dtoField2 : dtoField) {
            strings.add(dtoField2.getFieldName());
        }
        return this.getChildNamed(strings.toArray(new String[strings.size()]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node<?> getChildNamed(String ... names) {
        String name = "";
        if (names.length > 1) {
            for (String n : names) {
                name = name + n + "-";
            }
            if (name.length() > 1) {
                name = name.substring(0, name.length() - 1);
            }
        } else {
            name = names[0];
        }
        String name2search = "";
        String paraName = "";
        int i = name.indexOf("-");
        if (i == -1) {
            name2search = name;
        } else {
            name2search = name.substring(0, i);
            paraName = name.substring(i + 1, name.length());
        }
        Iterator<Node<?>> it = this.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node<?> node = it.next();
            if (node == null || node.getName() == null || !node.getName().equals(name2search)) continue;
            if (i == -1) {
                return node;
            }
            return node.getChildNamed(paraName);
        }
        if (this.data == null) return null;
        int j = 0;
        while (j < this.data.size()) {
            Node<Object> child = null;
            try {
                T d = this.data.get(j);
                if (d != null) {
                    Field f = Invoker.getField(d.getClass(), (String)name2search);
                    Object nValue = null;
                    boolean isProxy = false;
                    if (f == null) {
                        nValue = Invoker.getMethodValue((String)name2search, this.data.get(j));
                        Node<Object> nChild = INodeCreator.getDefaultImpl().getNode4DTO(nValue, this instanceof ListNode, isProxy);
                        if (nChild == null) {
                            throw new IllegalStateException("Unable to create new child named " + name2search);
                        }
                        nChild.setName(name2search);
                        if (nChild instanceof ProxyNode && ((ProxyNode)nChild).getRefNode() == null) {
                            Node org = INodeCreator.getDefaultImpl().getNodeDirectly(((ProxyNode)nChild).getSource());
                            ((ProxyNode)nChild).setRefNode(org);
                        }
                        child = nChild;
                    } else {
                        ClientLogicNodeMode annotation = f.getAnnotation(ClientLogicNodeMode.class);
                        isProxy = annotation != null && (annotation.type() == ClientLogicNodeModes.PROXYNODE || annotation.type() == ClientLogicNodeModes.PROXYLIST);
                        nValue = Invoker.getFieldValue((Field)f, d);
                        Node<?> nChild = INodeCreator.getDefaultImpl().getNode4Field(f, this, nValue, isProxy, this instanceof ListNode);
                        if (nChild == null) {
                            throw new IllegalStateException("Unable to create new child named " + name2search);
                        }
                        nChild.setName(f.getName());
                        if (nChild instanceof ProxyNode && ((ProxyNode)nChild).getRefNode() == null) {
                            Node org = INodeCreator.getDefaultImpl().getNodeDirectly(((ProxyNode)nChild).getSource());
                            ((ProxyNode)nChild).setRefNode(org);
                        }
                        child = nChild;
                    }
                    if (nValue == null) {
                        // empty if block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (child != null) {
                this.addChildSilent(child, null, true, 0L);
                if (paraName.equals("")) return child;
                return child.getChildNamed(paraName);
            }
            ++j;
        }
        return null;
    }

    public void getAllChildAddEventsFor(NodeListener listener, String ... names) {
        if (this instanceof ListNode) {
            if (listener != null) {
                this.getAllChildAddEvents(listener);
            }
        } else {
            for (int i = 0; i < names.length; ++i) {
                String childname = names[i];
                Node<?> nChild = this.getChildNamed(childname);
                if (nChild == null) continue;
                this.fireChildAddedEvent(nChild, listener);
            }
        }
    }

    public boolean hasChildNamed(String a) {
        Iterator<Node<?>> it = this.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node<?> m = it.next();
            if (!m.getName().toLowerCase().equals(a.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void setPermanent(boolean er) {
        this.isPermanent = er;
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    public Iterator<Node<?>> getAllChildsNamed(String name) {
        ArrayList a = new ArrayList();
        for (Node<?> node : this.children) {
            if (!node.getName().equals(name)) continue;
            a.add(node);
        }
        return a.iterator();
    }

    public boolean isProxyList() {
        return this.isProxyList;
    }

    public void setProxyList(boolean isProxyList) {
        this.isProxyList = isProxyList;
    }

    public boolean contains(Node<?> node) {
        return this.children.contains(node);
    }

    public Iterator<Node<?>> getChilds() {
        return this.children.iterator();
    }

    public List<Node<?>> getChildsAsList() {
        return this.children;
    }

    public Node[] getChildsAsArray() {
        Node[] ns = this.children.toArray(new Node[0]);
        return ns;
    }

    public Iterator<Node<?>> getFailSafeChildIterator() {
        return ((List)((ArrayList)this.children).clone()).iterator();
    }

    public void addNodeListener(NodeListener l) {
        this.listeners.add(l);
    }

    public boolean removeNodeListener(NodeListener l) {
        return this.listeners.remove(l);
    }

    private void removeNodeListenerRecursively(NodeListener l, List<Node<?>> done) {
        if (done.contains(this)) {
            return;
        }
        done.add(this);
        this.removeNodeListener(l);
        for (Node<?> n : this.children) {
            if (n == null) continue;
            super.removeNodeListenerRecursively(l, done);
        }
    }

    public void removeNodeListenerRecursively(NodeListener l) {
        this.removeNodeListenerRecursively(l, new ArrayList());
    }

    public void setValidator(NodeValidator<T> validator) {
        this.validator = validator;
    }

    public boolean setValueSilent(T val, boolean allSilent, long id, NodeListener ... l) {
        boolean isValid = true;
        if (this.validator != null) {
            isValid = this.validator.isValid(val);
        }
        if (isValid) {
            LogicNodeOperation op = LogicNodeOperation.getSetValueOperation(id, this, val, this.data);
            if (NodeToolkit.currentOperation != null) {
                NodeToolkit.currentOperation.addLogicNodeOperation(op);
            }
            this.haveChanges = this.tryToWriteValue(val);
            this.fireDataChangedEvent(allSilent, l);
        }
        return isValid;
    }

    private boolean tryToWriteValue(T newValue) {
        if (newValue == null) {
            boolean wasEmpty = this.data.isEmpty();
            this.data.clear();
            return !wasEmpty;
        }
        if (newValue instanceof ADTO) {
            boolean found = false;
            int index2Override = -1;
            try {
                boolean hasChanges = false;
                for (int i = 0; i < this.data.size(); ++i) {
                    T oldValue = this.data.get(i);
                    if (!newValue.getClass().equals(oldValue.getClass())) continue;
                    found = true;
                    index2Override = i;
                    i = this.data.size();
                    hasChanges = !newValue.equals(oldValue);
                }
                if (!found) {
                    this.data.add(0, newValue);
                } else {
                    this.data.set(index2Override, newValue);
                }
                if (((ADTO)newValue).getId() != null) {
                    Iterator<T> it = this.data.iterator();
                    while (it.hasNext()) {
                        T o = it.next();
                        if (!(o instanceof ADTO) || ((ADTO)o).getId() != null) continue;
                        it.remove();
                    }
                }
                return hasChanges;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (this.data.size() == 0) {
                this.data.add(newValue);
                return false;
            }
            boolean change = true;
            if (this.data.get(0).equals(newValue)) {
                change = false;
            }
            this.data.set(0, newValue);
            return change;
        }
        return false;
    }

    public boolean setValue(T val, long id) {
        boolean isValid = true;
        if (this.validator != null) {
            isValid = this.validator.isValid(val);
        }
        if (isValid) {
            LogicNodeOperation op = LogicNodeOperation.getSetValueOperation(id, this, val, this.data);
            if (NodeToolkit.currentOperation != null) {
                NodeToolkit.currentOperation.addLogicNodeOperation(op);
            }
            this.haveChanges = this.tryToWriteValue(val);
            this.fireDataChangedEvent(false, new NodeListener[0]);
        }
        return isValid;
    }

    public void removeExistingValues() {
        this.data.clear();
    }

    public void removeExitingValueWhenMatchingIsEquals(Class<?> classToDelete) {
        if (classToDelete == null) {
            return;
        }
        Iterator<T> it = this.data.iterator();
        while (it.hasNext()) {
            T n = it.next();
            if (n != null && !classToDelete.equals(n.getClass())) continue;
            it.remove();
        }
    }

    public void removeExistingValues(Class<? extends T> classToDelete) {
        Iterator<T> it = this.data.iterator();
        while (it.hasNext()) {
            T n = it.next();
            if (!classToDelete.isAssignableFrom(n.getClass())) continue;
            it.remove();
        }
    }

    public Node<?> getChildAt(int i) {
        return this.children.get(i);
    }

    public void addChildSorted(List<Node<?>> childs, Comparator<Node<?>> comp) {
        for (Node<?> c : childs) {
            this.addChildSilent(c, null, true, 0L);
        }
        this.sortChilds(comp);
        for (Node<?> c : childs) {
            this.fireChildAddedEvent(c, null);
        }
    }

    public void addChild(Node<?> child, long id) {
        LogicNodeOperation op = LogicNodeOperation.getAddChildOperation(id, child, this, null);
        if (NodeToolkit.currentOperation != null) {
            NodeToolkit.currentOperation.addLogicNodeOperation(op);
        }
        if (!this.allAddedChilds.contains(child)) {
            this.allAddedChilds.add(child);
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
        child.setParent(this);
        this.fireChildAddedEvent(child, null);
    }

    public void removeChild(Node<?> child, long id) {
        if (child == null) {
            System.out.println("Remove a null child is not allowed");
            return;
        }
        LogicNodeOperation op = LogicNodeOperation.getRemoveChildOperation(id, child, this, this);
        if (NodeToolkit.currentOperation != null) {
            NodeToolkit.currentOperation.addLogicNodeOperation(op);
        }
        boolean able2remove = this.children.remove(child);
        Node<?> removeThing = child;
        if (!able2remove) {
            Iterator<Node<?>> it = this.getChilds();
            boolean found = false;
            while (it.hasNext() && !found) {
                Node<?> n = it.next();
                if (!(n instanceof ProxyNode) || ((ProxyNode)n).getRefNode() == null || !((ProxyNode)n).getRefNode().getValue().equals(child.getValue())) continue;
                removeThing = n;
                it.remove();
                found = true;
            }
        }
        this.fireChildRemovedEvent(removeThing);
    }

    protected void fireChildRemovedEvent(Node<?> child) {
        if (NodeToolkit.currentOperation != null || !this.eventsEnabled || disableEvents) {
            return;
        }
        boolean isSwing = SwingUtilities.isEventDispatchThread();
        ArrayList<NodeListener> swingListeners = new ArrayList<NodeListener>();
        try {
            for (NodeListener l : this.listeners) {
                if (!isSwing && l.isSwingOnly()) {
                    swingListeners.add(l);
                    continue;
                }
                l.childRemoved(this, child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (swingListeners.size() > 0) {
            SwingUtilities.invokeLater(() -> {
                for (NodeListener l : swingListeners) {
                    l.childRemoved(this, child);
                }
            });
        }
    }

    protected void fireChildAddedEvent(Node<?> child, NodeListener listener) {
        if (NodeToolkit.currentOperation != null || !this.eventsEnabled || disableEvents) {
            return;
        }
        boolean isSwing = SwingUtilities.isEventDispatchThread();
        ArrayList<NodeListener> swingListeners = new ArrayList<NodeListener>();
        try {
            for (NodeListener l : this.listeners) {
                if (l == listener || l == null) continue;
                if (!isSwing && l.isSwingOnly()) {
                    swingListeners.add(l);
                    continue;
                }
                l.childAdded(this, child);
            }
            if (!swingListeners.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    for (NodeListener l : swingListeners) {
                        l.childAdded(this, child);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void fireDataChangedEvent(boolean allSilent, NodeListener ... le) {
        if (!this.eventsEnabled || disableEvents) {
            return;
        }
        HashSet<NodeListener> allToIngore = new HashSet<NodeListener>();
        if (le != null) {
            for (NodeListener nodeListener : le) {
                if (nodeListener == null) continue;
                allToIngore.add(nodeListener);
            }
        }
        if (!allSilent && NodeToolkit.currentOperation == null) {
            boolean isSwing = SwingUtilities.isEventDispatchThread();
            ArrayList<NodeListener> swingListeners = new ArrayList<NodeListener>();
            List cList = (List)((ArrayList)this.listeners).clone();
            for (NodeListener l : cList) {
                if (l == null || allToIngore.contains(l)) continue;
                if (!isSwing && l.isSwingOnly()) {
                    swingListeners.add(l);
                    continue;
                }
                l.valueChanged(this);
            }
            if (!swingListeners.isEmpty()) {
                SwingUtilities.invokeLater(() -> {
                    for (NodeListener l : swingListeners) {
                        l.valueChanged(this);
                    }
                });
            }
        }
    }

    public void getAllChildAddEvents(NodeListener listener) {
        Iterator<Node<?>> it = this.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node<?> child = it.next();
            listener.childAdded(this, child);
        }
        if (listener != null) {
            listener.valueChanged(this);
        }
    }

    public void commitThis(Class<?> clazz) {
        ArrayList list = new ArrayList();
        this.propagateCommit(this.getValue(clazz), list, true);
    }

    public void propagateCommit(Object value, List<Node<?>> list, boolean b) {
    }

    public void commitThis(Class<?> clazz, Map<Class<?>, Class<?>> classMapping) {
        ArrayList list = new ArrayList();
        this.propagateCommit(this.getValue(clazz), list, true, classMapping);
    }

    public void propagateCommit(Object value, List<Node<?>> list, boolean b, Map<Class<?>, Class<?>> classMapping) {
    }

    public void commitThis() {
        ArrayList list = new ArrayList();
        this.propagateCommit(this.getValue(), list);
    }

    public void commit() {
        Node<?> p = this;
        while (p.getParent() != null && !(p instanceof PegasusNode)) {
            p = p.getParent();
        }
        if (p instanceof Node) {
            ArrayList list = new ArrayList();
            p.propagateCommit(p.getValue(), list);
        }
    }

    public void propagateCommit(Object value, List<Node<?>> list) {
    }

    public void commit(Class<?> clazz) {
        this.commit(clazz, new HashMap());
    }

    public void commit(Class<?> clazz, Map<Class<?>, Class<?>> mapping) {
        this.commit(clazz, false, mapping);
    }

    public void commit(Class<?> clazz, boolean useProxy) {
        this.commit(clazz, useProxy, new HashMap());
    }

    public void commit(Class<?> clazz, boolean useProxy, Map<Class<?>, Class<?>> mapping) {
        if (clazz == null) {
            this.commit();
        } else {
            Node<?> p = this;
            while (p.getParent() != null && !(p instanceof PegasusNode)) {
                p = p.getParent();
            }
            ArrayList list = new ArrayList();
            p.propagateCommit(p.getValue(clazz), list, useProxy, mapping);
        }
    }

    public void removeDataIfPossilbe(Class<? extends T> clazz) {
        T o = this.getValue(clazz);
        while (o != null) {
            this.data.remove(o);
            o = this.getValue(clazz);
        }
    }

    public void updateNode() {
        this.updateNode(new ArrayList());
    }

    protected void updateNode(List<Node<?>> registry) {
        if (registry == null) {
            registry = new ArrayList();
        }
        if (!registry.contains(this)) {
            registry.add(this);
            Iterator<Node<?>> it = this.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node<?> n = it.next();
                if (n == null) continue;
                String cName = n.getName();
                boolean updateMe = false;
                Object o = this.getValueForNamed(cName);
                updateMe = o == null ? this.isChildManaged(n) : true;
                if (updateMe) {
                    n.removeExistingValues();
                    n.setValue(o, 0L);
                    n.updateNode(registry);
                    continue;
                }
                if (n.isPermanent()) continue;
                this.removeChild(n, 0L);
            }
        }
    }

    boolean isChildManaged(Node<?> child) {
        boolean isManaged = false;
        for (T o : this.data) {
            String childName;
            if (o == null || (childName = child.getName()) == null) continue;
            try {
                isManaged = Invoker.fieldExists(o.getClass(), (String)childName);
            }
            catch (InvokerException e) {
                isManaged = Invoker.getterExists(o.getClass(), (String)childName);
            }
            if (!isManaged) continue;
            return true;
        }
        return false;
    }

    public boolean hasChild4Value(Object o) {
        Iterator<Node<?>> it = this.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node<?> n = it.next();
            if (o == null || !o.equals(n.getValue())) continue;
            return true;
        }
        return false;
    }

    public int getChildIndex(Node<?> child) {
        return this.children.indexOf(child);
    }

    public void addChildSilent(Node<?> child, NodeListener l, boolean all, long id) {
        LogicNodeOperation op = LogicNodeOperation.getAddChildOperation(id, child, this, null);
        if (NodeToolkit.currentOperation != null) {
            NodeToolkit.currentOperation.addLogicNodeOperation(op);
        }
        if (!this.allAddedChilds.contains(child)) {
            this.allAddedChilds.add(child);
        }
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
        child.setParent(this);
        if (!all) {
            this.fireChildAddedEvent(child, l);
        }
    }

    public int getListenerCount() {
        return this.listeners.size();
    }

    public void removeAllListenersRecursivley() {
        ArrayList arr = new ArrayList();
        this.doRecursivlyRemoveallListeners(arr);
    }

    private void doRecursivlyRemoveallListeners(List<Node<?>> list) {
        if (!list.contains(this)) {
            this.listeners.clear();
            list.add(this);
            for (Node<?> n : this.allAddedChilds) {
                if (n == null) continue;
                super.doRecursivlyRemoveallListeners(list);
            }
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean hasDataChanged(Set<Node<?>> registry) {
        if (registry == null) {
            registry = new HashSet();
        }
        if (registry.contains(this)) {
            return false;
        }
        registry.add(this);
        if (this.haveChanges) {
            return true;
        }
        Iterator<Node<?>> it = this.getFailSafeChildIterator();
        if (it != null) {
            while (it.hasNext()) {
                Node<?> next = it.next();
                if (next == null || !next.hasDataChanged(registry)) continue;
                return true;
            }
        }
        return this.haveChanges;
    }

    public void sortChilds(Comparator<Node<?>> comp) {
        Collections.sort(this.children, comp);
    }

    public void disableEventsGlobally() {
        disableEvents = true;
    }

    public void enableEventsGlobally() {
        disableEvents = false;
    }

    public void disableEvents() {
        this.eventsEnabled = false;
    }

    public void enableEvents() {
        this.eventsEnabled = true;
    }

    public void removeAllChilds() {
        Iterator<Node<?>> it = this.getFailSafeChildIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Node<?> n = it.next();
            if (n.isPermanent()) continue;
            this.removeChild(n, 0L);
            if (!n.isPermanent()) {
                INodeCreator.getDefaultImpl().removeFromAllNodes(n);
            }
            if (n instanceof ProxyNode) continue;
            n.removeAllChilds();
        }
    }

    public void removeChildsPermanent() {
        Iterator<Node<?>> it = this.getFailSafeChildIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Node<?> n = it.next();
            if (n.isPermanent()) continue;
            this.removeChild(n, 0L);
            INodeCreator.getDefaultImpl().removeFromAllNodes(n);
            if (n instanceof ProxyNode) continue;
            n.removeAllChilds();
        }
    }
}

