/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.tracking;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.TruckServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.tracking.TruckComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.tracking.TruckService;

public class TruckServiceManagerImpl
implements TruckServiceManager {
    @Override
    public OptionalWrapper<TruckComplete> create(TruckComplete truck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(TruckService.class).create(truck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<TruckComplete> update(TruckComplete truck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(TruckService.class).update(truck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<TruckComplete> getTruck(TruckComplete truck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(TruckService.class).getTruck(truck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

