/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.actions.impl;

import ch.icit.pegasus.client.actions.impl.ActionWithStyleSheet;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.print.PrinterLocalToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderOutputTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderSendHistoryComplete;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.util.PrinterToolkit;
import java.awt.Component;
import java.io.File;
import java.sql.Timestamp;
import java.util.List;
import javax.print.PrintService;

public class PrintPurchaseOrderSheet
extends ActionWithStyleSheet {
    @Override
    public void performAction(final Component source, ProgressListener l, Object ... objects) throws Exception {
        if (l != null) {
            l.stateChanged(Words.PRINT_PURCHASE_ORDER_SHEET);
        }
        PurchaseOrderComplete order = (PurchaseOrderComplete)objects[0];
        PrintService service = PrinterLocalToolkit.getStandardPrinter(null);
        PurchaseOrderReportConfiguration config = new PurchaseOrderReportConfiguration();
        config.setDto((IDTO)new PurchaseOrderReference(order.getId()));
        config.setFormat(ReportingOutputFormatE.PDF);
        config.setTitle("Purchase Order");
        SearchResult res = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(ReportTypeE.PURCHASE_ORDER);
        List<ReportFileComplete> styleSheets = this.filterStyleSheetWithReportConfiguration((SearchResult<ReportFileComplete>)res, ReportTypeE.PURCHASE_ORDER);
        if (styleSheets.isEmpty()) {
            throw new Exception("No Style Sheet for Purchase Order Sheet found");
        }
        config.setStylesheet(styleSheets.get(0));
        PegasusFileComplete r = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderSheet(config).getValue();
        if (r == null) {
            InnerPopupFactory.showErrorDialog("Error while create Order Sheet", "Unable to print", null, source);
            return;
        }
        try {
            PurchaseOrderSendHistoryComplete h = new PurchaseOrderSendHistoryComplete();
            h.setPrint(Boolean.valueOf(true));
            h.setSendDate(new Timestamp(System.currentTimeMillis()));
            h.setSentUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
            h.setTarget("Printer");
            h.setPurchaseOrderOutputType(PurchaseOrderOutputTypeE.PRINTER);
            order.getSendHistory().add(h);
            File file = FileTransferUtil.download((PegasusFileComplete)r, (FileTransferListener[])new FileTransferListener[]{new FileTransferListener(){

                public void statusChanged(File file, FileTransferState state) {
                }

                public void exceptionOccurred(Exception exception) {
                    InnerPopupFactory.showErrorDialog(exception, source);
                }
            }});
            ((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).updatePurchaseOrder(order);
            PrinterToolkit.printPDF((File)file, (PrintService)service, (int)1);
        }
        catch (Exception e) {
            InnerPopupFactory.showErrorDialog(e, source);
        }
    }
}

