/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.breadcrumb;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;

public abstract class BreadCrumbTable
extends JPanelKillable
implements Movable,
Focusable,
MutableFocusContainer,
MutableFocusContainerListener,
RemoteLoader {
    private static final long serialVersionUID = 1L;
    protected Mover<BreadCrumbTable> mover = new Mover<BreadCrumbTable>(this);
    protected Table2 table;
    protected TextLabel title;
    protected TextButton addButton;
    private VerticalSeparator verticalSep;
    private HorizontalSeparator horizontalSep;
    protected ReloadablePriceView totalCompPrice;
    private Color titleColor;
    private boolean isAdded = false;
    protected IDataHandler dataHandler;
    protected BreadCrumbPanel master;
    protected int titleHeight = 35;
    protected RDProvider provider;
    protected Table2RowPanel parentTableRow;
    protected boolean nodeIsSetted;
    private boolean useWriteAccessRight;

    public BreadCrumbTable(IDataHandler dataHandler, BreadCrumbPanel master, String buttonText, RDProvider provider, Node node) {
        this.master = master;
        this.provider = provider;
        this.dataHandler = dataHandler;
        this.setOpaque(false);
        this.titleColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("product_componentview_title_background"));
        this.install(node);
        if (this.hasTitle()) {
            this.title = new TextLabel("");
            this.title.setViewConverter(this.getTitleConverter());
        }
        this.ensureAddButton(buttonText);
        this.verticalSep = new VerticalSeparator();
        this.verticalSep.setSeparatorColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("leg_table_line_color")));
        this.horizontalSep = new HorizontalSeparator();
        this.horizontalSep.setSeparatorColor(this.verticalSep.getSeparatorColor());
        this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
        this.setLayout(new Layout());
        if (this.title != null) {
            this.add(this.title);
        }
        this.setFocusCycleRoot(true);
        this.add(this.table);
        if (this.hasAddButton()) {
            this.add(this.addButton);
            this.table.setScrollDownOnAdd(true);
        } else {
            this.table.setScrollDownOnAdd(false);
        }
        this.add(this.horizontalSep);
    }

    protected void setUseWriteAcessRight(boolean useWriteAccessRight) {
        this.useWriteAccessRight = useWriteAccessRight;
    }

    @Override
    public void focusCycleChanged(MutableFocusContainer container) {
        this.createFocusCycle();
    }

    public void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (Table2RowPanel c : this.table.getRows()) {
            List<Component> ar = c.getFocusComponents();
            if (ar == null) continue;
            a.addAll(ar);
        }
        if (this.addButton != null && this.addButton.isEnabled()) {
            a.add(this.addButton);
        }
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    private void ensureAddButton(String buttonText) {
        boolean addable = true;
        if (this.provider != null && this.table.getModel().getNode() != null) {
            addable = this.getUseWriteAccessRight() ? this.provider.isWritable(this.table.getModel().getNode().getName()) : this.provider.isAddable(this.table.getModel().getNode().getName());
        }
        if (this.hasAddButton() && addable && this.addButton == null) {
            this.addButton = new TextButton(buttonText);
            this.addButton.addButtonListener(this.master);
        } else if (!this.hasAddButton() && !addable && this.addButton != null) {
            this.addButton.kill();
            this.addButton = null;
        } else if (this.hasAddButton() && !addable && this.addButton != null) {
            this.addButton.kill();
            this.addButton = null;
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.table.setEnabled(true);
        this.table.setEditable(isEnabled);
        this.table.enableAddButton(isEnabled);
        if (this.title != null) {
            this.title.setEnabled(isEnabled);
        }
        if (this.addButton != null) {
            this.addButton.setEnabled(isEnabled);
        }
        if (this.verticalSep != null) {
            this.verticalSep.setEnabled(isEnabled);
        }
        if (this.horizontalSep != null) {
            this.horizontalSep.setEnabled(isEnabled);
        }
        if (this.totalCompPrice != null) {
            this.totalCompPrice.setEnabled(isEnabled);
        }
    }

    public boolean hasAddButton() {
        return true;
    }

    public void disableTitle() {
        if (this.title != null) {
            this.title.kill();
            this.title = null;
            this.titleHeight = 0;
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    public abstract Converter<?, ?> getTitleConverter();

    public abstract int getSortingIndex();

    public boolean hasTitle() {
        return true;
    }

    public boolean isButtonOwner(Button pressedButton) {
        return this.addButton == pressedButton;
    }

    public void enableAddButton(boolean isEnabled) {
        this.addButton.setEnabled(isEnabled);
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public boolean isAdded() {
        return this.isAdded;
    }

    public void setAdded(boolean isAdded) {
        this.isAdded = isAdded;
    }

    public Table2 getTable() {
        return this.table;
    }

    protected abstract void install(Node var1);

    public abstract Node getTableNode();

    public void setNode(Node node) {
        this.nodeIsSetted = true;
        this.table.getModel().removeFocusCycleChangeListener(this);
        this.table.getModel().setNode(node);
        this.ensureAddButton(this.addButton != null ? this.addButton.getText() : "");
        if (this.title != null) {
            this.title.setNode(this.getTableNode());
        }
        this.table.updateOrder();
        this.table.setEnabled(this.isEnabled());
        this.createFocusCycle();
        this.nodeIsSetted = true;
        this.table.getModel().addFocusCycleChangeListener(this);
        this.validate();
    }

    public Mover<BreadCrumbTable> getMover() {
        return this.mover;
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.mover.setLocationSmooth(endX, endY);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        if (this.title != null) {
            this.title.kill();
        }
        if (this.hasAddButton() && this.addButton != null) {
            this.addButton.kill();
        }
        this.table = null;
        this.title = null;
        this.addButton = null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.title != null) {
            g2.setColor(this.titleColor);
            g2.fillRect(0, 0, this.getWidth(), this.titleHeight);
        }
        this.paintChildren(g2);
    }

    public void writeNumbers() {
        long id = System.currentTimeMillis();
        int count = 1;
        for (Table2RowPanel p : this.table.getRows()) {
            Node numberNode = p.getModel().getNode().getChildNamed(new String[]{"number"});
            if (numberNode != null) {
                numberNode.setValue((Object)count, id);
            }
            ++count;
        }
        this.table.updateOrder();
        this.table.relayoutRequested();
    }

    public boolean isContainingRow(Table2RowPanel p) {
        for (Table2RowPanel panel : this.table.getRows()) {
            if (panel != p) continue;
            return true;
        }
        return false;
    }

    public void selectFirstEntry() {
        if (this.table.getRowCount() > 0) {
            this.table.getRowAt(0).requestFocusInWindowNow();
        }
    }

    public void selectFirstEntryForReal() {
        if (this.table.getRowCount() > 0) {
            this.table.getRowAt(0).requestFocusInWindowNow();
            this.table.getModel().selectRow(this.table.getRowAt(0), false, true, 3);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        if (this.hasAddButton() && this.addButton != null && this.addButton.isEnabled()) {
            CheckedListAdder.addToList(a, this.addButton);
        }
        return a;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.table.setVisibleContainer(pane);
        if (this.hasAddButton()) {
            this.addButton.setVisibleContainer(pane);
        }
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.table.getModel().removeFocusCycleChangeListener(listener);
    }

    public void setParentBreadCrumb(Table2RowPanel panel) {
        this.parentTableRow = panel;
    }

    public void setAddButtonEnabled(boolean isEnabled) {
        if (this.addButton != null) {
            this.addButton.setEnabled(isEnabled);
        }
        if (this.table != null) {
            this.table.setEnabled(isEnabled);
        }
    }

    public void showAddButton(boolean show) {
        if (!show && this.addButton != null) {
            this.addButton.kill();
            this.addButton = null;
        }
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
    }

    public boolean getUseWriteAccessRight() {
        return this.useWriteAccessRight;
    }

    public void setUseWriteAccessRight(boolean useWriteAccessRight) {
        this.useWriteAccessRight = useWriteAccessRight;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int ah = 0;
            if (BreadCrumbTable.this.title != null) {
                ah = BreadCrumbTable.this.titleHeight;
                BreadCrumbTable.this.title.setLocation(10, (int)(((double)BreadCrumbTable.this.titleHeight - BreadCrumbTable.this.title.getPreferredSize().getHeight()) / 2.0));
                BreadCrumbTable.this.title.setSize(parent.getWidth() - 2 * BreadCrumbTable.this.title.getX(), (int)BreadCrumbTable.this.title.getPreferredSize().getHeight());
            }
            int currentY = 0;
            int currentX = 0;
            if (BreadCrumbTable.this.hasAddButton() && BreadCrumbTable.this.addButton != null) {
                BreadCrumbTable.this.addButton.setLocation(10, (int)((double)parent.getHeight() - (10.0 + BreadCrumbTable.this.addButton.getPreferredSize().getHeight())));
                BreadCrumbTable.this.addButton.setSize(BreadCrumbTable.this.addButton.getPreferredSize());
                currentY = BreadCrumbTable.this.addButton.getY();
                currentX = BreadCrumbTable.this.addButton.getX() + BreadCrumbTable.this.addButton.getWidth();
            } else {
                currentY = parent.getHeight() - 35;
            }
            if (BreadCrumbTable.this.totalCompPrice != null) {
                BreadCrumbTable.this.totalCompPrice.setLocation(currentX + 20, currentY);
                BreadCrumbTable.this.totalCompPrice.setSize(parent.getWidth() - (BreadCrumbTable.this.totalCompPrice.getX() + 10), (int)BreadCrumbTable.this.totalCompPrice.getPreferredSize().getHeight());
            }
            BreadCrumbTable.this.horizontalSep.setLocation(0, currentY - 5);
            BreadCrumbTable.this.horizontalSep.setSize(parent.getWidth(), 1);
            BreadCrumbTable.this.verticalSep.setLocation(BreadCrumbTable.this.getWidth() - 1, 0);
            BreadCrumbTable.this.verticalSep.setSize(1, parent.getHeight());
            int ah2 = parent.getHeight() - (BreadCrumbTable.this.horizontalSep.getY() - 5);
            BreadCrumbTable.this.table.setLocation(0, ah);
            BreadCrumbTable.this.table.setSize(parent.getWidth() - 1, parent.getHeight() - (BreadCrumbTable.this.table.getY() + ah2));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }
}

