/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.debug;

import ch.icit.pegasus.client.gui.debug.DebugCheckBoxPanel;
import ch.icit.pegasus.client.services.ProxyInvocationHandler;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.GenericServiceManager;
import ch.icit.pegasus.client.services.interfaces.file.FileServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.AircraftServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.SalesOnBoardServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.importer.DataImportServiceManager;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.InvoiceReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.LabelReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.RecipeReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.ReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.SkypexReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.TrackingReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.DispositionServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.PurchaseOrderGeneratorServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ThreeWayMatchServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.AdministrationServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.HostServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.LoggingServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SessionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.ScanningServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.TruckServiceManager;
import ch.icit.pegasus.client.services.interfaces.tradegoods.TradeGoodsServiceManager;
import ch.icit.pegasus.client.util.DebugTextListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultCaret;

public class DebugWindow
implements ListSelectionListener,
DebugTextListener {
    private JPanel content;
    private final List<Class<?>> classes = new ArrayList();
    private JList list;
    private JTextArea textArea;
    JFrame frame;
    List<String> unimportant = new ArrayList<String>();

    public DebugWindow() {
        this.frame = new JFrame("Debug Window");
        this.frame.setDefaultCloseOperation(3);
        this.initClasses();
        JScrollPane content = this.createContentArea();
        JScrollPane list = this.createListArea();
        JScrollPane console = this.createConsole();
        JSplitPane innerSplitPane = new JSplitPane(1, list, content);
        innerSplitPane.setPreferredSize(new Dimension(1200, 800));
        JSplitPane outerSplitPane = new JSplitPane(0, innerSplitPane, console);
        outerSplitPane.setDividerLocation(800);
        this.frame.add((Component)outerSplitPane, "Center");
        this.frame.setSize(1200, 1000);
        this.frame.setVisible(true);
        ProxyInvocationHandler.registerDebugListener((DebugTextListener)this);
    }

    private JScrollPane createContentArea() {
        this.content = new JPanel();
        this.content.setBackground(Color.black);
        this.content.setLayout(new BoxLayout(this.content, 3));
        this.content.setSize(500, 500);
        JScrollPane jScrollPane = new JScrollPane(this.content);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setOpaque(false);
        return jScrollPane;
    }

    private JScrollPane createListArea() {
        Collections.sort(this.classes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        });
        this.list = new JList<Object>(this.classes.toArray());
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(0);
        this.list.setVisibleRowCount(-1);
        this.list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = new JLabel(((Class)value).getSimpleName());
                label.setBorder(new EmptyBorder(2, 2, 2, 2));
                if (isSelected) {
                    label.setBackground(Color.LIGHT_GRAY);
                    label.setOpaque(true);
                } else {
                    label.setBackground(Color.WHITE);
                    label.setOpaque(true);
                }
                return label;
            }
        });
        JScrollPane listScroller = new JScrollPane(this.list);
        listScroller.setPreferredSize(new Dimension(340, 750));
        this.list.addListSelectionListener(this);
        this.list.setSelectedIndex(0);
        return listScroller;
    }

    private JScrollPane createConsole() {
        this.textArea = new JTextArea(30, 90);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("SansSerif", 1, 14));
        JScrollPane textPane = new JScrollPane(this.textArea);
        return textPane;
    }

    public void loadContent(Class<?> clazz) {
        List<Method> methods = Arrays.asList(clazz.getDeclaredMethods());
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        DebugCheckBoxPanel dcp = new DebugCheckBoxPanel(clazz, methods);
        this.content.removeAll();
        this.content.repaint();
        this.content.add(dcp);
        dcp.setVisible(true);
        this.content.revalidate();
        this.content.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getFirstIndex() != -1 && !e.getValueIsAdjusting()) {
            this.loadContent((Class)this.list.getSelectedValue());
        }
    }

    private void initClasses() {
        this.classes.add(AircraftServiceManager.class);
        this.classes.add(FlightServiceManager.class);
        this.classes.add(SalesOnBoardServiceManager.class);
        this.classes.add(StowingListServiceManager.class);
        this.classes.add(ThreeWayMatchServiceManager.class);
        this.classes.add(DataImportServiceManager.class);
        this.classes.add(InvoiceServiceManager.class);
        this.classes.add(MasterDataServiceManager.class);
        this.classes.add(MealPlanServiceManager.class);
        this.classes.add(RecipeServiceManager.class);
        this.classes.add(FlightReportServiceManager.class);
        this.classes.add(InventoryReportServiceManager.class);
        this.classes.add(InvoiceReportServiceManager.class);
        this.classes.add(OrderReportServiceManager.class);
        this.classes.add(ProductReportServiceManager.class);
        this.classes.add(RecipeReportServiceManager.class);
        this.classes.add(ReportServiceManager.class);
        this.classes.add(SkypexReportServiceManager.class);
        this.classes.add(StoreReportServiceManager.class);
        this.classes.add(TrackingReportServiceManager.class);
        this.classes.add(SearchServiceManager.class);
        this.classes.add(DispositionServiceManager.class);
        this.classes.add(InventoryServiceManager.class);
        this.classes.add(OrderServiceManager.class);
        this.classes.add(PurchaseOrderGeneratorServiceManager.class);
        this.classes.add(StoreServiceManager.class);
        this.classes.add(SupplyServiceManager.class);
        this.classes.add(AdministrationServiceManager.class);
        this.classes.add(HostServiceManager.class);
        this.classes.add(LoggingServiceManager.class);
        this.classes.add(SessionServiceManager.class);
        this.classes.add(SystemSettingsServiceManager.class);
        this.classes.add(UserServiceManager.class);
        this.classes.add(FileServiceManager.class);
        this.classes.add(LabelReportServiceManager.class);
        this.classes.add(ScanningServiceManager.class);
        this.classes.add(TruckServiceManager.class);
        this.classes.add(TradeGoodsServiceManager.class);
        this.classes.add(DefaultServiceManager.class);
        this.classes.add(GenericServiceManager.class);
        this.unimportant.add("getCurrentUser");
        this.unimportant.add("getAffixNameForClass");
        this.unimportant.add("getAllLocationsCached");
        this.unimportant.add("getAllCached");
        this.unimportant.add("getCurrentLocation");
        this.unimportant.add("getSettingsCached");
    }

    public void debugText(String text, Method method, Class<?> class1) {
        if (!this.unimportant.contains(method.getName())) {
            this.textArea.append(text + "\n");
        }
    }
}

