/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.AdministrationServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AdminConfig
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private List<TitledItem<TextButton>> buttons;
    private TitledItem<TextButton> adminScript1;
    private TitledItem<TextButton> adminScript2;
    private TitledItem<TextButton> adminScript3;
    private TitledItem<TextButton> adminScript4;
    private TitledItem<TextButton> adminScript5;
    private TitledItem<TextButton> adminScript6;
    private TitledItem<TextButton> adminScript7;
    private TitledItem<TextButton> adminScript8;
    private TitledItem<TextButton> adminScript9;
    private TitledItem<TextButton> adminScript10;
    private TitledItem<TextButton> adminScript11;
    private TitledItem<TextButton> adminScript12;
    private TitledItem<TextButton> grantAllRightsToAdmin;
    private TitledItem<TextButton> stopAllTimerServices;
    private TitledItem<TextButton> startAllTimerServices;
    private TitledItem<TextButton> adminScript16;
    private TitledItem<TextButton> adminScript17;
    private TitledItem<TextButton> adminScript18;
    private TitledItem<TextButton> adminScript19;
    private TitledItem<TextButton> adminScript20;
    private TitledItem<TextButton> adminScript21;
    private TitledItem<TextButton> adminScript22;
    private TitledItem<TextButton> adminScript23;
    private TitledItem<TextButton> adminScript24;
    private TitledItem<TextButton> adminScript25;
    private TitledItem<TextButton> adminScript26;

    public AdminConfig(AbstractDataInsertModule parent) {
        super(parent);
    }

    @Override
    public void insertElements() {
        this.buttons = new ArrayList<TitledItem<TextButton>>();
        this.adminScript1 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "1 - empty", TitledItem.TitledItemOrientation.EAST);
        this.adminScript2 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "2 - Close existing redirect orders, 20.10, stal FPB", TitledItem.TitledItemOrientation.EAST);
        this.adminScript3 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "3 - Init old closed Purchase Orders", TitledItem.TitledItemOrientation.EAST);
        this.adminScript4 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "4 - empty", TitledItem.TitledItemOrientation.EAST);
        this.adminScript5 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "5 - empty", TitledItem.TitledItemOrientation.EAST);
        this.adminScript6 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "6 - empty", TitledItem.TitledItemOrientation.EAST);
        this.adminScript7 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "7 - Archive DataImports, stal, 05.06.2025", TitledItem.TitledItemOrientation.EAST);
        this.adminScript8 = new TitledItem<TextButton>(new TextButton("Invoice Status Flag"), "8 - Invoice Status Flag for each Flight is recalculated, (Input: txt-File- first line: minus actual days; second line: plus actual days) 09.08.2016", TitledItem.TitledItemOrientation.EAST);
        this.adminScript9 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "Archive Mat Dispo Reports, stal, 05.06.2025", TitledItem.TitledItemOrientation.EAST);
        this.adminScript10 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "10 - Archive Flight Sheets, stal, 05.06.2025", TitledItem.TitledItemOrientation.EAST);
        this.adminScript11 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "11 - empty", TitledItem.TitledItemOrientation.EAST);
        this.adminScript12 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "12 - Find Product & Recipe Variant Images to archive, stal, 03.06.2025", TitledItem.TitledItemOrientation.EAST);
        this.grantAllRightsToAdmin = new TitledItem<TextButton>(new TextButton("Grant Admin Rights"), "Ensures Admin Account has all access rights (20.09.2016)", TitledItem.TitledItemOrientation.EAST);
        this.stopAllTimerServices = new TitledItem<TextButton>(new TextButton("Stop all Timer Service"), "Stops all active Timer Services (01.10.2015)", TitledItem.TitledItemOrientation.EAST);
        this.startAllTimerServices = new TitledItem<TextButton>(new TextButton("Show all Timer Service"), "Shows all active Timer Services (03.12.2015)", TitledItem.TitledItemOrientation.EAST);
        this.adminScript16 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "16 - empty", TitledItem.TitledItemOrientation.EAST);
        this.adminScript17 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "17 - Ensure all Submodules are added to Modules, general function", TitledItem.TitledItemOrientation.EAST);
        this.adminScript18 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "18 - Search Inventory Transactions without real date and fix it (to date)", TitledItem.TitledItemOrientation.EAST);
        this.adminScript19 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "19 - Search Charges without Batches and fix it (to last transaction)", TitledItem.TitledItemOrientation.EAST);
        this.adminScript20 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "20 - Fix Batches with only IR, stal, fcp, 02.10.2023", TitledItem.TitledItemOrientation.EAST);
        this.adminScript21 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "21 - empty", TitledItem.TitledItemOrientation.EAST);
        this.adminScript22 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "22 - PegasusFile: without filename, lk, 10.08.18 ", TitledItem.TitledItemOrientation.EAST);
        this.adminScript23 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "23 - Encrypt Password, lk, 12.08.18 ", TitledItem.TitledItemOrientation.EAST);
        this.adminScript24 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "24 - Switch Encryption, lk, 08.10.18 ", TitledItem.TitledItemOrientation.EAST);
        this.adminScript25 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "25 - Cipher-Key Generator, lk, 12.08.18 ", TitledItem.TitledItemOrientation.EAST);
        this.adminScript26 = new TitledItem<TextButton>(new TextButton(Words.SELECT), "26 - empty", TitledItem.TitledItemOrientation.EAST);
        this.buttons.add(this.adminScript1);
        this.buttons.add(this.adminScript2);
        this.buttons.add(this.adminScript3);
        this.buttons.add(this.adminScript4);
        this.buttons.add(this.adminScript5);
        this.buttons.add(this.adminScript6);
        this.buttons.add(this.adminScript7);
        this.buttons.add(this.adminScript8);
        this.buttons.add(this.adminScript9);
        this.buttons.add(this.adminScript10);
        this.buttons.add(this.adminScript11);
        this.buttons.add(this.adminScript12);
        this.buttons.add(this.grantAllRightsToAdmin);
        this.buttons.add(this.stopAllTimerServices);
        this.buttons.add(this.startAllTimerServices);
        this.buttons.add(this.adminScript16);
        this.buttons.add(this.adminScript17);
        this.buttons.add(this.adminScript18);
        this.buttons.add(this.adminScript19);
        this.buttons.add(this.adminScript20);
        this.buttons.add(this.adminScript21);
        this.buttons.add(this.adminScript22);
        this.buttons.add(this.adminScript23);
        this.buttons.add(this.adminScript24);
        this.buttons.add(this.adminScript25);
        this.buttons.add(this.adminScript26);
        for (TitledItem<TextButton> titledItem : this.buttons) {
            this.add(titledItem);
        }
        this.setLayout(new Layout());
        for (TitledItem<TextButton> titledItem : this.buttons) {
            titledItem.getElement().addButtonListener(this);
        }
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Admin Scripts";
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            for (TitledItem<TextButton> titledItem : this.buttons) {
                titledItem.kill();
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            for (TitledItem<TextButton> titledItem : this.buttons) {
                titledItem.setEnabled(isEnabled);
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> a = new ArrayList<Component>();
            for (TitledItem<TextButton> titledItem : this.buttons) {
                CheckedListAdder.addToList(a, titledItem);
            }
            return a;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.adminScript1.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AdminConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return AdminConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<?> node) {
        if (!this.isInserted) {
            return;
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return new ArrayList<ScreenValidationObject>();
    }

    @Override
    public void buttonPressed(final Button source, int x, int y) {
        this.startAnimation("Admin Script running");
        this.setEnabled(false);
        if (source == this.grantAllRightsToAdmin.getElement() || source == this.stopAllTimerServices.getElement() || source == this.startAllTimerServices.getElement()) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    String ret = null;
                    if (source == AdminConfig.this.grantAllRightsToAdmin.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript13();
                    }
                    if (source == AdminConfig.this.stopAllTimerServices.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript14();
                    }
                    if (source == AdminConfig.this.startAllTimerServices.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript15();
                    }
                    ViewNode r = new ViewNode("");
                    r.setValue((Object)ret, 0L);
                    return r;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new ButtonRemoteLoader();
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            final File fileName = FileChooserUtil.loadFile();
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    String ret = null;
                    FileCommitter c = new FileCommitter(fileName, FileCategoryE.TEMP);
                    c.commit(null);
                    PegasusFileComplete f = c.getRemoteRef();
                    if (source == AdminConfig.this.adminScript1.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript1(f);
                    } else if (source == AdminConfig.this.adminScript2.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript2(f);
                    } else if (source == AdminConfig.this.adminScript3.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript3(f);
                    } else if (source == AdminConfig.this.adminScript4.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript4(f);
                    } else if (source == AdminConfig.this.adminScript5.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript5(f);
                    } else if (source == AdminConfig.this.adminScript6.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript6(f);
                    } else if (source == AdminConfig.this.adminScript7.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript7(f);
                    } else if (source == AdminConfig.this.adminScript8.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript8(f);
                    } else if (source == AdminConfig.this.adminScript9.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript9(f);
                    } else if (source == AdminConfig.this.adminScript10.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript10(f);
                    } else if (source == AdminConfig.this.adminScript11.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript11(f);
                    } else if (source == AdminConfig.this.adminScript12.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript12(f);
                    } else if (source == AdminConfig.this.adminScript16.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript16(f);
                    } else if (source == AdminConfig.this.adminScript17.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript17(f);
                    } else if (source == AdminConfig.this.adminScript18.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript18();
                    } else if (source == AdminConfig.this.adminScript19.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript19();
                    } else if (source == AdminConfig.this.adminScript20.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript20();
                    } else if (source == AdminConfig.this.adminScript21.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript21();
                    } else if (source == AdminConfig.this.adminScript22.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript22();
                    } else if (source == AdminConfig.this.adminScript23.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript23();
                    } else if (source == AdminConfig.this.adminScript24.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript24();
                    } else if (source == AdminConfig.this.adminScript25.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript25();
                    } else if (source == AdminConfig.this.adminScript26.getElement()) {
                        ret = ((AdministrationServiceManager)ServiceManagerRegistry.getService(AdministrationServiceManager.class)).adminScript26(f);
                    }
                    ViewNode r = new ViewNode("");
                    r.setValue((Object)ret, 0L);
                    return r;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new ButtonRemoteLoader();
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    private List<String> resolveSapNo(Map<String, List<String>> sapIndex, String flightStd, String sapNo) {
        List<String> possibleSapNos = sapIndex.get(sapNo);
        if (possibleSapNos == null) {
            return Collections.singletonList(sapNo);
        }
        return possibleSapNos;
    }

    private final class ButtonRemoteLoader
    implements RemoteLoader {
        private ButtonRemoteLoader() {
        }

        public void remoteObjectLoaded(Node<?> node) {
            String t = "Admin Script loaded: ";
            if (node.getValue() != null && !(t = t + (String)node.getValue()).isEmpty()) {
                InnerPopupFactory.showMessageDialog(t, AdminConfig.this);
            }
            AdminConfig.this.stopAnimation();
            AdminConfig.this.setEnabled(true);
        }

        public void errorOccurred(ClientException exception) {
            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)AdminConfig.this);
            AdminConfig.this.stopAnimation();
            AdminConfig.this.setEnabled(true);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (AdminConfig.this.isInserted) {
                for (TitledItem titledItem : AdminConfig.this.buttons) {
                    if (!titledItem.getName().equals("-Sql-Scripts Time Config-")) continue;
                    h = (int)((double)h + titledItem.getPreferredSize().getHeight());
                    h += border;
                }
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (AdminConfig.this.animation != null) {
                AdminConfig.this.animation.setLocation((int)(((double)parent.getWidth() - AdminConfig.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - AdminConfig.this.animation.getPreferredSize().getHeight()) / 2);
                AdminConfig.this.animation.setSize(AdminConfig.this.animation.getPreferredSize());
            }
            if (AdminConfig.this.isInserted) {
                int y = border;
                for (TitledItem titledItem : AdminConfig.this.buttons) {
                    titledItem.setLocation(border, y);
                    titledItem.setSize(titledItem.getPreferredSize());
                    y += titledItem.getHeight() + border;
                }
            }
        }
    }
}

