/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlepricecalculator;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticlePriceModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationReference;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceCalculationStrategyE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class ArticlePriceCalculatorModuleDataHandler
extends DefaultDataHandler<ArticlePriceCalculationReference, ArticlePriceCalculationComplete> {
    public ArticlePriceCalculatorModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticlePriceCalculationReference r = (ArticlePriceCalculationReference)node.getValue();
                ArticlePriceCalculationComplete art = (ArticlePriceCalculationComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getArticleCalculation(new ArticlePriceCalculationReference(r.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)art, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<ArticlePriceCalculationReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticlePriceCalculationComplete dto = (ArticlePriceCalculationComplete)node.getValue(ArticlePriceCalculationComplete.class);
                ArticlePriceCalculationComplete nDto = (ArticlePriceCalculationComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateArticleCalculation(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<ArticlePriceCalculationComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticlePriceCalculationComplete dto = (ArticlePriceCalculationComplete)node.getValue(ArticlePriceCalculationComplete.class);
                ArticlePriceCalculationComplete nDto = (ArticlePriceCalculationComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createArticleCalculation(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticlePriceCalculatorModuleDataHandler.this.setCurrentLoadMaximum(6);
                ArticlePriceCalculatorModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ArticlePriceCalculatorModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ArticlePriceCalculatorModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllArticlePriceCalculationStates();
                ArticlePriceCalculatorModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllArticlePriceCalculationStrategies();
                ArticlePriceCalculatorModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                ArticlePriceCalculatorModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ArticlePriceCalculatorModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ArticlePriceCalculationComplete> resetData(Node<ArticlePriceCalculationComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<ArticlePriceCalculationComplete> createEmptyNode() {
        ArticlePriceCalculationComplete a = new ArticlePriceCalculationComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        PeriodComplete range = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        a.setDataRange(range);
        a.setFactor(Double.valueOf(1.0));
        a.setDate(new Date(System.currentTimeMillis()));
        a.setState(ArticlePriceModificationStateE.DRAFT);
        a.setStrategy(ArticlePriceCalculationStrategyE.WEIGHTED_AVERAGE);
        a.setUseOrderDate(Boolean.valueOf(true));
        a.setCurrencyValidityDate(new Date(System.currentTimeMillis()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)a, false, false);
        return n;
    }

    @Override
    public Class<ArticlePriceCalculationComplete> getCommittingClass() {
        return ArticlePriceCalculationComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ArticlePriceCalculationReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

