/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotification.utils;

import ch.icit.pegasus.client.gui.modules.changenotification.utils.ChangeNotificationPanelEntry;
import ch.icit.pegasus.client.gui.modules.changenotification.utils.NotificationUpdater;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChangeNotificationPanel
extends DefaultPanel
implements Nodable,
NodeListener {
    private AWTEventListener scrollListener;
    private Node<?> node;
    private List<ChangeNotificationPanelEntry> entries = new CopyOnWriteArrayList<ChangeNotificationPanelEntry>();
    private NotificationUpdater updater = new NotificationUpdater(this);
    private int horizontalBorder = 10;
    private int verticalBorder = 16;
    private int verticalHeight = 170;
    private int startPositionMax;
    private int startPosition;
    private int positionIncrement = 1;
    private int manualPositionIncrement = 10;
    private Integer defaultAutoFadeOutSeconds = 300;
    private Integer defaultWaitForAnimationTime = 30;
    private int sciptCount = 0;
    private int sciptMax = 100;
    private Timer timer;

    public ChangeNotificationPanel() {
        ChangeNotificationSettingsComplete settings = ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getChangeNotificationSettings();
        this.positionIncrement = settings != null && settings.getAnimationInterval() != null ? settings.getAnimationInterval() : 1;
        this.defaultAutoFadeOutSeconds = settings != null && settings.getAutoFadeOutSeconds() != null ? settings.getAutoFadeOutSeconds() : 30;
        this.defaultWaitForAnimationTime = settings != null && settings.getAnimationDelay() != null ? settings.getAnimationDelay() : 3;
        this.startPositionMax = -1 * (this.verticalHeight + this.verticalBorder);
        this.scrollListener = event -> this.handleScrollEvent(event);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.scrollListener, 131072L);
        this.setLayout(new Layout());
    }

    private void handleScrollEvent(AWTEvent event) {
        if (event instanceof MouseWheelEvent) {
            MouseWheelEvent e = (MouseWheelEvent)event;
            this.sciptCount = this.sciptMax;
            this.incrementScroll(e.getPreciseWheelRotation() == -1.0, true);
        }
    }

    public void ensureAnimation() {
        if (this.timer == null) {
            this.timer = new Timer("Change Notification Timer");
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (ChangeNotificationPanel.this.sciptCount > 0) {
                        ChangeNotificationPanel.this.sciptCount--;
                        return;
                    }
                    ChangeNotificationPanel.this.incrementScroll(false, false);
                }
            }, 32L, 32L);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ChangeNotificationPanel.this.updateAges();
                }
            }, 300L, 300L);
        }
    }

    private void updateAges() {
        for (ChangeNotificationPanelEntry entry : this.getEntries()) {
            entry.updateAge();
        }
    }

    private void incrementScroll(boolean up, boolean manual) {
        if (this.getPreferredSize().getHeight() <= (double)this.getHeight()) {
            return;
        }
        if (up) {
            this.startPosition += manual ? this.manualPositionIncrement : this.positionIncrement;
            if (this.startPosition > 0) {
                this.startPosition += this.startPositionMax;
                this.rotateItemsUp();
            }
        } else {
            this.startPosition -= manual ? this.manualPositionIncrement : this.positionIncrement;
            if (this.startPosition < this.startPositionMax) {
                this.startPosition -= this.startPositionMax;
                this.rotateItemsDown();
            }
        }
        if (this.startPosition < this.startPositionMax) {
            this.startPosition -= this.startPositionMax;
            this.rotateItemsDown();
        }
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateItemsDown() {
        List<ChangeNotificationPanelEntry> list = this.entries;
        synchronized (list) {
            if (!this.entries.isEmpty()) {
                ChangeNotificationPanelEntry entry = this.entries.get(0);
                this.entries.remove(entry);
                this.entries.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateItemsUp() {
        List<ChangeNotificationPanelEntry> list = this.entries;
        synchronized (list) {
            int index = this.entries.size() - 1;
            if (index >= 0 && index < this.entries.size()) {
                ChangeNotificationPanelEntry entry = this.entries.get(index);
                this.entries.remove(entry);
                this.entries.add(0, entry);
            }
        }
    }

    public void stopTimer() {
        this.timer.cancel();
    }

    public List<ChangeNotificationPanelEntry> getEntries() {
        return this.entries;
    }

    @Override
    public void kill() {
        super.kill();
        for (ChangeNotificationPanelEntry entry : this.entries) {
            entry.kill();
        }
        this.entries.clear();
        this.updater.kill();
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.stopTimer();
    }

    @Override
    public List<Component> getFocusComponents() {
        return new ArrayList<Component>();
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = node;
        this.node.addNodeListener((NodeListener)this);
        this.updater.ensureTimer();
        this.ensureAnimation();
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
        for (ChangeNotificationPanelEntry entry : this.entries) {
            if (!entry.getNode().equals(child)) continue;
            return;
        }
        if (child.getValue(ChangeNotificationLight.class) != null) {
            this.addEntry(child);
        }
    }

    private void addEntry(Node<ChangeNotificationLight> child) {
        ChangeNotificationPanelEntry entry = new ChangeNotificationPanelEntry(this, this.verticalHeight);
        entry.setNode(child);
        this.entries.add(entry);
        this.add(entry);
        entry.fadeIn();
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        for (ChangeNotificationPanelEntry entry : this.entries) {
            if (!entry.getNode().equals(child)) continue;
            this.removeEntry(entry);
            return;
        }
    }

    private void removeEntry(ChangeNotificationPanelEntry entry) {
        entry.fadeOut(true);
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    public void uninstall(ChangeNotificationPanelEntry entry) {
        this.entries.remove(entry);
        this.repaint(32L);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ChangeNotificationPanel.this.verticalBorder + (ChangeNotificationPanel.this.verticalHeight + ChangeNotificationPanel.this.verticalBorder) * ChangeNotificationPanel.this.entries.size();
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            double prefHeight = ChangeNotificationPanel.this.getPreferredSize().getHeight();
            int startY = ChangeNotificationPanel.this.verticalBorder;
            if (prefHeight > (double)parent.getHeight()) {
                startY = ChangeNotificationPanel.this.startPosition;
            }
            for (ChangeNotificationPanelEntry entry : ChangeNotificationPanel.this.entries) {
                entry.setLocation(ChangeNotificationPanel.this.horizontalBorder, startY);
                entry.setSize(parent.getWidth() - 2 * ChangeNotificationPanel.this.horizontalBorder, ChangeNotificationPanel.this.verticalHeight);
                startY += ChangeNotificationPanel.this.verticalBorder + entry.getHeight();
            }
        }
    }
}

