/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.article.details;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.checkin.article.utils.PerUnitConverter;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.UnitSelectionUtil;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBoxListener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.calculator.IPackagingQuantity;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.GroupCheckInAccess;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreEntryTypeE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete_;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.ManualStockCheckinRemarkComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.ArticlePriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ArticleDetailsPanel
extends TableDetailsPanel<StockCheckinGroupLight>
implements SearchTextField2Listener {
    private static final long serialVersionUID = 1L;
    private TextLabel filterTitle;
    private TitledItem<SearchComboBox> customerSearch;
    private TitledItem<CheckBox> customerNoSearch;
    private CustomerReference currentCustomer;
    private boolean currentCustomerName;
    private boolean isAdd = false;
    private boolean editable = false;

    public ArticleDetailsPanel(RowEditor<StockCheckinGroupLight> editor, RDProvider provider) {
        super(editor, provider, editor.getModel().isAddRow());
        this.isAdd = editor.getModel().isAddRow();
        this.setTitleText(Words.ARTICLES);
        this.editable = provider.isWritable(GroupCheckInAccess.CORRECT);
        this.filterTitle = new TextLabel(Words.FILTER_CHAIN);
        this.customerSearch = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.customerNoSearch = new TitledItem<CheckBox>(new CheckBox(), Words.SEARCH_CUSTOMER_NO, TitledItem.TitledItemOrientation.WEST);
        this.customerSearch.getElement().addSearchTextFieldListener(this);
        this.customerNoSearch.getElement().addButtonListener(this);
        this.addToView(this.filterTitle);
        this.addToView(this.customerSearch);
        this.addToView(this.customerNoSearch);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 40, 40, 40));
        int tw1 = 2 * this.table.getCellPadding() + InputComboBox2.getPreferredWidth(this, 3);
        columns.add(new TableColumnInfo(Words.CHECKIN_AMOUNT, null, null, null, "", tw1 += EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding(), tw1, tw1));
        int tw = DateChooser.getPreferredWidth(this, true) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.EXPIRY_DATE, null, null, null, "", tw, tw, tw));
        tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        tw += 2 * this.table.getCellPadding();
        tw += InputComboBox.getPreferredUnitWidth(this);
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", tw += this.table.getInnerCellPadding(), tw, tw));
        columns.add(new TableColumnInfo(Words.LABELS, null, null, null, "", 75, 75, 75));
        columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 30, 30, 30));
        tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        ManualStockCheckinComplete c = new ManualStockCheckinComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        c.setAmount(new StoreQuantityComplete());
        c.setExpiryDate(CalendarUtil.getInfinityDate());
        c.setLabelPrintCount(Integer.valueOf(1));
        if (this.table.getModel().getNode().getChildCount() > 0) {
            TableRowImpl ra = (TableRowImpl)this.table.getRowAt(this.table.getRowCount() - 1);
            StorePositionLight sp = ra.getStorePosition();
            c.setStorePosition(sp);
        }
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        PriceComplete p = new PriceComplete();
        p.setClientOId(Long.valueOf(p.getNextId()));
        p.setCurrency(s.getCurrency());
        p.setPrice(Double.valueOf(0.0));
        c.setPrice(p);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
        this.table.getModel().getNode().addChild(n, 0L);
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        for (Table2RowPanel l : this.table.getRows()) {
            TableRowImpl p = (TableRowImpl)l;
            p.validateRow(validationObjects);
        }
        if (this.editor.getModel().isAddRow()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.ALL_POSITION_WITH_0_AMOUNT_WILL_BE_DELETED));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.filterTitle.setEnabled(isEnabled);
        this.customerSearch.setEnabled(isEnabled);
        this.customerNoSearch.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.filterTitle.kill();
        this.customerNoSearch.kill();
        this.customerSearch.kill();
        this.filterTitle = null;
        this.customerNoSearch = null;
        this.customerSearch = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customerSearch);
        CheckedListAdder.addToList(focusList, this.customerNoSearch);
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public void setNode(Node node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(StockCheckinGroupComplete_.stockCheckins));
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.customerNoSearch.getElement()) {
            this.currentCustomerName = this.customerNoSearch.getElement().isChecked();
            this.updateRowHints();
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    private void updateRowHints() {
        for (Table2RowPanel i : this.table.getRows()) {
            TableRowImpl p = (TableRowImpl)i;
            p.updateHints();
        }
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.currentCustomer = n.getValue() == null ? null : (CustomerReference)n.getValue();
        this.updateRowHints();
    }

    @Override
    public void layoutContainer(Container parent) {
        this.filterTitle.setLocation(this.horizontalBorder, this.verticalBorder);
        this.filterTitle.setSize(this.filterTitle.getPreferredSize());
        this.customerSearch.setLocation(this.horizontalBorder, this.filterTitle.getY() + this.filterTitle.getHeight() + this.inner_verticalBorder);
        this.customerSearch.setSize(180, (int)this.customerSearch.getPreferredSize().getHeight());
        this.customerNoSearch.setLocation(this.customerSearch.getX() + this.customerSearch.getWidth() + this.horizontalBorder, (int)((double)(this.customerSearch.getY() + this.customerSearch.getHeight()) - this.customerNoSearch.getPreferredSize().getHeight()));
        this.customerNoSearch.setSize(this.customerNoSearch.getPreferredSize());
        this.table.setLocation(0, this.customerSearch.getY() + this.customerSearch.getHeight() + this.verticalBorder);
        this.table.setSize(parent.getWidth(), 299);
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        int h = this.verticalBorder;
        h = (int)((double)h + this.filterTitle.getPreferredSize().getHeight());
        h += this.inner_verticalBorder;
        h = (int)((double)h + this.customerSearch.getPreferredSize().getHeight());
        h += this.verticalBorder;
        return new Dimension(0, h += 300);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    SearchTextField2Listener,
    StorePositionSearchBoxListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private Component articleSearch;
        private ArticleInfoButton infoButton;
        private Component quantity;
        private StockTransactionRemarkButton<?> remark;
        private InputComboBox price;
        private TextLabel perUnit;
        private DateChooser expiry;
        private StorePositionSearchBox position;
        private DeleteButton deleteButton;
        private TextField labels;
        private Node packNode;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            if (!ArticleDetailsPanel.this.editor.getModel().isAddRow()) {
                this.articleSearch = new TextLabel(this.createCheckinText((Node<ManualStockCheckinComplete>)m.getNode(), (Node<StockCheckinGroupComplete>)ArticleDetailsPanel.this.editor.getModel().getNode()));
                this.quantity = ArticleDetailsPanel.this.editable ? new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) : new QuantityRenderer((Node<?>)m.getNode().getChildNamed(ManualStockCheckinComplete_.amount));
            } else {
                this.articleSearch = SearchTextField2Factory.getBasicArticleCustomerSearchField(false, m.getNode().getChildNamed(ManualStockCheckinComplete_.article));
                ((SearchTextField2)this.articleSearch).addSearchTextFieldListener(this);
                Object[] o = new Object[7];
                Boolean canMoveAny = false;
                for (ModuleAccessRightComplete module : ArticleDetailsPanel.this.currentUser.getModules()) {
                    if (!module.getModule().getInvokingName().equals(GroupCheckInAccess.MODULE_CHECK_IN_GROUPED.getIdentifier())) continue;
                    for (DataFieldAccessRightComplete fieldAccessRight : module.getFieldAccessRights()) {
                        if (!fieldAccessRight.getField().getName().equals(GroupCheckInAccess.CHECKIN_ANY_ARTICLE.getName())) continue;
                        canMoveAny = null;
                    }
                }
                o[6] = canMoveAny == null ? null : Boolean.valueOf(true);
                ((SearchTextField2)this.articleSearch).setAdditionalSearchField(o);
                this.quantity = new InputComboBox2(m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            }
            ArticleDetailsPanel.this.editor.getModel().getNode().getChildNamed(StockCheckinGroupLight_.checkinDate).addNodeListener((NodeListener)this);
            if (ArticleDetailsPanel.this.editor.getModel().isAddRow()) {
                this.infoButton = new ArticleInfoButton((Node<BasicArticleReference>)m.getNode().getChildNamed(ManualStockCheckinComplete_.article), (Node<Date>)ArticleDetailsPanel.this.editor.getModel().getNode().getChildNamed(StockCheckinGroupLight_.checkinDate), 20735, "");
                this.remark = new StockTransactionRemarkButton<ManualStockCheckinRemarkComplete>(m.getNode().getChildNamed(ManualStockCheckinComplete_.remark), ManualStockCheckinRemarkComplete.class);
                this.expiry = new DateChooser(m.getNode().getChildNamed(ManualStockCheckinComplete_.expiryDate));
                this.price = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.price, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.price, PriceComplete_.currency}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
                this.perUnit = new TextLabel(m.getNode().getChildNamed(ManualStockCheckinComplete_.priceUnit), ConverterRegistry.getConverter(PerUnitConverter.class));
                this.packNode = new DTONode();
            } else {
                this.infoButton = new ArticleInfoButton((Node<BasicArticleReference>)m.getNode().getChildNamed(ManualStockCheckinComplete_.charge), (Node<Date>)ArticleDetailsPanel.this.editor.getModel().getNode().getChildNamed(StockCheckinGroupLight_.checkinDate), 715, TransactionToolkit.getCheckinCorrectionText((StockCheckinGroupComplete)ArticleDetailsPanel.this.editor.getModel().getNode().getValue(), (ManualStockCheckinComplete)this.model.getNode().getValue()));
                this.remark = new StockTransactionRemarkButton<ManualStockCheckinRemarkComplete>(m.getNode().getChildNamed(ManualStockCheckinComplete_.remark), ManualStockCheckinRemarkComplete.class);
                this.expiry = new DateChooser(m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.charge, ArticleChargeComplete_.expiryDate}));
                this.price = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.charge, ArticleChargeComplete_.price, PriceComplete_.price}), m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.charge, ArticleChargeComplete_.price, PriceComplete_.currency}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
                this.perUnit = new TextLabel(m.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.charge, ArticleChargeComplete_.priceUnit}), ConverterRegistry.getConverter(PerUnitConverter.class));
                this.packNode = this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.charge, ArticleChargeComplete_.packingQuantities});
            }
            this.labels = new TextField(this.model.getNode().getChildNamed(ManualStockCheckinComplete_.labelPrintCount), TextFieldType.INT);
            this.position = new StorePositionSearchBox();
            this.position.setFilter(TransactionType.CHECK_IN);
            if (Boolean.TRUE.equals(ArticleDetailsPanel.this.settings.getUseStoreEntryTypeRestrictionForManualTransactions()) && !ArticleDetailsPanel.this.provider.isWritable(GroupCheckInAccess.CHECKIN_TO_ANY_STORE)) {
                this.position.setStoreFilter(StoreEntryTypeE.IN);
            }
            this.position.setNode((Node<StorePositionLight>)m.getNode().getChildNamed(ManualStockCheckinComplete_.storePosition));
            this.position.addSearchListener(this);
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.setLayout(new Layout());
            this.setSearchHints();
            if (m.getNode().getChildNamed(ManualStockCheckinComplete_.article).getValue() != null) {
                this.newValueSelected((SearchTextField2)null, m.getNode().getChildNamed(ManualStockCheckinComplete_.article));
            }
            this.add(this.articleSearch);
            this.add(this.infoButton);
            this.add(this.quantity);
            this.add(this.remark);
            this.add(this.expiry);
            this.add(this.price);
            this.add(this.perUnit);
            this.add(this.position);
            this.add(this.deleteButton);
            this.add(this.labels);
        }

        private String createCheckinText(Node<ManualStockCheckinComplete> checkinNode, Node<StockCheckinGroupComplete> group) {
            StockCheckinGroupComplete checkinGroup = (StockCheckinGroupComplete)group.getValue();
            ManualStockCheckinComplete checkin = (ManualStockCheckinComplete)checkinNode.getValue();
            boolean wasCorrected = false;
            for (ManualStockCheckinCorrectionComplete correction : checkinGroup.getStockCheckinCorrections()) {
                if (!correction.getReferencedTransaction().equals((Object)checkin)) continue;
                wasCorrected = true;
            }
            String text = "";
            if (checkin.getCharge() != null && checkin.getCharge().getBasicArticle() != null) {
                BasicArticleLight artL = checkin.getCharge().getBasicArticle();
                text = artL.getNumber() + " - " + artL.getName();
                if (wasCorrected) {
                    text = "(" + WordsToolkit.toLowerCase((String)Words.CORRECTED) + ") " + text;
                }
            } else {
                text = Words.NULL_RETURN;
            }
            return text;
        }

        public StorePositionLight getStorePosition() {
            return (StorePositionLight)this.position.getNode().getValue();
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.articleSearch instanceof Focusable) {
                ((Focusable)((Object)this.articleSearch)).requestFocusInWindowNow();
            }
        }

        public void updateHints() {
            this.setSearchHints();
        }

        private void setSearchHints() {
            Object[] o = new Object[7];
            o[1] = ArticleDetailsPanel.this.currentCustomer;
            o[2] = ArticleDetailsPanel.this.currentCustomerName;
            Boolean canMoveAny = false;
            for (ModuleAccessRightComplete module : ArticleDetailsPanel.this.currentUser.getModules()) {
                if (!module.getModule().getInvokingName().equals(GroupCheckInAccess.MODULE_CHECK_IN_GROUPED.getIdentifier())) continue;
                for (DataFieldAccessRightComplete fieldAccessRight : module.getFieldAccessRights()) {
                    if (!fieldAccessRight.getField().getName().equals(GroupCheckInAccess.CHECKIN_ANY_ARTICLE.getName())) continue;
                    canMoveAny = null;
                }
            }
            o[6] = canMoveAny == null ? null : Boolean.valueOf(true);
            if (this.articleSearch instanceof SearchTextField2) {
                ((SearchTextField2)this.articleSearch).setAdditionalSearchField(o);
            }
        }

        public void validateRow(List<ScreenValidationObject> rets) {
            if (ArticleDetailsPanel.this.editor.getModel().isAddRow()) {
                BasicArticleLight article = (BasicArticleLight)this.model.getNode().getChildNamed(ManualStockCheckinComplete_.article).getValue();
                Date expiryDate = (Date)this.model.getNode().getChildNamed(ManualStockCheckinComplete_.expiryDate).getValue();
                if (article != null && UnitToolkit.checkSelfLifeDateIsSet(article, expiryDate).booleanValue()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_ARTICLE_NEEDS_EXPIRY_DATE_ENTRY, (Object[])new Object[]{article.getNumber() + "-" + article.getName()})));
                }
            } else if (this.model.getNode().getChildNamed(ManualStockCheckinComplete_.article).getValue() == null) {
                if (this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.charge, ArticleChargeComplete_.basicArticle}).getValue() == null) {
                    if (this.articleSearch instanceof SearchTextField2) {
                        ((SearchTextField2)this.articleSearch).setInvalid();
                    }
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ARTICLE_IS_SET_FOR_EACH_ENTRY));
                }
            } else {
                BasicArticleLight article = (BasicArticleLight)this.model.getNode().getChildNamed(ManualStockCheckinComplete_.article).getValue();
                Date expiryDate = (Date)this.model.getNode().getChildNamed(ManualStockCheckinComplete_.expiryDate).getValue();
                if (article != null && UnitToolkit.checkSelfLifeDateIsSet(article, expiryDate).booleanValue()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_ARTICLE_NEEDS_EXPIRY_DATE_ENTRY, (Object[])new Object[]{article.getNumber() + "-" + article.getName()})));
                }
            }
            if (ArticleDetailsPanel.this.editor.getModel().isAddRow() && this.model.getNode().getChildNamed(ManualStockCheckinComplete_.storePosition).getValue() == null) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_STORE_POSITION_IS_SET));
                this.position.setInValid();
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            if (this.articleSearch instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.articleSearch));
            }
            if (this.quantity instanceof Focusable) {
                CheckedListAdder.addToList(focusList, (Focusable)((Object)this.quantity));
            }
            focusList.addAll(this.remark.getFocusComponents());
            focusList.addAll(this.expiry.getFocusComponents());
            focusList.addAll(this.price.getFocusComponents());
            focusList.addAll(this.labels.getFocusComponents());
            focusList.addAll(this.position.getFocusComponents());
            focusList.addAll(this.deleteButton.getFocusComponents());
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    if (this.model.getNode().getChildNamed(ManualStockCheckinComplete_.article).getValue() != null) {
                        return this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.article, BasicArticleLight_.number}).getValue();
                    }
                    return null;
                }
                case 1: {
                    if (this.model.getNode().getChildNamed(ManualStockCheckinComplete_.amount).getValue() != null) {
                        return this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.amount}).getValue();
                    }
                    return null;
                }
                case 2: {
                    if (this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.price, PriceComplete_.price}) != null && this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.price, PriceComplete_.price}).getValue() != null) {
                        return this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.price, PriceComplete_.price}).getValue();
                    }
                    return null;
                }
                case 3: 
                case 5: {
                    if (this.model.getNode().getChildNamed(ManualStockCheckinComplete_.expiryDate).getValue() != null) {
                        return this.model.getNode().getChildNamed(ManualStockCheckinComplete_.expiryDate);
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean itemSelected = isEnabled;
            if (this.articleSearch instanceof SearchTextField2) {
                itemSelected = itemSelected && ((SearchTextField2)this.articleSearch).isItemSelected();
            }
            this.articleSearch.setEnabled(isEnabled && ArticleDetailsPanel.this.isAdd);
            this.infoButton.setEnabled(itemSelected);
            this.quantity.setEnabled(itemSelected && (ArticleDetailsPanel.this.isAdd || ArticleDetailsPanel.this.editable));
            this.remark.setEnabled(itemSelected && ArticleDetailsPanel.this.isAdd);
            this.price.setEnabled(itemSelected && ArticleDetailsPanel.this.isAdd);
            this.perUnit.setEnabled(itemSelected && ArticleDetailsPanel.this.isAdd);
            this.expiry.setEnabled(itemSelected && ArticleDetailsPanel.this.isAdd);
            this.position.setEnabled(itemSelected && ArticleDetailsPanel.this.isAdd);
            this.deleteButton.setEnabled(isEnabled && ArticleDetailsPanel.this.isAdd);
            this.labels.setEnabled(isEnabled && ArticleDetailsPanel.this.isAdd);
            ArticleDetailsPanel.this.editor.createFocusCycle();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.articleSearch instanceof Killable) {
                ((Killable)((Object)this.articleSearch)).kill();
            }
            if (this.quantity instanceof Killable) {
                ((Killable)((Object)this.quantity)).kill();
            }
            ArticleDetailsPanel.this.editor.getModel().getNode().getChildNamed(StockCheckinGroupLight_.checkinDate).removeNodeListener((NodeListener)this);
            this.remark.kill();
            this.price.kill();
            this.expiry.kill();
            this.position.kill();
            this.deleteButton.kill();
            this.perUnit.kill();
            this.labels.kill();
            this.articleSearch = null;
            this.quantity = null;
            this.remark = null;
            this.price = null;
            this.expiry = null;
            this.position = null;
            this.deleteButton = null;
            this.perUnit = null;
            this.labels = null;
        }

        @Override
        public void selectionChanged(SearchComboBox store, SearchTextField2 position) {
            StorePositionLight storePosition = (StorePositionLight)position.getNode().getValue();
            if (storePosition != null) {
                this.position.getNode().setValue((Object)storePosition, 0L);
                BasicArticleComplete article = (BasicArticleComplete)this.model.getNode().getChildNamed(ManualStockCheckinComplete_.article).getValue(BasicArticleComplete.class);
                ArticleChargeComplete charge = null;
                if (this.getModel().getNode().getChildNamed(ManualStockCheckinComplete_.charge).getValue() != null) {
                    ArticleChargeReference reference = new ArticleChargeReference(((ArticleChargeLight)this.getModel().getNode().getChildNamed(ManualStockCheckinComplete_.charge).getValue()).getId());
                    try {
                        charge = (ArticleChargeComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticleCharge(reference).getValue();
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                }
                this.updateQuantitySelectionUnits(article, charge, storePosition);
            }
        }

        public void newValueSelected(SearchTextField2 source, final Node articleNode) {
            if (articleNode.getValue(BasicArticleComplete.class) == null) {
                this.setEnabled(false);
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        BasicArticleLight articleLight = (BasicArticleLight)articleNode.getValue();
                        BasicArticleComplete articleComplete = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(articleLight.getId())).getValue();
                        articleNode.removeExistingValues();
                        TableRowImpl.this.validatePackingTable(articleComplete);
                        articleNode.setValue((Object)articleComplete, 0L);
                        return articleNode;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                TableRowImpl.this.initRow(node);
                            }

                            public void errorOccurred(ClientException exception) {
                                ArticleDetailsPanel.this.errorOccurred(exception);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                this.initRow(articleNode);
            }
        }

        private void validatePackingTable(BasicArticleComplete articleComplete) {
            StorePositionLight storePositionLight = (StorePositionLight)this.position.getNode().getValue();
            ArticleChargeComplete charge = null;
            if (this.getModel().getNode().getChildNamed(ManualStockCheckinComplete_.charge).getValue() != null) {
                ArticleChargeReference reference = new ArticleChargeReference(((ArticleChargeLight)this.getModel().getNode().getChildNamed(ManualStockCheckinComplete_.charge).getValue()).getId());
                try {
                    charge = (ArticleChargeComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticleCharge(reference).getValue();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            this.updateQuantitySelectionUnits(articleComplete, charge, storePositionLight);
        }

        private void initRow(Node node) {
            BasicArticleComplete articleComplete = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
            ArticleChargeComplete charge = null;
            if (this.getModel().getNode().getChildNamed(ManualStockCheckinComplete_.charge).getValue() != null) {
                ArticleChargeReference reference = new ArticleChargeReference(((ArticleChargeLight)this.getModel().getNode().getChildNamed(ManualStockCheckinComplete_.charge).getValue()).getId());
                try {
                    charge = (ArticleChargeComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getArticleCharge(reference).getValue();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            if (this.model.getNode().getChildNamed(ManualStockCheckinComplete_.amount).getValue() == null) {
                StoreQuantityComplete quantity = new StoreQuantityComplete();
                quantity.setAmount(Long.valueOf(0L));
                quantity.setUnit(articleComplete.getFloatStoreUnit());
                this.model.getNode().getChildNamed(ManualStockCheckinComplete_.amount).setValue((Object)quantity, 0L);
                this.model.getNode().getChildNamed(ManualStockCheckinComplete_.amount).updateNode();
                if (this.quantity instanceof Nodable) {
                    ((Nodable)((Object)this.quantity)).setNode(this.model.getNode().getChildNamed(ManualStockCheckinComplete_.amount));
                }
            }
            if (this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.unit}).getValue() == null) {
                this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.unit}).setValue((Object)articleComplete.getFloatStoreUnit(), 0L);
            }
            if (this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.amount}).getValue() == null) {
                this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.amount}).setValue((Object)0.0, 0L);
            }
            Date exp = UnitToolkit.getExpiryDate(articleComplete, new Timestamp(System.currentTimeMillis()));
            this.model.getNode().getChildNamed(ManualStockCheckinComplete_.expiryDate).setValue((Object)exp, 0L);
            this.model.getNode().getChildNamed(ManualStockCheckinComplete_.priceUnit).setValue((Object)articleComplete.getPriceUnit(), 0L);
            StorePositionLight storePositionLight = null;
            Node storePosition = this.model.getNode().getChildNamed(ManualStockCheckinComplete_.storePosition);
            if (storePosition.getValue() == null || ArticleDetailsPanel.this.isAdd) {
                if (!articleComplete.getStoreConditions().isEmpty()) {
                    storePosition.setValue((Object)((StoreConditionComplete)articleComplete.getStoreConditions().get(0)).getPosition(), 0L);
                    if (this.position != null) {
                        this.position.setNode((Node<StorePositionLight>)storePosition);
                    }
                }
                if (this.position != null) {
                    storePositionLight = (StorePositionLight)this.position.getNode().getValue();
                    if (ArticleDetailsPanel.this.isAdd) {
                        if (storePositionLight != null && storePositionLight.getStore().getMainStore().booleanValue()) {
                            this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.unit}).setValue((Object)articleComplete.getMainStoreUnit(), 0L);
                        } else {
                            this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.amount, StoreQuantityComplete_.unit}).setValue((Object)articleComplete.getFloatStoreUnit(), 0L);
                        }
                    }
                }
            } else {
                storePositionLight = (StorePositionLight)storePosition.getValue();
            }
            PriceComplete brutto = ArticlePriceCalculationToolkit.getBruttoPrice((BasicArticleLight)articleComplete, (Timestamp)new Timestamp(System.currentTimeMillis()), null, (boolean)false);
            this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.price, PriceComplete_.price}).setValue((Object)brutto.getPrice(), 0L);
            this.model.getNode().getChildNamed(new DtoField[]{ManualStockCheckinComplete_.price, PriceComplete_.currency}).setValue((Object)brutto.getCurrency(), 0L);
            this.updateQuantitySelectionUnits(articleComplete, charge, storePositionLight);
            this.setEnabled(true);
        }

        private void updateQuantitySelectionUnits(BasicArticleComplete articleComplete, ArticleChargeComplete charge, StorePositionLight storePosition) {
            Date date = (Date)ArticleDetailsPanel.this.editor.getModel().getNode().getChildNamed(StockCheckinGroupComplete_.checkinDate).getValue();
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            if (this.quantity instanceof InputComboBox2) {
                List<UnitComplete> list;
                if (storePosition != null) {
                    list = charge != null ? StoreToolkit.getPossibleUnits((ArticleChargeComplete)charge, (TransactionType)TransactionType.CHECK_IN, (UserComplete)currentUser, null, (StoreLight)storePosition.getStore(), (SystemSettingsComplete)ArticleDetailsPanel.this.settings) : StoreToolkit.getPossibleUnits((BasicArticleLight)articleComplete, null, (Timestamp)new Timestamp(date.getTime()), (TransactionType)TransactionType.CHECK_IN, (UserComplete)currentUser, null, (StoreLight)storePosition.getStore(), (SystemSettingsComplete)ArticleDetailsPanel.this.settings);
                } else {
                    list = new ArrayList();
                    List conversion = articleComplete.getPackingQuantitiesVariant(new Timestamp(System.currentTimeMillis())).getConversion();
                    for (IPackagingQuantity currentConversion : conversion) {
                        UnitComplete unit = (UnitComplete)currentConversion.getUnit();
                        list.addAll(UnitConversionToolkit.getAllUnits((UnitComplete)unit));
                    }
                }
                ViewNode unitList = UnitConversionToolkitNodeBased.getUnitList(list);
                ((InputComboBox2)this.quantity).setPossibleUnits((Node)unitList);
                ((InputComboBox2)this.quantity).setNode(this.model.getNode().getChildNamed(ManualStockCheckinComplete_.amount));
                if (ArticleDetailsPanel.this.isAdd) {
                    UnitSelectionUtil.selectUnit(list, (InputComboBox2)this.quantity, (BasicArticleLight)articleComplete);
                }
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        public void valueChanged(Node<?> node) {
            this.validatePackingTable((BasicArticleComplete)this.model.getNode().getChildNamed(ManualStockCheckinComplete_.article).getValue(BasicArticleComplete.class));
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?>[] nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.articleSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.articleSearch.getPreferredSize().getHeight()) / 2.0));
                double dif = (double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.infoButton.getPreferredSize().getWidth();
                TableRowImpl.this.articleSearch.setSize((int)((double)w - dif), (int)TableRowImpl.this.articleSearch.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.articleSearch.getX() + TableRowImpl.this.articleSearch.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.remark.getPreferredSize().getWidth())), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                TableRowImpl.this.remark.setLocation(TableRowImpl.this.quantity.getX() + TableRowImpl.this.quantity.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.remark.setSize(TableRowImpl.this.remark.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.expiry.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.expiry.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.expiry.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.expiry.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.perUnit.getPreferredSize().getWidth())), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                TableRowImpl.this.perUnit.setLocation(TableRowImpl.this.price.getX() + TableRowImpl.this.price.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.perUnit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.perUnit.setSize(TableRowImpl.this.perUnit.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.labels.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.labels.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.labels.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.labels.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.position.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.position.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.position.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.position.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }
        }
    }
}

