/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.felfel.daily.utils;

import ch.icit.pegasus.client.gui.modules.felfel.daily.FelFelBoxReturnModule;
import ch.icit.pegasus.client.gui.modules.felfel.daily.utils.DailyStatePanel;
import ch.icit.pegasus.client.gui.modules.felfel.daily.utils.ScanmePanel;
import ch.icit.pegasus.client.gui.modules.felfel.daily.utils.ScannerField;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.FelFelServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.utils.BarcodeType;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Timer;

public class DailyPanel {
    private final FelFelBoxReturnModule module;
    private ScannerField scannerField;
    private DailyStatePanel currentPanel;
    private Timer timer;

    public DailyPanel(FelFelBoxReturnModule module) {
        this.module = module;
        this.scannerField = new ScannerField(this);
        this.currentPanel = new ScanmePanel(this, !module.isTablewareReturn());
        this.showHud(false);
        module.add(this.scannerField);
        module.add(this.currentPanel);
    }

    public void showHud(boolean show) {
        if (show) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        } else if (this.timer == null) {
            this.timer = new Timer(200, e -> this.scannerField.requestFocusInWindowNow());
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    public void setEnabled(boolean isEnabled) {
        if (this.currentPanel != null) {
            this.currentPanel.setEnabled(isEnabled);
        }
        if (this.scannerField != null) {
            this.scannerField.setEnabled(isEnabled);
        }
    }

    public void kill() {
        if (this.currentPanel != null) {
            this.currentPanel.kill();
            this.currentPanel = null;
        }
        if (this.scannerField != null) {
            this.scannerField.kill();
            this.scannerField = null;
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void barcodeReady(BarcodeType barcodeType, final String barcode) {
        this.scannerField.resetText();
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ((FelFelServiceManager)ServiceManagerRegistry.getService(FelFelServiceManager.class)).scanTableware(barcode, Boolean.valueOf(DailyPanel.this.module.isTablewareReturn()));
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)DailyPanel.this.module);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void layoutContainer(Container parent) {
        if (this.currentPanel != null) {
            this.currentPanel.setLocation(0, 20);
            this.currentPanel.setSize(parent.getWidth(), parent.getHeight() - this.currentPanel.getY());
        }
        this.scannerField.setLocation((int)(((double)parent.getWidth() - this.scannerField.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - this.scannerField.getPreferredSize().getHeight()));
        this.scannerField.setSize(this.scannerField.getPreferredSize());
    }
}

