/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details.utils;

import ch.icit.pegasus.client.converter.MealPlanConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.stowinglist.details.utils.LoadingGroupMappingConverter;
import ch.icit.pegasus.client.gui.modules.stowinglist.details.utils.MealPlanSwitchNodeFilter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.panels.LegMappingTable;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.MappingTable2D;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.multiprint.ScrollablePopupInsert;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.client.util.toolkits.MealPlanToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.mealplan.MealplanTemplateLegComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MealPlanMappingPopup
extends ScrollablePopupInsert {
    static Logger log = LoggerFactory.getLogger(MealPlanMappingPopup.class);
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> mealPlanToSwitch;
    private TitledItem<TextLabel> newMealPlan;
    private HorizontalSeparator sep1;
    private LegMappingTable legMapping;
    private Node<MealPlanLight> newMealPlanNode;
    private Node<StowingListTemplateVariantLight> currentStowingList;
    private Node<List<CateringServiceScheduleComplete>> services;
    private Node<List<CateringServiceScheduleComplete>> newServices;
    private boolean autoMapThings;
    private LoadingAnimation animation;
    private TitledItem<MappingTable2D<ALoadingGroupComplete, ALoadingGroupComplete>> serviceMapping;
    private Node<MealPlanLight> currentMealPlan;
    protected List<ALoadingGroupComplete> usedGroups;
    private Node<Map<ALoadingGroupComplete, ALoadingGroupComplete>> serviceMappingNode;
    private Node<Map<MealplanTemplateLegComplete, StowingListTemplateVariantLegComplete>> legMappingNode;

    public MealPlanMappingPopup(Node<StowingListTemplateVariantLight> currentStowing, Node<MealPlanLight> currentMealPlanNode, Node<MealPlanLight> newMealPlanNode, Node<Map<MealplanTemplateLegComplete, StowingListTemplateVariantLegComplete>> legMappingNode, Node<Map<ALoadingGroupComplete, ALoadingGroupComplete>> serviceMappingNode) {
        this(currentStowing, currentMealPlanNode, newMealPlanNode, legMappingNode, serviceMappingNode, Words.LEG_FROM_MP, Words.IS_REPLACE_BY_NEW_MP, true);
    }

    public MealPlanMappingPopup(Node<StowingListTemplateVariantLight> currentStowing, Node<MealPlanLight> currentMealPlanNode, Node<MealPlanLight> newMealPlanNode, Node<Map<MealplanTemplateLegComplete, StowingListTemplateVariantLegComplete>> legMappingNode, Node<Map<ALoadingGroupComplete, ALoadingGroupComplete>> serviceMappingNode, String t1, String t2, boolean autoMap) {
        this.border = 10;
        this.currentStowingList = currentStowing;
        this.currentMealPlan = currentMealPlanNode;
        this.newMealPlanNode = newMealPlanNode;
        this.serviceMappingNode = serviceMappingNode;
        this.legMappingNode = legMappingNode;
        this.autoMapThings = autoMap;
        this.getViewContainer().setLayout(new Layout());
        this.mealPlanToSwitch = new TitledItem<TextLabel>(new TextLabel(currentMealPlanNode, ConverterRegistry.getConverter(MealPlanConverter.class)), "Current Meal Plan", TitledItem.TitledItemOrientation.NORTH);
        this.newMealPlan = new TitledItem<TextLabel>(new TextLabel(newMealPlanNode, ConverterRegistry.getConverter(MealPlanConverter.class)), "New Meal Plan", TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new HorizontalSeparator();
        this.serviceMapping = new TitledItem<1>(new MappingTable2D<ALoadingGroupComplete, ALoadingGroupComplete>(LoadingGroupMappingConverter.class, LoadingGroupMappingConverter.class, "Loading Group (from old MP)", "is replaced by (from new MP)", null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public void findSelection(Node<ALoadingGroupComplete> currentNode, String text, List<Node<ALoadingGroupComplete>> mappingList, TextLabel currentCombo, List<Node<ALoadingGroupComplete>> sources) {
                ALoadingGroupComplete currentGroup = (ALoadingGroupComplete)currentNode.getValue();
                CateringServiceScheduleVariantComplete currentService = (CateringServiceScheduleVariantComplete)currentNode.getParent().getParent().getParent().getParent().getParent().getValue();
                if (!MealPlanMappingPopup.this.autoMapThings && MealPlanMappingPopup.this.serviceMappingNode != null) {
                    Node n;
                    ALoadingGroupComplete mapped = (ALoadingGroupComplete)((Map)MealPlanMappingPopup.this.serviceMappingNode.getValue()).get(currentGroup);
                    if (mapped != null && (n = INodeCreator.getDefaultImpl().getNode4DTO((Object)mapped, true, false)) != null) {
                        currentCombo.setNode(n);
                    }
                } else {
                    Node<ALoadingGroupComplete> secondChoice = null;
                    Node<ALoadingGroupComplete> thirdChoice = null;
                    int match = -1;
                    for (Node<ALoadingGroupComplete> n : mappingList) {
                        match = MealPlanMappingPopup.this.getBestMatch(n, currentService.getBase(), currentGroup);
                        if (match == -1) continue;
                        if (match == 0) {
                            currentCombo.setNode((Node)n);
                            return;
                        }
                        if (match == 1) {
                            secondChoice = n;
                            continue;
                        }
                        if (match != 2) continue;
                        thirdChoice = n;
                    }
                    match = secondChoice != null ? 1 : (thirdChoice != null ? 2 : -1);
                    boolean hasBetterMatch = false;
                    if (secondChoice != null) {
                        hasBetterMatch = MealPlanMappingPopup.this.hasBetterMatch(secondChoice, match, sources);
                    } else if (thirdChoice != null) {
                        hasBetterMatch = MealPlanMappingPopup.this.hasBetterMatch(thirdChoice, match, sources);
                    }
                    if (!hasBetterMatch) {
                        if (secondChoice != null) {
                            currentCombo.setNode((Node)secondChoice);
                        } else if (thirdChoice != null) {
                            currentCombo.setNode((Node)thirdChoice);
                        }
                    }
                }
            }
        }, Words.STOWAGE_MAPPING, TitledItem.TitledItemOrientation.NORTH);
        Node n = legMappingNode;
        if (n == null) {
            n = new Node();
        }
        this.legMapping = new LegMappingTable(null, null, (Node<Map<ALegComplete, ALegComplete>>)n, t1, t2, "Leg Mapping", autoMap);
        this.serviceMapping.getElement().setNodeFilter(new MealPlanSwitchNodeFilter(this.legMapping));
        this.getViewContainer().add(this.mealPlanToSwitch);
        this.getViewContainer().add(this.newMealPlan);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.serviceMapping);
        this.getViewContainer().add(this.legMapping);
        this.loadMealPlanData();
    }

    private void showAnimation(String text) {
        this.setEnabled(false);
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.getViewContainer().add((Component)this.animation, 0);
            this.animation.start();
            this.animation.fadeIn();
        }
        this.animation.stateChanged(text);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.setEnabled(true);
    }

    public int getBestMatch(Node<ALoadingGroupComplete> n, CateringServiceScheduleComplete currentService, ALoadingGroupComplete currentGroup) {
        ILegComplete leg2;
        Node service = n.getParent().getParent().getParent().getParent().getParent();
        CateringServiceScheduleComplete s = ((CateringServiceScheduleVariantComplete)service.getValue()).getBase();
        ALoadingGroupComplete newGroup = (ALoadingGroupComplete)n.getValue();
        ILegComplete leg = !s.getLegs().isEmpty() ? (ILegComplete)s.getLegs().get(0) : null;
        ILegComplete iLegComplete = leg2 = !currentService.getLegs().isEmpty() ? (ILegComplete)currentService.getLegs().get(0) : null;
        if (leg == null || leg2 == null) {
            return -1;
        }
        if (newGroup.getName().toLowerCase().equals(currentGroup.getName().toLowerCase()) && s.getCabinClass().equals((Object)currentService.getCabinClass()) && s.getType().equals((Object)currentService.getType())) {
            Integer i2;
            Integer i1 = leg.getNumber();
            if (i1.equals(i2 = leg2.getNumber())) {
                return 0;
            }
        } else if (newGroup.getName().toLowerCase().equals(currentGroup.getName().toLowerCase()) && s.getCabinClass().equals((Object)currentService.getCabinClass())) {
            Integer i2;
            Integer i1 = leg.getNumber();
            if (i1.equals(i2 = leg2.getNumber())) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    public boolean hasBetterMatch(Node<ALoadingGroupComplete> currentChoice, int currentMatch, List<Node<ALoadingGroupComplete>> sources) {
        ALoadingGroupComplete currentGroup = (ALoadingGroupComplete)currentChoice.getValue();
        CateringServiceScheduleComplete currentService = (CateringServiceScheduleComplete)currentChoice.getParent().getParent().getParent().getParent().getParent().getValue();
        for (Node<ALoadingGroupComplete> n : sources) {
            int match;
            if (((ALoadingGroupComplete)n.getValue()).equals(currentChoice.getValue()) || (match = this.getBestMatch(n, currentService, currentGroup)) >= currentMatch || match == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.mealPlanToSwitch != null) {
            this.mealPlanToSwitch.setEnabled(isEnabled);
        }
        if (this.newMealPlan != null) {
            this.newMealPlan.setEnabled(isEnabled);
        }
        if (this.sep1 != null) {
            this.sep1.setEnabled(isEnabled);
        }
        if (this.legMapping != null) {
            this.legMapping.setEnabled(isEnabled);
        }
        if (this.serviceMapping != null) {
            this.serviceMapping.setEnabled(isEnabled);
        }
    }

    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Map<ALoadingGroupComplete, ALoadingGroupComplete> mt = this.serviceMapping.getElement().getInvertedMappingTable();
        Map<ALegComplete, ALegComplete> lm = this.legMapping.getInverseMappingTable();
        for (ALoadingGroupComplete g : mt.values()) {
            for (ILegComplete l : g.getContainingService().getLegs()) {
                if (lm.containsValue(l)) continue;
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Leg " + l.getDepartureAirport().getCode() + " - " + l.getArrivalAirport().getCode() + " is not mapped, but used in Stowage Mapping!"));
            }
        }
        ArrayList<Object> sourceGroup = new ArrayList<Object>();
        ArrayList<Object> targetGroup = new ArrayList<Object>();
        if (this.newMealPlanNode != null) {
            Node group;
            Node part;
            Iterator it3;
            Node rotation;
            Iterator it2;
            Node service;
            Node n;
            Iterator it = this.currentMealPlan.getChildNamed(MealPlanLight_.legs).getFailSafeChildIterator();
            while (it.hasNext()) {
                n = (Node)it.next();
                sourceGroup.add(n.getValue());
            }
            it = this.newMealPlanNode.getChildNamed(MealPlanLight_.legs).getFailSafeChildIterator();
            while (it.hasNext()) {
                n = (Node)it.next();
                targetGroup.add(n.getValue());
            }
            List c = LegToolkit.validateLegMapping(lm, sourceGroup, targetGroup, (boolean)true);
            a.addAll(c);
            ArrayList<ALoadingGroupComplete> sourceGroups = new ArrayList<ALoadingGroupComplete>();
            ArrayList<ALoadingGroupComplete> targetGroups = new ArrayList<ALoadingGroupComplete>();
            it = this.services.getFailSafeChildIterator();
            while (it.hasNext()) {
                service = (Node)it.next();
                it2 = service.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.currentVariant, CateringServiceScheduleVariantComplete_.rotations}).getFailSafeChildIterator();
                if (!it2.hasNext()) continue;
                rotation = (Node)it2.next();
                it3 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    part = (Node)it3.next();
                    group = part.getChildNamed(CateringServicePartComplete_.loadingGroup);
                    sourceGroups.add((ALoadingGroupComplete)group.getValue());
                }
            }
            it = this.newServices.getFailSafeChildIterator();
            while (it.hasNext()) {
                service = (Node)it.next();
                it2 = service.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.currentVariant, CateringServiceScheduleVariantComplete_.rotations}).getFailSafeChildIterator();
                if (!it2.hasNext()) continue;
                rotation = (Node)it2.next();
                it3 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    part = (Node)it3.next();
                    group = part.getChildNamed(CateringServicePartComplete_.loadingGroup);
                    targetGroups.add((ALoadingGroupComplete)group.getValue());
                }
            }
            List<ScreenValidationObject> b = MealPlanToolkit.validateLoadingGroupMapping(mt, sourceGroups, targetGroups, true, this.usedGroups);
            a.addAll(b);
        } else {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_DESTINATION_MP_SELECTED));
        }
        MealPlanLight mp = (MealPlanLight)this.newMealPlan.getElement().getNode().getValue();
        if (mp == null) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.SELECT_A_MEAL_PLAN_TO_SWITCH_FIRST));
        }
        return a;
    }

    private void createMappingTable(Node<?> currentNode) {
        Node group;
        Node part;
        Iterator it3;
        Node rotation;
        Iterator it2;
        Node service;
        Node n;
        ArrayList<Node<ALegComplete>> sourceGroup = new ArrayList<Node<ALegComplete>>();
        ArrayList<Node<ALegComplete>> targetGroup = new ArrayList<Node<ALegComplete>>();
        Iterator it = this.newMealPlanNode.getChildNamed(MealPlanLight_.legs).getFailSafeChildIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            sourceGroup.add(n);
        }
        if (this.currentStowingList != null && this.currentStowingList.getChildNamed(StowingListTemplateVariantLight_.legs) != null) {
            it = this.currentStowingList.getChildNamed(StowingListTemplateVariantLight_.legs).getFailSafeChildIterator();
            while (it.hasNext()) {
                n = (Node)it.next();
                targetGroup.add(n);
            }
        }
        ArrayList sourceGroup2 = new ArrayList();
        ArrayList targetGroup2 = new ArrayList();
        it = this.services.getFailSafeChildIterator();
        while (it.hasNext()) {
            service = (Node)it.next();
            it2 = service.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.currentVariant, CateringServiceScheduleVariantComplete_.rotations}).getFailSafeChildIterator();
            if (!it2.hasNext()) continue;
            rotation = (Node)it2.next();
            it3 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
            while (it3.hasNext()) {
                part = (Node)it3.next();
                group = part.getChildNamed(CateringServicePartComplete_.loadingGroup);
                if (group == null || this.usedGroups == null || !this.usedGroups.contains(group.getValue())) continue;
                sourceGroup2.add(group);
            }
        }
        if (this.newServices != null) {
            it = this.newServices.getFailSafeChildIterator();
            while (it.hasNext()) {
                service = (Node)it.next();
                it2 = service.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.currentVariant, CateringServiceScheduleVariantComplete_.rotations}).getFailSafeChildIterator();
                if (!it2.hasNext()) continue;
                rotation = (Node)it2.next();
                it3 = rotation.getChildNamed(CateringServiceRotationComplete_.parts).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    part = (Node)it3.next();
                    group = part.getChildNamed(CateringServicePartComplete_.loadingGroup);
                    if (group == null) continue;
                    targetGroup2.add(group);
                }
            }
        }
        if (this.legMapping != null) {
            this.legMapping.setData(sourceGroup, targetGroup);
            this.legMapping.startDownload();
        }
        if (this.serviceMapping != null) {
            this.serviceMapping.getElement().setData(sourceGroup2, targetGroup2);
            this.serviceMapping.getElement().startDownload();
        }
    }

    public void loadMealPlanData() {
        this.showAnimation(Words.LOAD);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<ALoadingGroupComplete> groups = new ArrayList<ALoadingGroupComplete>();
                MealPlanLight oldMealPlan = (MealPlanLight)MealPlanMappingPopup.this.currentMealPlan.getValue();
                MealPlanComplete oldMealPlanC = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlan(new MealPlanReference(oldMealPlan.getId())).getValue();
                List scheds = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedules(new MealPlanReference(oldMealPlan.getId())).getList();
                MealPlanMappingPopup.this.services = INodeCreator.getDefaultImpl().createNodes(scheds, false);
                List oldServices = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getUsedServices((MealPlanReference)oldMealPlan).getList();
                ArrayList refs = new ArrayList();
                for (CateringServiceScheduleComplete c : scheds) {
                    if (!oldServices.contains(c)) continue;
                    StowingListTemplateVariantReference sl = new StowingListTemplateVariantReference(((StowingListTemplateVariantLight)MealPlanMappingPopup.this.currentStowingList.getValue()).getId());
                    List oldUsedLoadingGroups = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getUsedLoadingGroups(sl, c);
                    refs.addAll(oldUsedLoadingGroups);
                    for (ALoadingGroupComplete g : c.getLoadingGroups()) {
                        if (!oldUsedLoadingGroups.contains(g)) continue;
                        groups.add(g);
                    }
                }
                MealPlanMappingPopup.this.currentMealPlan.removeExistingValues(MealPlanLight.class);
                MealPlanMappingPopup.this.currentMealPlan.setValue((Object)oldMealPlanC, 0L);
                MealPlanMappingPopup.this.usedGroups = groups;
                MealPlanLight l = (MealPlanLight)MealPlanMappingPopup.this.newMealPlanNode.getValue(MealPlanLight.class);
                MealPlanComplete newMealPlan = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlan(new MealPlanReference(l.getId())).getValue();
                List newScheds = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedules(new MealPlanReference(newMealPlan.getId())).getList();
                Iterator it = newScheds.iterator();
                while (it.hasNext()) {
                    CateringServiceScheduleComplete service = (CateringServiceScheduleComplete)it.next();
                    if (!Boolean.TRUE.equals(service.getIsDeleted())) continue;
                    it.remove();
                }
                MealPlanMappingPopup.this.newServices = INodeCreator.getDefaultImpl().createNodes(newScheds, false);
                MealPlanMappingPopup.this.newMealPlanNode.removeExistingValues();
                MealPlanMappingPopup.this.newMealPlanNode.setValue((Object)newMealPlan, 0L);
                return MealPlanMappingPopup.this.currentStowingList;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        MealPlanMappingPopup.this.createMappingTable(node);
                        MealPlanMappingPopup.this.hideAnimation();
                    }

                    public void errorOccurred(ClientException exception) {
                        MealPlanMappingPopup.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.newMealPlan);
        CheckedListAdder.addToList(a, this.legMapping);
        CheckedListAdder.addToList(a, this.serviceMapping);
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[0];
        }
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean b = false;
        if (this.legMapping != null) {
            b = this.legMapping.isInnerComponent(c);
        }
        if (!b && this.serviceMapping != null) {
            b = this.serviceMapping.getElement().isInnerComponent(c);
        }
        return b;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.mealPlanToSwitch.kill();
        this.newMealPlan.kill();
        this.legMapping.kill();
        this.serviceMapping.kill();
        this.mealPlanToSwitch = null;
        this.newMealPlan = null;
        this.legMapping = null;
        this.serviceMapping = null;
    }

    public Map<ALoadingGroupComplete, ALoadingGroupComplete> getServiceMap() {
        return this.serviceMapping.getElement().getInvertedMappingTable();
    }

    public Map<MealplanTemplateLegComplete, StowingListTemplateVariantLegComplete> getLegMap() {
        return this.legMapping.getInverseMappingTable2();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = MealPlanMappingPopup.this.border;
            h = (int)((double)h + MealPlanMappingPopup.this.mealPlanToSwitch.getPreferredSize().getHeight());
            h += MealPlanMappingPopup.this.border;
            h = (int)((double)h + MealPlanMappingPopup.this.newMealPlan.getPreferredSize().getHeight());
            h += MealPlanMappingPopup.this.border / 2;
            h = (int)((double)h + MealPlanMappingPopup.this.sep1.getPreferredSize().getHeight());
            h += MealPlanMappingPopup.this.border / 2;
            h = (int)((double)h + MealPlanMappingPopup.this.legMapping.getPreferredSize().getHeight());
            h += MealPlanMappingPopup.this.border;
            h = (int)((double)h + MealPlanMappingPopup.this.serviceMapping.getPreferredSize().getHeight());
            return new Dimension(0, h += MealPlanMappingPopup.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            MealPlanMappingPopup.this.mealPlanToSwitch.setLocation(MealPlanMappingPopup.this.border, MealPlanMappingPopup.this.border);
            MealPlanMappingPopup.this.mealPlanToSwitch.setSize(parent.getWidth() - 2 * MealPlanMappingPopup.this.border, (int)MealPlanMappingPopup.this.mealPlanToSwitch.getPreferredSize().getHeight());
            MealPlanMappingPopup.this.newMealPlan.setLocation(MealPlanMappingPopup.this.border, MealPlanMappingPopup.this.mealPlanToSwitch.getY() + MealPlanMappingPopup.this.mealPlanToSwitch.getHeight() + MealPlanMappingPopup.this.border);
            MealPlanMappingPopup.this.newMealPlan.setSize(parent.getWidth() - 2 * MealPlanMappingPopup.this.border, (int)MealPlanMappingPopup.this.newMealPlan.getPreferredSize().getHeight());
            MealPlanMappingPopup.this.sep1.setLocation(0, MealPlanMappingPopup.this.newMealPlan.getY() + MealPlanMappingPopup.this.newMealPlan.getHeight() + MealPlanMappingPopup.this.border / 2);
            MealPlanMappingPopup.this.sep1.setSize(parent.getWidth(), (int)MealPlanMappingPopup.this.sep1.getPreferredSize().getHeight());
            MealPlanMappingPopup.this.legMapping.setLocation(MealPlanMappingPopup.this.border, MealPlanMappingPopup.this.sep1.getY() + MealPlanMappingPopup.this.sep1.getHeight() + MealPlanMappingPopup.this.border / 2);
            MealPlanMappingPopup.this.legMapping.setSize(parent.getWidth() - 2 * MealPlanMappingPopup.this.border, (int)MealPlanMappingPopup.this.legMapping.getPreferredSize().getHeight());
            MealPlanMappingPopup.this.serviceMapping.setLocation(MealPlanMappingPopup.this.border, MealPlanMappingPopup.this.legMapping.getY() + MealPlanMappingPopup.this.legMapping.getHeight() + MealPlanMappingPopup.this.border);
            MealPlanMappingPopup.this.serviceMapping.setSize(parent.getWidth() - 2 * MealPlanMappingPopup.this.border, parent.getHeight() - (MealPlanMappingPopup.this.serviceMapping.getY() + MealPlanMappingPopup.this.border));
            if (MealPlanMappingPopup.this.animation != null) {
                MealPlanMappingPopup.this.animation.setLocation((int)((double)parent.getWidth() - MealPlanMappingPopup.this.animation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - MealPlanMappingPopup.this.animation.getPreferredSize().getHeight()) / 2.0));
                MealPlanMappingPopup.this.animation.setSize(MealPlanMappingPopup.this.animation.getPreferredSize());
            }
        }
    }
}

