/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details.utils;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.StowingListAircraftConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.FlightModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flight.details.AdditionalOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SealDefinitionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SpecialMenusDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.utils.StowingTableFooter;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Killable;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.ConfigButton;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.UpdateButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.MappingTable2D;
import ch.icit.pegasus.client.gui.utils.panels.MultiPaxTable;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.LegMappingPopupInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDRadioButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightScheduleAccess;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class StowingTable
extends JPanelFadable
implements Focusable {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private MultiPaxTable paxTable;
    private Table2Model tableModel;
    private Node node;
    private RowEditor editor;
    private FlightModuleDataHandler dataHandler;
    private Object lastSelectedDTO;
    private DtoField fieldName;
    private RDProvider provider;
    private boolean hasStowingAccess;
    private boolean isFlight;
    private StowingTableFooter stowingSwitchFooter;
    private SpecialMenusDetailsPanel spmlDetails;
    private AdditionalOrderDetailsPanel additionalDetails;
    private SealDefinitionDetailsPanel sealsPanel;

    public StowingTable(RowEditor editor, DtoField fieldName, RDProvider provider, boolean isFlight, SpecialMenusDetailsPanel spmlDetails, AdditionalOrderDetailsPanel additionals, SealDefinitionDetailsPanel sealsPanel, MultiPaxTable paxTable) {
        this(editor, fieldName, provider, isFlight, null, spmlDetails, additionals, sealsPanel, paxTable);
    }

    public StowingTable(RowEditor editor, DtoField fieldName, RDProvider provider, boolean isFlight, FlightModuleDataHandler dataHandler, SpecialMenusDetailsPanel spmlDetails, AdditionalOrderDetailsPanel additionals, SealDefinitionDetailsPanel sealsPanel, MultiPaxTable paxTable) {
        this.editor = editor;
        this.fieldName = fieldName;
        this.isFlight = isFlight;
        this.dataHandler = dataHandler;
        this.spmlDetails = spmlDetails;
        this.additionalDetails = additionals;
        this.sealsPanel = sealsPanel;
        this.provider = provider;
        this.hasStowingAccess = provider.hasSubRight((AccessDefinitionComplete)FlightScheduleAccess.TOOL_FLIGHT_SCHEDULE_STOWING_EDITOR) || provider.hasSubRight((AccessDefinitionComplete)FlightAccess.TOOL_FLIGHT_STOWING_EDITOR);
        this.table = new Table2(!isFlight, Words.ADD);
        this.paxTable = paxTable;
        this.table.setProvider(provider);
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        int checkWidth = CheckBox.getPreferredWidth();
        int delWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        delWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + UpdateButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getInnerCellPadding() + this.table.getCellPadding() * 2;
        headers.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", checkWidth += 2 * this.table.getCellPadding(), checkWidth, checkWidth));
        headers.add(new TableColumnInfo(0.5, 0.0, Words.STOWING_LIST, null, null, null, "", 70, 70, 70));
        headers.add(new TableColumnInfo(0.25, 0.0, Words.AIRCRAFT, null, null, null, "", 70, 70, 70));
        if (isFlight) {
            headers.add(new TableColumnInfo(0.25, 0.0, Words.MATRICULATION, null, null, null, "", 70, 70, 70));
        }
        headers.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", delWidth, delWidth, delWidth));
        this.tableModel = new Table2Model(headers, model -> new TableRowImpl(model)){

            @Override
            public void childAdded(Node<?> source, Node<?> child) {
                super.childAdded(source, child);
                StowingTable.this.ensureActiveStowingSelection();
            }
        };
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DTOProxyNode n = null;
                if (StowingTable.this.isFlight) {
                    n = new DTOProxyNode();
                } else {
                    StowingListConfigurationComplete config = new StowingListConfigurationComplete();
                    config.setClientOId(Long.valueOf(ADTO.getNextId()));
                    n = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, true, false);
                }
                StowingTable.this.table.getModel().getNode().addChild((Node)n, 0L);
                StowingTable.this.table.revalidate();
                StowingTable.this.table.getParent().validate();
            }

            @Override
            public void childRemoved() {
            }
        });
        this.table.setModel(this.tableModel);
        this.setLayout(new Layout());
        if (isFlight) {
            this.stowingSwitchFooter = new StowingTableFooter(dataHandler, spmlDetails, this.additionalDetails, sealsPanel, paxTable, editor);
            this.table.setFooterPanel(this.stowingSwitchFooter);
        }
        this.add(this.table);
    }

    public void setNode(Node node) {
        this.node = node;
        this.tableModel.setNode(this.node.getChildNamed(FlightScheduleComplete_.stowingLists));
        if (this.table.getFootablePanel() != null) {
            this.table.getFootablePanel().setNode(node);
        }
    }

    public Table2 getTable() {
        return this.table;
    }

    public List<ScreenValidationObject> validateTable() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            for (Table2RowPanel table2RowPanel : (List)((ArrayList)this.table.getRows()).clone()) {
                TableRowImpl pp = (TableRowImpl)table2RowPanel;
                List b = pp.validateRow();
                if (b == null || b.isEmpty()) continue;
                a.addAll(b);
            }
        }
        return a;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    protected void setActivStowingList(TableRowImpl row, Node sNode) {
        Node defaultS;
        if (sNode != null) {
            sNode.commitThis();
        }
        if ((defaultS = this.node.getChildNamed(this.getDefaultSTWName())) != null && defaultS.getValue() != null && this.editor.getModel().getNode() != null) {
            Node oldStw = this.editor.getModel().getNode().getChildNamed(DtoFieldConstants.OLD_STW);
            if (oldStw == null) {
                oldStw = new DTOProxyNode(defaultS.getValue());
                oldStw.setName(DtoFieldConstants.OLD_STW);
                this.editor.getModel().getNode().addChild(oldStw, 0L);
            }
            oldStw.setValue(defaultS.getValue(), 0L);
        }
        if (sNode == null) {
            defaultS.setValue(null, System.currentTimeMillis());
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl p1 = (TableRowImpl)p;
                p1.setChecked(false);
            }
        } else {
            if (this.isFlight) {
                StowingListLight ns = (StowingListLight)sNode.getValue();
                StowingToolkit.initClientIds((StowingListLight)ns);
                List paxTypes = (List)NodeToolkit.getAffixList(PaxFigureTypeComplete.class).getValue();
                Node paxes = this.editor.getModel().getNode().getChildNamed(FlightLight_.legs);
                Iterator it = paxes.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node leg = (Node)it.next();
                    Iterator it2 = leg.getChildNamed(FlightLegComplete_.paxFigures).getFailSafeChildIterator();
                    HashSet<CabinClassComplete> addedCC = new HashSet<CabinClassComplete>();
                    while (it2.hasNext()) {
                        Node figure = (Node)it2.next();
                        CabinClassComplete cc = (CabinClassComplete)figure.getChildNamed(SeatConfigurationComplete_.cabinClass).getValue();
                        boolean found = false;
                        if (ns != null) {
                            for (SeatConfigurationComplete sc : ns.getSeatConfigurations()) {
                                if (!sc.getCabinClass().equals((Object)cc)) continue;
                                found = true;
                            }
                        }
                        if (!found) {
                            leg.getChildNamed(FlightLegComplete_.paxFigures).removeChild(figure, 0L);
                            continue;
                        }
                        addedCC.add(cc);
                    }
                    if (ns == null) continue;
                    for (SeatConfigurationComplete sc : ns.getSeatConfigurations()) {
                        if (addedCC.contains(sc.getCabinClass())) continue;
                        for (PaxFigureTypeComplete px : paxTypes) {
                            PaxFigureComplete pf = new PaxFigureComplete();
                            pf.setClientOId(Long.valueOf(ADTO.getNextId()));
                            pf.setCabinClass(sc.getCabinClass());
                            pf.setLeg((FlightLegComplete)leg.getValue());
                            pf.setNumber(Integer.valueOf(0));
                            pf.setPaxFigureType(px);
                            Node pfn = INodeCreator.getDefaultImpl().getNode4DTO((Object)pf, true, false);
                            leg.getChildNamed(FlightLegComplete_.paxFigures).addChild(pfn, 0L);
                        }
                        PaxFigureComplete pf = new PaxFigureComplete();
                        pf.setClientOId(Long.valueOf(ADTO.getNextId()));
                        pf.setCabinClass(sc.getCabinClass());
                        pf.setLeg((FlightLegComplete)leg.getValue());
                        pf.setNumber(Integer.valueOf(0));
                        Node pfn = INodeCreator.getDefaultImpl().getNode4DTO((Object)pf, true, false);
                        leg.getChildNamed(FlightLegComplete_.paxFigures).addChild(pfn, 0L);
                    }
                }
            }
            defaultS.setValue(sNode.getValue(), System.currentTimeMillis());
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl p1 = (TableRowImpl)p;
                if (p1 == row) {
                    p1.setChecked(true);
                    continue;
                }
                p1.setChecked(false);
            }
        }
        this.setEnabled(this.isEnabled());
        this.editor.createFocusCycle();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean b = this.isEnabled();
        if (this.isFlight && this.node != null && this.node.getChildNamed(FlightLight_.flightState) != null && this.node.getChildNamed(FlightLight_.flightState).getValue() == FlightStateE.PLANNED) {
            b = false;
        }
        this.table.setEnabled(enabled);
        if (this.table.getFootablePanel() != null) {
            this.table.getFootablePanel().setEnabled(b);
        }
    }

    public DtoField getDefaultSTWName() {
        return this.fieldName;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    public Object getRequestedDTO() {
        return this.lastSelectedDTO;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.table.setVisibleContainer(pane);
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    public void setEditable(boolean isEditable) {
        this.table.setEditable(isEditable);
    }

    public void setButtonEnabled(boolean isEnabled) {
        this.table.enableAddButton(isEnabled);
    }

    private void ensureActiveStowingSelection() {
        if (this.isFlight) {
            Node n = this.node.getChildNamed(FlightLight_.activeStowingList);
            if (n != null) {
                for (Table2RowPanel r : this.table.getRows()) {
                    TableRowImpl i = (TableRowImpl)r;
                    if (r.getModel() == null) {
                        i.setChecked(false);
                        continue;
                    }
                    if (r.getModel().getNode() == null) {
                        i.setChecked(false);
                        continue;
                    }
                    if (r.getModel().getNode().getValue() == null) {
                        i.setChecked(false);
                        continue;
                    }
                    if (r.getModel().getNode().getValue() != null) {
                        if (r.getModel().getNode().getValue().equals(n.getValue())) {
                            i.setChecked(true);
                            continue;
                        }
                        i.setChecked(false);
                        continue;
                    }
                    i.setChecked(false);
                }
            }
            this.setEnabled(this.isEnabled());
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            StowingTable.this.table.setLocation(0, 0);
            StowingTable.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return StowingTable.this.table.getPreferredSize();
        }
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    RemoteLoader,
    SearchTextField2Listener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private RDRadioButton activeBox;
        private Component stowingSearch;
        private TextLabel stowing;
        private InfoButton info;
        private TextLabel aircraft;
        private DeleteButton delete;
        private boolean isSaveAndEnter;
        private ConfigButton mappingButton;
        private UpdateButton updateButton;
        private boolean configWasOpen;
        private RDTextField registration;
        private boolean isReloadableFromFlightSchedule;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isReloadableFromFlightSchedule = false;
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setLayout(new ElementLayout());
            if (StowingTable.this.isFlight) {
                this.updateButton = new UpdateButton();
                this.updateButton.addButtonListener(this);
                this.registration = new RDTextField(StowingTable.this.provider);
                this.registration.setNode(m.getNode().getChildNamed(StowingListLight_.matriculation));
            }
            this.activeBox = new RDRadioButton(StowingTable.this.table.getProvider());
            RDSearchTextField2.SearchTypes t = RDSearchTextField2.SearchTypes.STOWINGLIST_TEMPLATE;
            if (!StowingTable.this.isFlight) {
                if (m.getNode().getChildNamed(ADTO.ID_).getValue() == null && StowingTable.this.table != null) {
                    RDSearchTextField2 r;
                    this.stowingSearch = r = new RDSearchTextField2(StowingTable.this.table.getProvider(), t);
                    r.setOverrideName("stowingLists");
                    r.setNode(m.getNode().getChildNamed(StowingListConfigurationComplete_.stowingList));
                    r.addSearchTextFieldListener(this);
                } else {
                    this.stowing = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateComplete_.currentVariant}), ConverterRegistry.getConverter(StowingListNameConverter.class));
                    StowingListTemplateComplete data = (StowingListTemplateComplete)m.getNode().getChildNamed(StowingListConfigurationComplete_.stowingList).getValue();
                    if (Boolean.TRUE.equals(data.getIsDeleted()) && this.stowing != null) {
                        this.stowing.setInvalid();
                    }
                }
                this.aircraft = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateComplete_.currentVariant}), ConverterRegistry.getConverter(StowingListAircraftConverter.class));
            } else {
                this.stowingSearch = new TextLabel(m.getNode(), ConverterRegistry.getConverter(StowingListNameConverter.class));
                StowingListLight data = (StowingListLight)m.getNode().getValue();
                if (data != null && Boolean.TRUE.equals(data.getOriginDeleted())) {
                    Color invalidForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_error_string_color"));
                    this.stowingSearch.setForeground(invalidForeground);
                }
                Node childNamed = m.getNode() != null ? m.getNode().getChildNamed(StowingListLight_.updatable) : null;
                this.isReloadableFromFlightSchedule = childNamed != null ? (Boolean)childNamed.getValue() : false;
                this.aircraft = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StowingListLight_.aircraft, AircraftLight_.description}), ConverterRegistry.getConverter(StringConverter.class));
            }
            if (StowingTable.this.table.getModel().isDeletable()) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
            }
            this.info = new InfoButton(SizedSkin1Field.SkinSize.MEDIUM);
            this.info.addButtonListener(this);
            if (StowingTable.this.isFlight) {
                this.activeBox.setOverrideName("activeStowingList");
            } else {
                this.mappingButton = new ConfigButton();
                this.mappingButton.addButtonListener(this);
                this.add(this.mappingButton);
                this.activeBox.setOverrideName("defaultStowingList");
            }
            this.activeBox.addButtonListener(this);
            this.activeBox.setNode(null);
            this.add(this.activeBox);
            if (this.stowingSearch != null) {
                this.add(this.stowingSearch);
            }
            if (this.stowing != null) {
                this.add(this.stowing);
            }
            if (this.aircraft != null) {
                this.add(this.aircraft);
            }
            if (this.delete != null) {
                this.add(this.delete);
            }
            if (this.updateButton != null) {
                this.add(this.updateButton);
            }
            if (this.registration != null) {
                this.add(this.registration);
            }
            this.add(this.info);
            this.lafAttributeChanged("All attribues changed");
        }

        @Override
        public boolean wasInstallCalled() {
            return StowingTable.this.isFlight;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
            if (!StowingTable.this.isFlight) {
                if (this.model.getNode().getChildNamed(ADTO.ID_).getValue() == null && !this.configWasOpen) {
                    this.mappingButton.setInvalid();
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_LEG_MAPPING_FOR_STOWING));
                } else {
                    List targets1;
                    List sources = MappingTable2D.createList2(this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs}));
                    List targets = targets1 = MappingTable2D.createList2(StowingTable.this.node.getChildNamed(FlightLight_.legs));
                    Node saveNode = this.model.getNode().getChildNamed(StowingListConfigurationComplete_.legMapping);
                    saveNode.commitThis();
                    Map m = (Map)saveNode.getValue();
                    List b = LegToolkit.validateLegMapping((Map)m, sources, targets, (boolean)true);
                    if (b != null && !b.isEmpty()) {
                        a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_LEG_MAPPING_STW, (Object[])new Object[]{((RDSearchTextField2)this.stowingSearch).getPersistString()})));
                        this.mappingButton.setInvalid();
                    } else {
                        this.mappingButton.setValid();
                    }
                }
            }
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.stowingSearch != null && this.stowingSearch instanceof Focusable) {
                ((Focusable)((Object)this.stowingSearch)).requestFocusInWindowNow();
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.activeBox);
            if (this.stowingSearch instanceof Focusable) {
                CheckedListAdder.addToList(a, (Focusable)((Object)this.stowingSearch));
            }
            CheckedListAdder.addToList(a, this.info);
            CheckedListAdder.addToList(a, this.registration);
            CheckedListAdder.addToList(a, this.mappingButton);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public void allInstalled() {
            Node stowingL = this.model.getNode().getParent().getParent();
            Node defaultS = stowingL.getChildNamed(StowingTable.this.getDefaultSTWName());
            if (defaultS == null || defaultS.getValue() == null || defaultS.getValue() instanceof StowingListLight && ((StowingListLight)defaultS.getValue()).getId() == null) {
                StowingTable.this.setActivStowingList(this, this.model.getNode());
            } else if (defaultS.getValue() instanceof StowingListConfigurationComplete) {
                if (defaultS == null || defaultS.getValue() == null || ((StowingListConfigurationComplete)defaultS.getValue()).getId() == null) {
                    StowingTable.this.setActivStowingList(this, this.model.getNode());
                } else {
                    Node n = defaultS;
                    if (n.getValue() != null && ((StowingListConfigurationComplete)n.getValue()).getId() != null && ((StowingListConfigurationComplete)defaultS.getValue()).getId().equals(((ADTO)this.model.getNode().getValue()).getId())) {
                        this.setChecked(true);
                    }
                }
            } else {
                Node n = defaultS;
                if (n.getValue() != null && ((StowingListLight)n.getValue()).getId() != null && ((StowingListLight)defaultS.getValue()).getId().equals(((ADTO)this.model.getNode().getValue()).getId())) {
                    this.setChecked(true);
                }
            }
        }

        public void setChecked(boolean b) {
            if (this.activeBox != null) {
                this.activeBox.setChecked(b);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean isDraft = true;
            if (StowingTable.this.node != null && !StowingTable.this.isFlight) {
                isDraft = StowingTable.this.node.getChildNamed(FlightScheduleComplete_.state).getValue() != ModificationStateE.ACCEPTED;
            }
            boolean b = isDraft && isEnabled;
            boolean active = true;
            super.setEnabled(b);
            if (this.delete != null) {
                this.delete.setEnabled(b && StowingTable.this.hasStowingAccess);
            }
            boolean c = true;
            if (StowingTable.this.isFlight) {
                c = true;
                active = this.activeBox.isChecked();
            } else {
                c = StowingTable.this.provider.isWritable("defaultStowingList");
            }
            this.activeBox.setEnabled(b && c);
            this.aircraft.setEnabled(b);
            boolean d = true;
            if (this.stowingSearch != null && this.stowingSearch instanceof Nodable) {
                boolean bl = d = ((Nodable)((Object)this.stowingSearch)).getNode() != null && ((Nodable)((Object)this.stowingSearch)).getNode().getValue() != null;
            }
            if (this.info != null) {
                this.info.setEnabled(isEnabled && d);
            }
            boolean e = false;
            if (StowingTable.this.node != null && StowingTable.this.node.getParent() != null && StowingTable.this.isFlight && StowingTable.this.node.getValue() instanceof FlightLight) {
                boolean bl = e = ((FlightLight)StowingTable.this.node.getValue()).getFlightState() != FlightStateE.PLANNED;
            }
            if (this.stowingSearch != null) {
                this.stowingSearch.setEnabled(b);
            }
            if (this.stowing != null) {
                this.stowing.setEnabled(b);
            }
            if (this.mappingButton != null) {
                this.mappingButton.setEnabled(d && isEnabled);
            }
            if (this.updateButton != null) {
                this.updateButton.setEnabled(b && e && active);
            }
            if (this.registration != null) {
                this.registration.setEnabled(b && active);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.activeBox.kill();
            this.activeBox = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
            if (this.stowingSearch != null && this.stowing instanceof Killable) {
                ((Killable)((Object)this.stowingSearch)).kill();
            }
            this.stowingSearch = null;
            if (this.stowing != null) {
                this.stowing.kill();
            }
            this.stowing = null;
            if (this.mappingButton != null) {
                this.mappingButton.kill();
            }
            this.mappingButton = null;
            if (this.updateButton != null) {
                this.updateButton.kill();
            }
            this.updateButton = null;
            if (this.registration != null) {
                this.registration.kill();
            }
            this.registration = null;
            if (this.info != null) {
                this.info.kill();
            }
            this.info = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                if (StowingTable.this.isFlight && StowingTable.this.node.getChildNamed(FlightComplete_.stowingLists).getChildCount() == 1) {
                    InnerPopupFactory.showErrorDialog(Words.ENSURE_STOWING_LIST, (Component)source);
                    return;
                }
                if (this.activeBox.isChecked()) {
                    if (this.model.getNode().getParent().getChildCount() > 1) {
                        int i2 = StowingTable.this.table.getRowIndex(this);
                        if (i2 > 0) {
                            TableRowImpl p = (TableRowImpl)StowingTable.this.table.getRowAt(--i2);
                            StowingTable.this.setActivStowingList(p, p.getModel().getNode());
                        } else {
                            TableRowImpl p = (TableRowImpl)StowingTable.this.table.getRowAt(++i2);
                            if (p != null) {
                                StowingTable.this.setActivStowingList(p, p.getModel().getNode());
                            }
                        }
                    } else {
                        StowingTable.this.setActivStowingList(null, null);
                    }
                }
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
                if (StowingTable.this.editor != null) {
                    StowingTable.this.editor.validate();
                }
            } else if (source == this.activeBox.getEditor()) {
                if (StowingTable.this.isFlight) {
                    if (StowingTable.this.editor.getModel().getNode() != null && StowingTable.this.editor.getModel().getNode().getValue(FlightLight.class) != null) {
                        if (((FlightLight)StowingTable.this.editor.getModel().getNode().getValue(FlightLight.class)).getFlightState() != FlightStateE.PLANNED) {
                            Node defaultS = this.model.getNode();
                            if (defaultS.getValue().equals(StowingTable.this.editor.getModel().getNode().getChildNamed(FlightLight_.activeStowingList).getValue())) {
                                if (!((RadioButton)this.activeBox.getEditor()).isChecked()) {
                                    ((RadioButton)this.activeBox.getEditor()).setChecked(true);
                                }
                                return;
                            }
                            boolean sealCheck = true;
                            boolean spmlCheck = false;
                            boolean alaCarteCheck = false;
                            boolean additionalCheck = false;
                            if (StowingTable.this.editor.getModel().getNode().getChildNamed(FlightComplete_.spmlOrders).getChildCount() > 0) {
                                spmlCheck = true;
                            }
                            if (StowingTable.this.editor.getModel().getNode().getChildNamed(FlightComplete_.alaCarteOrders).getChildCount() > 0) {
                                alaCarteCheck = true;
                            }
                            if (StowingTable.this.editor.getModel().getNode().getChildNamed(FlightComplete_.additionalOrders).getChildCount() > 0) {
                                additionalCheck = true;
                            }
                            if (sealCheck || spmlCheck || alaCarteCheck || additionalCheck) {
                                String text = "<b>" + Words.SWITCH_CURRENT_STOWING_LIST + "</b><br/>";
                                text = text + "<ul>";
                                if (this.model.getNode().getChildNamed(ADTO.ID_).getValue() != null) {
                                    text = text + "<li>" + Words.DELETE_CURRENT_STW + "</li>";
                                }
                                if (sealCheck) {
                                    text = text + "<li>" + Words.SEAL_CONFIG_WILL_BE_RESETTED + "</li>";
                                }
                                if (spmlCheck) {
                                    text = text + "<li>" + Words.SPML_ORDERS_ARE_REMAPPED + "</li>";
                                }
                                if (additionalCheck) {
                                    text = text + "<li>" + Words.ADDITIONAL_ORDERS_ARE_REMAPPED + "</li>";
                                }
                                if (alaCarteCheck) {
                                    text = text + "<li>" + Words.ALACARTE_ORDERS_ARE_REMAPPED + "</li>";
                                }
                                text = text + "</ul>";
                                InnerPopupFactory.showDesicionPopup(Words.SWITCH_STOWING_LIST, text, source, new InnerPopUpListener2(){

                                    @Override
                                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                                        if (xargs != null) {
                                            if (TableRowImpl.this.activeBox.isChecked()) {
                                                Node defaultS = StowingTable.this.node.getChildNamed(StowingTable.this.getDefaultSTWName());
                                                if (!(TableRowImpl.this.model == null || TableRowImpl.this.model.getNode() == null || defaultS == null || TableRowImpl.this.model.getNode().getValue() != null && TableRowImpl.this.model.getNode().getValue().equals(defaultS.getValue()))) {
                                                    StowingTable.this.setActivStowingList(TableRowImpl.this, TableRowImpl.this.model.getNode());
                                                }
                                            } else {
                                                StowingTable.this.setActivStowingList(TableRowImpl.this, null);
                                            }
                                        } else {
                                            TableRowImpl.this.activeBox.setChecked(false);
                                        }
                                    }
                                }, 350, -1);
                            } else {
                                StowingTable.this.setActivStowingList(this, this.model.getNode());
                            }
                        } else if (this.activeBox.isChecked()) {
                            Node defaultS = StowingTable.this.node.getChildNamed(StowingTable.this.getDefaultSTWName());
                            if (!(this.model == null || this.model.getNode() == null || defaultS == null || this.model.getNode().getValue() != null && this.model.getNode().getValue().equals(defaultS.getValue()))) {
                                StowingTable.this.setActivStowingList(this, this.model.getNode());
                            }
                        } else {
                            StowingTable.this.setActivStowingList(this, null);
                        }
                    }
                } else if (this.activeBox.isChecked()) {
                    StowingTable.this.setActivStowingList(this, this.model.getNode());
                } else {
                    StowingTable.this.setActivStowingList(this, null);
                }
            } else if (source == this.mappingButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.DEFINE_STOWING_LEG_MAPPING);
                if (this.model.getNode().getChildNamed(StowingListConfigurationComplete_.stowingList) != null && this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs}) != null) {
                    this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs}).commit();
                    StowingTable.this.node.getChildNamed(StowingListTemplateVariantLight_.legs).commit();
                    List<Node<ALegComplete>> sources = MappingTable2D.createList(this.model.getNode().getChildNamed(new DtoField[]{StowingListConfigurationComplete_.stowingList, StowingListTemplateVariantLight_.legs}), null);
                    List<Node<ALegComplete>> targets = MappingTable2D.createList(StowingTable.this.node.getChildNamed(StowingListTemplateVariantLight_.legs), FlightScheduleLegComplete_.cateringLeg.getFieldName());
                    Node saveNode = this.model.getNode().getChildNamed(StowingListConfigurationComplete_.legMapping);
                    popUp.setView(new LegMappingPopupInsert(sources, targets, (Node<Map<ALegComplete, ALegComplete>>)saveNode, Words.LEG_FROM_STW, Words.IS_REPLACE_BY_NEW_FLIGHT_SCHEDULE, false));
                    popUp.showPopUp(x, y, 505, 200, null, source);
                    popUp.getView().setEnabled(this.isEnabled());
                    this.configWasOpen = true;
                }
            } else if (source == this.updateButton) {
                if (!this.isReloadableFromFlightSchedule) {
                    InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.STW_NO_LONGER_IN_FLIGHT_SCHEDULE)}), Words.UNABLE_TO_UPDATE_STOWING_FROM_FLIGHT_SCHEDULE, (Component)this);
                } else {
                    StowingTable.this.node.commit(FlightComplete.class);
                    FlightComplete oldFlight = (FlightComplete)StowingTable.this.node.getValue(FlightComplete.class);
                    if (!Boolean.TRUE.equals(oldFlight.getAllowStowingListReload())) {
                        InnerPopupFactory.showErrorDialog("Reload is not allowed for this flight. Change 'allowed stw reload' first.", "Reload Stw from Flight Schedule", (Component)this);
                        return;
                    }
                    InnerPopupFactory.showDesicionPopup(Words.RELOAD_STOWING_LIST, Words.STYLED_RELOAD_STW_FROM_FS_TEXT, this.updateButton, new InnerPopUpListener2(){

                        @Override
                        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                            if (xargs != null) {
                                if (StowingTable.this.editor != null) {
                                    StowingTable.this.editor.showCommittingAnimation(Words.SWITCH_STOWING_LIST);
                                    StowingTable.this.editor.setEnabled(false);
                                }
                                if (StowingTable.this.paxTable != null) {
                                    StowingTable.this.paxTable.setNode(null);
                                }
                                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                                    @Override
                                    public Node<?> loadData() throws Exception {
                                        StowingTable.this.node.commit(FlightComplete.class);
                                        FlightComplete oldFlight = (FlightComplete)StowingTable.this.node.getValue(FlightComplete.class);
                                        StowingListLight l = (StowingListLight)TableRowImpl.this.model.getNode().getValue();
                                        final ArrayList warnings = new ArrayList();
                                        Node rl = StowingToolkit.reloadStowingListFromFlightSchedule((FlightComplete)oldFlight, (StowingListLight)l, warnings, (boolean)false, (boolean)false);
                                        final FlightComplete of = oldFlight;
                                        if (!warnings.isEmpty()) {
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    DateTimeConverter con = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                                                    InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((List)warnings), Phrase.getPhrase((String)Phrase.REVIEW_FLIGHT, (Object[])new Object[]{of.getOutboundCode(), con.convert((Object)of.getStd(), null, new Object[0])}), (Component)StowingTable.this);
                                                }
                                            });
                                        }
                                        if (rl.getValue(FlightComplete.class) instanceof FlightComplete) {
                                            if (StowingTable.this.dataHandler != null) {
                                                StowingTable.this.dataHandler.newStwSetted(((FlightComplete)rl.getValue()).getActiveStowingList());
                                            }
                                            FlightModuleDataHandler.revalidateMasterData((FlightComplete)rl.getValue(), true, rl);
                                            FlightModuleDataHandler.loadSealConfiguration((FlightComplete)rl.getValue());
                                        }
                                        FlightComplete flight = (FlightComplete)rl.getValue(FlightComplete.class);
                                        StowingTable.this.node.removeExistingValues();
                                        StowingTable.this.node.setValue((Object)flight, 0L);
                                        StowingTable.this.node.updateNode();
                                        StowingTable.this.node.commit(FlightComplete.class);
                                        TableRowImpl.this.model.getNode().removeExistingValues();
                                        TableRowImpl.this.model.getNode().removeAllChilds();
                                        TableRowImpl.this.model.getNode().setValue((Object)flight.getActiveStowingList(), 0L);
                                        TableRowImpl.this.model.getNode().updateNode();
                                        return rl;
                                    }

                                    @Override
                                    public RemoteLoader getInvoker() {
                                        return new RemoteLoader(){

                                            public void remoteObjectLoaded(Node<?> node) {
                                                if (StowingTable.this.editor != null) {
                                                    if (node.getValue() != null) {
                                                        StowingTable.this.editor.setNode(node);
                                                    }
                                                    StowingTable.this.editor.hideCommittingAnimation();
                                                    StowingTable.this.editor.setEnabled(true);
                                                }
                                            }

                                            public void errorOccurred(ClientException exception) {
                                                if (StowingTable.this.editor != null) {
                                                    StowingTable.this.editor.hideCommittingAnimation();
                                                    StowingTable.this.editor.setEnabled(true);
                                                }
                                                InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_UPDATE_STOWING_FROM_FLIGHT_SCHEDULE, (Component)StowingTable.this);
                                            }
                                        };
                                    }

                                    @Override
                                    public long getID() {
                                        return 0L;
                                    }
                                };
                                ThreadSafeLoader.run(run);
                            }
                        }
                    }, -1, -1);
                }
            } else if (source == this.info) {
                if (StowingTable.this.isFlight) {
                    if (this.model.getNode().getValue() instanceof StowingListLight) {
                        Node sNode = this.model.getNode();
                        InnerPopupFactory.showStowingListInfoPopup(this.info, (IStowingListLight)sNode.getValue(), x, y);
                    } else {
                        Node sNode = this.model.getNode().getChildNamed(StowingListConfigurationComplete_.stowingList);
                        InnerPopupFactory.showStowingListInfoPopup(this.info, (IStowingListLight)((StowingListTemplateComplete)sNode.getValue()).getCurrentVariant(), x, y);
                    }
                } else {
                    Node sNode = this.model.getNode().getChildNamed(StowingListConfigurationComplete_.stowingList);
                    InnerPopupFactory.showStowingListInfoPopup(this.info, (IStowingListLight)((StowingListTemplateComplete)sNode.getValue()).getCurrentVariant(), x, y);
                }
            }
        }

        @Override
        public void remoteObjectLoaded(Node<?> node) {
            if (this.isSaveAndEnter) {
                if (StowingTable.this.editor != null) {
                    StowingTable.this.editor.getModel().remoteObjectLoaded(node);
                    StowingTable.this.editor.setInnerData((ADTO)StowingTable.this.lastSelectedDTO);
                    StowingTable.this.editor.showScreen();
                }
                this.setCursor(new Cursor(0));
                this.isSaveAndEnter = false;
                return;
            }
            if (StowingTable.this.editor != null) {
                StowingTable.this.editor.getModel().remoteObjectLoaded(node);
            }
        }

        @Override
        public void errorOccurred(ClientException exception) {
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) {
            if (StowingTable.this.isFlight) {
                StowingListTemplateComplete l = (StowingListTemplateComplete)n.getValue();
                this.model.getNode().removeExistingValues();
                this.model.getNode().setValue((Object)l, 0L);
                this.model.getNode().updateNode();
            }
            if (StowingTable.this.isFlight && this.stowing instanceof Nodable) {
                ((Nodable)((Object)this.stowingSearch)).setNode(this.model.getNode());
            }
            if (StowingTable.this.isFlight) {
                this.aircraft = new TextLabel(this.model.getNode(), ConverterRegistry.getConverter(StowingListAircraftConverter.class));
            }
            if (StowingTable.this.isFlight) {
                this.registration.setNode(this.model.getNode().getChildNamed(StowingListLight_.matriculation));
            }
            if (this.activeBox.isChecked()) {
                StowingTable.this.setActivStowingList(this, this.model.getNode());
            }
            this.setEnabled(this.isEnabled());
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        }

        private class ElementLayout
        extends DefaultLayout {
            private ElementLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int ix;
                int h = parent.getHeight();
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.activeBox.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.activeBox.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.activeBox.setSize(TableRowImpl.this.activeBox.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                int stwX = 0;
                if (TableRowImpl.this.stowingSearch != null) {
                    TableRowImpl.this.stowingSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stowingSearch.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.stowingSearch.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.info.getPreferredSize().getWidth())), (int)TableRowImpl.this.stowingSearch.getPreferredSize().getHeight());
                    stwX = TableRowImpl.this.stowingSearch.getX() + TableRowImpl.this.stowingSearch.getWidth() + TableRowImpl.this.getInnerCellPadding();
                }
                if (TableRowImpl.this.stowing != null) {
                    TableRowImpl.this.stowing.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stowing.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.stowing.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.info.getPreferredSize().getWidth())), (int)TableRowImpl.this.stowing.getPreferredSize().getHeight());
                    stwX = TableRowImpl.this.stowing.getX() + TableRowImpl.this.stowing.getWidth() + TableRowImpl.this.getInnerCellPadding();
                }
                TableRowImpl.this.info.setLocation(stwX, (int)(((double)parent.getHeight() - TableRowImpl.this.info.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.info.setSize(TableRowImpl.this.info.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.aircraft.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.aircraft.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.aircraft.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.aircraft.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                if (StowingTable.this.isFlight && TableRowImpl.this.registration != null) {
                    TableRowImpl.this.registration.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.registration.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.registration.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.registration.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                }
                TableRowImpl.this.setControlsX(currentX);
                boolean wasFirst = true;
                if (TableRowImpl.this.mappingButton != null) {
                    ix = TableRowImpl.this.getInnerCellPadding();
                    if (wasFirst) {
                        wasFirst = false;
                        ix = TableRowImpl.this.getCellPadding();
                    }
                    TableRowImpl.this.mappingButton.setLocation(currentX + ix, (int)(((double)parent.getHeight() - TableRowImpl.this.mappingButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.mappingButton.setSize(TableRowImpl.this.mappingButton.getPreferredSize());
                    currentX = TableRowImpl.this.mappingButton.getX() + TableRowImpl.this.mappingButton.getWidth();
                }
                if (TableRowImpl.this.updateButton != null) {
                    ix = TableRowImpl.this.getInnerCellPadding();
                    if (wasFirst) {
                        wasFirst = false;
                        ix = TableRowImpl.this.getCellPadding();
                    }
                    TableRowImpl.this.updateButton.setLocation(currentX + ix, (int)(((double)parent.getHeight() - TableRowImpl.this.updateButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.updateButton.setSize(TableRowImpl.this.updateButton.getPreferredSize());
                    currentX = TableRowImpl.this.updateButton.getX() + TableRowImpl.this.updateButton.getWidth();
                }
                if (TableRowImpl.this.delete != null) {
                    ix = TableRowImpl.this.getInnerCellPadding();
                    if (wasFirst) {
                        wasFirst = false;
                        ix = TableRowImpl.this.getCellPadding();
                    }
                    TableRowImpl.this.delete.setLocation((int)((double)parent.getWidth() - ((double)TableRowImpl.this.getCellPadding() + TableRowImpl.this.delete.getPreferredSize().getWidth())), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

