/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.incidentlog;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.IncidentDecisionEConverter;
import ch.icit.pegasus.client.converter.IncidentStateEConverter;
import ch.icit.pegasus.client.converter.IncidentTypeEConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.incidentlog.IncidentLogModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.incidentlog.details.DocAttachmentPanel;
import ch.icit.pegasus.client.gui.modules.incidentlog.details.FACDetailsPanel;
import ch.icit.pegasus.client.gui.modules.incidentlog.details.ImageAttachmentPanel;
import ch.icit.pegasus.client.gui.modules.incidentlog.details.NotificationPanel;
import ch.icit.pegasus.client.gui.modules.incidentlog.details.PRPDetailsPanel;
import ch.icit.pegasus.client.gui.modules.incidentlog.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.IncidentLogSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentDecisionE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogLight;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogLight_;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentStateE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.IncidentLogAccess;
import ch.icit.pegasus.server.core.dtos.search.IncidentLogSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class IncidentLogModule
extends ScreenTableView<IncidentLogLight, IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "name_number_filter";
    private static final String FILTER_PERIOD = "period_filter";
    private static final String FILTER_STATE = "state_filter";
    private static final String FILTER_DECISION = "decision_filter";
    private static final String FILTER_TYPE = "type_filter";
    private static final String FILTER_DEPARTMENT = "department_filter";
    private String searchFilter;
    private TitledPeriodEditor periodSearchFilter;
    private IncidentStateE stateFilter;
    private IncidentDecisionE decisionFilter;
    private IncidentTypeE typeFilter;
    private CostCenterComplete costCenterFilter;
    private ComboBox stateBox;
    private ComboBox decisionBox;
    private ComboBox typeBox;
    private ComboBox departmentBox;

    public IncidentLogModule() {
        super(IncidentLogLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public boolean isDeletable(RowModel<IncidentLogLight> model) {
        return false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return IncidentLogAccess.MODULE_INCIDENT_LOG;
    }

    public IncidentLogModuleDataHandler getDataHandler() {
        return (IncidentLogModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NAME, Words.NAME, "");
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        TitledPeriodEditor periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), Words.DATE, true);
        periodEditor.setCheckBoxEnabled();
        periodEditor.setCheckBoxChecked(false);
        periodEditor.setCommitOnFocusLost(true);
        this.stateBox = ComboBoxFactory.getIncidentState(true);
        this.decisionBox = ComboBoxFactory.getIncidentDecision(true);
        this.typeBox = ComboBoxFactory.getIncidentType(true);
        this.departmentBox = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.stateBox, 150, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addSelectionComboBox(this.decisionBox, 150, FILTER_DECISION, Words.DECISION, Words.ALL);
        this.filterChain.addSelectionComboBox(this.typeBox, 150, FILTER_TYPE, Words.TYPE, Words.ALL);
        this.filterChain.addSelectionComboBox(this.departmentBox, 150, FILTER_DEPARTMENT, Words.DEPARTMENT, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<IncidentLogLight, IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchFilter = "";
            this.stateFilter = null;
            this.periodSearchFilter = null;
            this.decisionFilter = null;
            this.typeFilter = null;
            this.costCenterFilter = null;
        } else if (name == FILTER_NAME) {
            this.searchFilter = (String)value;
        } else if (name == FILTER_PERIOD) {
            this.periodSearchFilter = (TitledPeriodEditor)value;
        } else if (name == FILTER_STATE) {
            this.stateFilter = value instanceof IncidentStateE ? (IncidentStateE)value : null;
        } else if (name == FILTER_DECISION) {
            this.decisionFilter = value instanceof IncidentDecisionE ? (IncidentDecisionE)value : null;
        } else if (name == FILTER_TYPE) {
            this.typeFilter = value instanceof IncidentTypeE ? (IncidentTypeE)value : null;
        } else if (name == FILTER_DEPARTMENT) {
            this.costCenterFilter = value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : (value instanceof InternalCostCenterComplete ? (InternalCostCenterComplete)value : null);
        }
        IncidentLogSearchConfiguration c = new IncidentLogSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        try {
            c.setNumber(Integer.valueOf(this.searchFilter));
        }
        catch (Exception e) {
            c.setName(this.searchFilter);
        }
        if (this.periodSearchFilter != null) {
            PeriodComplete p = new PeriodComplete(this.periodSearchFilter.getStartDate(), this.periodSearchFilter.getEndDate());
            c.setPeriod(p);
        }
        c.setState(this.stateFilter);
        c.setDecision(this.decisionFilter);
        c.setType(this.typeFilter);
        c.setDepartment(this.costCenterFilter);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public SearchAlgorithm<IncidentLogLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(IncidentLogSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.departmentBox.refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        this.departmentBox.addItem(Words.ALL);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<IncidentLogLight> model) {
        IncidentLogLight ab = (IncidentLogLight)model.getNode().getValue();
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<IncidentLogLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<IncidentLogLight> rowEditor = new MessageProvidedRowEditor<IncidentLogLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<IncidentLogLight>)rowEditor, p);
            FACDetailsPanel d2 = new FACDetailsPanel((RowEditor<IncidentLogLight>)rowEditor, p);
            PRPDetailsPanel d3 = new PRPDetailsPanel((RowEditor<IncidentLogLight>)rowEditor, p);
            ImageAttachmentPanel d4 = new ImageAttachmentPanel((RowEditor<IncidentLogLight>)rowEditor, p);
            DocAttachmentPanel d5 = new DocAttachmentPanel((RowEditor<IncidentLogLight>)rowEditor, p);
            NotificationPanel d6 = new NotificationPanel((RowEditor<IncidentLogLight>)rowEditor, p);
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
            rowEditor.add(d3, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
            rowEditor.add(d4, (Object)new TableLayoutConstraint(0, 3, 1.0, 0.0));
            rowEditor.add(d5, (Object)new TableLayoutConstraint(0, 4, 1.0, 0.0));
            rowEditor.add(d6, (Object)new TableLayoutConstraint(0, 5, 1.0, 0.0));
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new IncidentLogModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN.NUMBER, IncidentLogLight_.number, TableColumnInfo.numberColumnWithExpandWidth));
        info.add(new TableColumnInfo("FAC NO", "", (Class)StringConverter.class, null, IncidentLogLight_.incidentFACNumber, TableColumnInfo.numberColumnWidth));
        info.add(new TableColumnInfo(Words.TYPE, "", (Class)IncidentTypeEConverter.class, (Enum<?>)IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN.TYPE, IncidentLogLight_.type, TableColumnInfo.dateTimeColumnWidth));
        info.add(new TableColumnInfo(Words.INCIDENT_DATE, "", (Class)DateConverter.class, (Enum<?>)IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN.INCIDENT_DATE, IncidentLogLight_.incidentDate, TableColumnInfo.dateTimeColumnWidth));
        info.add(new TableColumnInfo(Words.STATE, "", (Class)IncidentStateEConverter.class, (Enum<?>)IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN.STATE, IncidentLogLight_.state, TableColumnInfo.dateColumnWidth));
        info.add(new TableColumnInfo(Words.DEPARTMENT, "", (Class)CostCenterConverter.class, (Enum<?>)IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN.DEPARTMENT, IncidentLogLight_.causingDepartment, TableColumnInfo.dateColumnWidth * 2));
        info.add(new TableColumnInfo(Words.DECISION, "", (Class)IncidentDecisionEConverter.class, (Enum<?>)IncidentLogSearchConfiguration.INCIDENT_LOG_COLUMN.DECISION, IncidentLogLight_.decision, TableColumnInfo.dateColumnWidth));
        info.add(new TableColumnInfo(Words.DESCRIPTION, "", StringConverter.class, null, IncidentLogLight_.incidentDescription, 0, Integer.MAX_VALUE, 0));
        return info;
    }
}

