/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory;

import ch.icit.pegasus.client.converter.DateAndTimeConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.inventory.InventoryModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.inventory.details.ActionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.AdditionalInfoDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.FlightsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.InventoryDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.ProductChargeCountDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.ProductCountDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.RecipeChargeCountDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.RecipeCountDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventory.details.StoreDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.InventoryManagerSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.InventoryStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryAccess;
import ch.icit.pegasus.server.core.dtos.search.InventorySearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class InventoryModule
extends ScreenTableView<InventoryLight, InventorySearchConfiguration.INVENTORY_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME_NO = "name_no";
    private static final String FILTER_STORE = "store";
    private static final String FILTER_PERIOD = "period";
    private static final String FILTER_STATE = "filter state";
    private String filterCriteria1 = null;
    private StoreLight filterCriteria2 = null;
    private TitledPeriodEditor filterCriteria3 = null;
    private TitledPeriodEditor periodChooser;
    private InventoryStateE filterCriteria4;

    public InventoryModule() {
        super(InventoryLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.filterCriteria3 != null) {
            this.filterCriteria3.kill();
        }
        if (this.periodChooser != null) {
            this.periodChooser.kill();
        }
        this.filterCriteria3 = null;
        this.periodChooser = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return InventoryAccess.MODULE_INVENTORY_MANAGER;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", InventorySearchConfiguration.INVENTORY_COLUMN.NO + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            this.filterChain.setResetButtonWidth(120);
        }
        this.filterChain.addSearchField(FILTER_NAME_NO, Words.NUMBER_OR_NAME, "");
        this.filterChain.addStoreSearchField(FILTER_STORE);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodChooser = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), Words.PERIOD, false);
        this.periodChooser.setCheckBoxEnabled();
        ComboBox stateCombo = ComboBoxFactory.getInventoryStateComboBox(true);
        this.filterChain.addSelectionComboBox(stateCombo, 100, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<InventoryLight, InventorySearchConfiguration.INVENTORY_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria3 = null;
            this.filterCriteria4 = null;
            this.periodChooser.setCheckBoxChecked(false);
        } else if (name == FILTER_NAME_NO) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_STORE) {
            this.filterCriteria2 = value instanceof StoreLight ? (StoreLight)value : null;
        } else if (name == FILTER_PERIOD) {
            TitledPeriodEditor p;
            this.filterCriteria3 = p = (TitledPeriodEditor)value;
        } else if (name == FILTER_STATE) {
            this.filterCriteria4 = value instanceof InventoryStateE ? (InventoryStateE)value : null;
        }
        InventorySearchConfiguration c = new InventorySearchConfiguration();
        c.setStore(this.filterCriteria2);
        c.setState(this.filterCriteria4);
        if (this.filterCriteria3 != null) {
            c.setPeriod(new PeriodComplete(this.filterCriteria3.getStartDate(), this.filterCriteria3.getEndDate()));
        }
        try {
            int a = Integer.valueOf(this.filterCriteria1);
            c.setNumber(Integer.valueOf(a));
            c.setName(this.filterCriteria1);
        }
        catch (NumberFormatException e) {
            c.setName(this.filterCriteria1);
            c.setNumber(null);
        }
        c.setNumResults(this.numberOfShownResults);
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<InventoryLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(InventoryManagerSearchAlgorithm.class);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<InventoryLight> model) {
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<InventoryLight> model) {
        return super.isDeletable(model) && model.getDTO(InventoryLight.class).getState() != InventoryStateE.APPROVED;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<InventoryLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<InventoryLight> rowEditor = new MessageProvidedRowEditor<InventoryLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            if (model.isAddRow()) {
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                SpecificationDetailsPanel s1 = new SpecificationDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                StoreDetailsPanel s2 = new StoreDetailsPanel((RowEditor<InventoryLight>)rowEditor, p, true);
                c1.add((Component)s1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                c1.add((Component)s2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                AdditionalInfoDetailsPanel s3 = new AdditionalInfoDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(s3, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.addToFocusQueue(s1);
                rowEditor.addToFocusQueue(s2);
                rowEditor.addToFocusQueue(s3);
            } else {
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                StoreDetailsPanel s2 = new StoreDetailsPanel((RowEditor<InventoryLight>)rowEditor, p, false);
                ActionDetailsPanel s1 = new ActionDetailsPanel(rowEditor, p, (UserReference)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), s2);
                c1.add((Component)s1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                c1.add((Component)s2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                InventoryDataDetailsPanel s3 = new InventoryDataDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                CombinedDetailsParagraph c2 = new CombinedDetailsParagraph();
                SpecificationDetailsPanel s4 = new SpecificationDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                AdditionalInfoDetailsPanel s5 = new AdditionalInfoDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                c2.add((Component)s4, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                c2.add((Component)s5, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(c2, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.add(s3, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                int index = 3;
                RecipeCountDetailsPanel r1 = null;
                if (Boolean.TRUE.equals(settings.getInventoryRecipeCountActive())) {
                    r1 = new RecipeCountDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                    rowEditor.add(r1, (Object)new TableLayoutConstraint(0, index++, 1.0, 0.0));
                }
                ProductCountDetailsPanel p1 = null;
                if (Boolean.TRUE.equals(settings.getInventoryProductCountActive())) {
                    p1 = new ProductCountDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                    rowEditor.add(p1, (Object)new TableLayoutConstraint(0, index++, 1.0, 0.0));
                }
                WeeklyPlanSettingsComplete productionSettings = (WeeklyPlanSettingsComplete)NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class).getValue();
                FlightsDetailsPanel flights = null;
                if (Boolean.TRUE.equals(productionSettings.getUseProductionCharges())) {
                    ProductChargeCountDetailsPanel pd1 = new ProductChargeCountDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                    RecipeChargeCountDetailsPanel pd2 = new RecipeChargeCountDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                    rowEditor.add(pd1, (Object)new TableLayoutConstraint(0, index++, 1.0, 0.0));
                    rowEditor.add(pd2, (Object)new TableLayoutConstraint(0, index++, 1.0, 0.0));
                }
                if (Boolean.TRUE.equals(settings.getInventoryFlightActive())) {
                    flights = new FlightsDetailsPanel((RowEditor<InventoryLight>)rowEditor, p);
                    rowEditor.add(flights, (Object)new TableLayoutConstraint(0, index++, 1.0, 0.0));
                }
                rowEditor.addToFocusQueue(s1);
                rowEditor.addToFocusQueue(s2);
                rowEditor.addToFocusQueue(s3);
                rowEditor.addToFocusQueue(s4);
                rowEditor.addToFocusQueue(s5);
                if (r1 != null) {
                    rowEditor.addToFocusQueue(r1);
                }
                if (p1 != null) {
                    rowEditor.addToFocusQueue(p1);
                }
                if (flights != null) {
                    rowEditor.addToFocusQueue(flights);
                }
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new InventoryModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)InventorySearchConfiguration.INVENTORY_COLUMN.NO, InventoryLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        if (Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType())) {
            columns.add(new TableColumnInfo(Words.STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)InventorySearchConfiguration.INVENTORY_COLUMN.STATE, InventoryLight_.state, 65, 65, 65));
        } else {
            columns.add(new TableColumnInfo(Words.STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)InventorySearchConfiguration.INVENTORY_COLUMN.STATE, InventoryLight_.state, 55, 55, 55));
        }
        columns.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)InventorySearchConfiguration.INVENTORY_COLUMN.NAME, InventoryLight_.name, 35, Integer.MAX_VALUE, 55));
        int tw = TableColumnInfo.dateTimeColumnWidth + 35;
        columns.add(new TableColumnInfo(Words.DATE, "", (Class)DateAndTimeConverter.class, (Enum<?>)InventorySearchConfiguration.INVENTORY_COLUMN.INVENTORY_DATE, "inventoryDate-inventoryTime", tw, tw, tw));
        return columns;
    }
}

