/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details.utils;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.charges.ProductChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class InventoryProductCountedAmountChangingPopup
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final Node<ProductChargeLight> productCharge;
    private final Node<StoreQuantityComplete> oldAmountNode;
    private final Node<StoreQuantityComplete> newAmountNode;
    private TitledItem<QuantityRenderer> oldAmount;
    private TitledItem<InputComboBox2> newAmount;
    private TitledItem<CheckBox> changeStock;
    private Node productNode;
    private LoadingAnimation animation;
    private StoreLight store;
    private boolean isAnimating = false;

    public InventoryProductCountedAmountChangingPopup(Node<ProductChargeLight> productCharge, Node<StoreQuantityComplete> newAmount, Node<StoreQuantityComplete> oldAmount, Node<Boolean> changeStock, Node<ProductComplete> productNode) {
        this.productCharge = productCharge;
        this.productNode = productNode;
        this.oldAmountNode = oldAmount;
        this.newAmountNode = newAmount;
        this.oldAmount = new TitledItem<QuantityRenderer>(new QuantityRenderer(oldAmount), Words.OLD_COUNTED_AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.newAmount = new TitledItem<InputComboBox2>(new InputComboBox2(newAmount.getChildNamed(StoreQuantityComplete_.amount), newAmount.getChildNamed(StoreQuantityComplete_.unit), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG), Words.NEW_COUNTED_AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        changeStock.setValue((Object)true, 0L);
        this.changeStock = new TitledItem<CheckBox>(new CheckBox(changeStock), Words.CHANGE_ACTUAL_STOCK, TitledItem.TitledItemOrientation.EAST);
        this.setLayout(new Layout());
        this.add(this.oldAmount);
        this.add(this.newAmount);
        this.add(this.changeStock);
        this.remoteObjectLoaded(this.productNode);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.oldAmount.setEnabled(isEnabled);
        this.newAmount.setEnabled(isEnabled);
        this.changeStock.setEnabled(false);
    }

    private void killAnimation() {
        this.isAnimating = false;
        if (this.animation != null) {
            this.animation.kill();
        }
        this.animation = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.newAmount.getFocusComponents();
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[1];
        this.newAmount.getElement().getValueNode().commit();
        this.newAmount.getElement().getUnitNode().commit();
        o[0] = this.newAmount.getElement().getValueNode();
        return o;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.oldAmount.kill();
        this.newAmount.kill();
        this.changeStock.kill();
        this.oldAmount = null;
        this.newAmount = null;
        this.changeStock = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.killAnimation();
        if (this.newAmount != null && this.newAmount.getElement() != null) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            List units = UnitConversionToolkit.getAllUnits((UnitComplete)settings.getPieceUnit());
            this.newAmount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
            if (units.isEmpty()) {
                this.newAmount.getElement().clearSelectedUnit();
            } else if (units.contains(((StoreQuantityComplete)this.newAmountNode.getValue()).getUnit())) {
                this.newAmount.getElement().setSelectedUnit(((StoreQuantityComplete)this.newAmountNode.getValue()).getUnit());
            } else {
                this.newAmount.getElement().setSelectedUnit((UnitComplete)units.get(0));
            }
        }
        this.setEnabled(this.isEnabled());
        this.invalidate();
        this.validate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (InventoryProductCountedAmountChangingPopup.this.isAnimating) {
                InventoryProductCountedAmountChangingPopup.this.animation.setLocation((int)((double)parent.getWidth() - InventoryProductCountedAmountChangingPopup.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - InventoryProductCountedAmountChangingPopup.this.animation.getPreferredSize().getHeight()) / 2);
                InventoryProductCountedAmountChangingPopup.this.animation.setSize(InventoryProductCountedAmountChangingPopup.this.animation.getPreferredSize());
            } else {
                InventoryProductCountedAmountChangingPopup.this.oldAmount.setLocation(0, 0);
                InventoryProductCountedAmountChangingPopup.this.oldAmount.setSize((int)InventoryProductCountedAmountChangingPopup.this.oldAmount.getPreferredSize().getWidth(), (int)InventoryProductCountedAmountChangingPopup.this.oldAmount.getPreferredSize().getHeight());
                InventoryProductCountedAmountChangingPopup.this.newAmount.setLocation(0, InventoryProductCountedAmountChangingPopup.this.oldAmount.getY() + InventoryProductCountedAmountChangingPopup.this.oldAmount.getHeight() + 10);
                InventoryProductCountedAmountChangingPopup.this.newAmount.setSize((int)InventoryProductCountedAmountChangingPopup.this.newAmount.getPreferredSize().getWidth(), (int)InventoryProductCountedAmountChangingPopup.this.newAmount.getPreferredSize().getHeight());
                InventoryProductCountedAmountChangingPopup.this.changeStock.setLocation(0, InventoryProductCountedAmountChangingPopup.this.newAmount.getY() + InventoryProductCountedAmountChangingPopup.this.newAmount.getHeight() + 10);
                InventoryProductCountedAmountChangingPopup.this.changeStock.setSize(InventoryProductCountedAmountChangingPopup.this.changeStock.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)InventoryProductCountedAmountChangingPopup.this.oldAmount.getPreferredSize().getHeight();
            h += 10;
            h = (int)((double)h + InventoryProductCountedAmountChangingPopup.this.newAmount.getPreferredSize().getHeight());
            h += 10;
            h = (int)((double)h + InventoryProductCountedAmountChangingPopup.this.changeStock.getPreferredSize().getHeight());
            return new Dimension(0, h += 10);
        }
    }
}

