/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import java.util.Collections;

public class InvoiceToolkit {
    public static String getLegPaxCount(FlightLight flight) {
        String t = "";
        Collections.sort(flight.getLegs());
        for (FlightLegComplete l : flight.getLegs()) {
            t = t + "Leg " + (l.getNumber() + 1) + ": ";
            String r = "";
            Collections.sort(l.getPaxFigures());
            for (PaxFigureComplete pf : l.getPaxFigures()) {
                r = r + pf.getCabinClass().getCode() + "=" + pf.getNumber() + ", ";
            }
            if (r.length() > 2) {
                r = r.substring(0, r.length() - 2);
            }
            t = t + r + " / ";
        }
        if (t.length() > 3) {
            t = t.substring(0, t.length() - 3);
        }
        return t;
    }

    public static String getCancelMessage(FlightLight value, SystemSettingsComplete settings) {
        String t;
        if (value == null) {
            return "";
        }
        boolean rtc = CompanyUtil.isRTC((SystemSettingsComplete)settings);
        String string = t = rtc ? "<b>Retail was " : "<b>Flight was ";
        if (value.getFlightState() != FlightStateE.CANCELLED) {
            t = t + "not ";
        }
        t = t + "canceled</b>";
        if (value.getFlightState() == FlightStateE.CANCELLED) {
            t = t + "<br/>Cancel Info<ul>";
            UserConverter c = (UserConverter)ConverterRegistry.getConverter(UserConverter.class);
            DateTimeConverter c1 = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
            t = t + "<li>User: " + c.convert((UserReference)value.getCancelUser(), null, new Object[0]) + "</li>";
            t = t + "<li>Timestamp: " + c1.convert((Object)value.getCancelTime(), null, new Object[0]);
            t = t + "<li>Remark: " + value.getCancelRemark() + "</li>";
            t = t + "</ul><br/>Invoice Info<ul>";
            if (rtc) {
                t = t + "<li>Products: " + (Boolean.TRUE.equals(value.getPredefineInvoiceCanceledFlightAdditional()) ? "yes" : "no") + "</li>";
            } else {
                t = t + "<li>Meals: " + (Boolean.TRUE.equals(value.getPredefineInvoiceCanceledFlightMeal()) ? "yes" : "no") + "</li>";
                t = t + "<li>Standards: " + (Boolean.TRUE.equals(value.getPredefineInvoiceCanceledFlightStandard()) ? "yes" : "no") + "</li>";
                t = t + "<li>Additionals: " + (Boolean.TRUE.equals(value.getPredefineInvoiceCanceledFlightAdditional()) ? "yes" : "no") + "</li>";
                t = t + "<li>Handlings: " + (Boolean.TRUE.equals(value.getPredefineInvoiceCanceledFlightHandling()) ? "yes" : "no") + "</li>";
                t = t + "<li>Handlings from Stowing List: " + (Boolean.TRUE.equals(value.getPredefineInvoiceCanceledFlightHandlingFromStowing()) ? "yes" : "no") + "</li>";
            }
            t = t + "</ul>";
        }
        return t;
    }

    public static String createInvoiceNumberConfigInfoText() {
        String t = "<b>Define the Naming Format for Invoice Number</b><br/>";
        t = t + "<ul>";
        t = t + "<li>{No} = Invoice Number or ???</li>";
        t = t + "<li>{Date} = Invoice Date</li>";
        t = t + "<li>{Loc} = Invoice Location</li>";
        t = t + "</ul>";
        t = t + "Arrange this Code Words to define the format of a Invoice Number on Invoice...<br/><br/>";
        t = t + "Example: {No}-{Date} {Loc}<br/>";
        t = t + "= 125-23.01.2013 ZRH";
        return t;
    }
}

