/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CabinClassConfig
extends MasterDataInsert<CabinClassComplete> {
    private static final long serialVersionUID = 1L;

    public CabinClassConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new CabinClassConfigPanel();
    }

    @Override
    public String getInsertName() {
        return Words.CABIN_CLASSES;
    }

    @Override
    public CabinClassComplete getNewObject() {
        CabinClassComplete a = new CabinClassComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends CabinClassComplete> getMasterDataClass() {
        return CabinClassComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(CabinClassComplete_.sequenceNumber).getValue() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_SEQUENCE_NUMBER_IS_SET, (Object[])new Object[]{n.getChildNamed(CabinClassComplete_.code).getValue()})));
            }
            if (n.getChildNamed(CabinClassComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(CabinClassComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_CODE_IS_UNIQUE, (Object[])new Object[]{n.getChildNamed(CabinClassComplete_.code).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(CabinClassComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_CODES_ARE_SET));
        }
        return a;
    }

    private class CabinClassConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<CheckBox> crewClass;
        private TitledItem<CheckBox> showSeparatelyOnReports;
        private TitledItem<TextField> sequenceNumber;
        private TitledItem<TextField> dailyOpsPaxColumn;
        private TitledItem<TextField> paxGroup;

        public CabinClassConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.crewClass = new TitledItem<CheckBox>(new CheckBox(), Words.CREW_CLASS, TitledItem.TitledItemOrientation.EAST);
            this.showSeparatelyOnReports = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_SEPARATELY_ON_REPORTS, TitledItem.TitledItemOrientation.EAST);
            this.sequenceNumber = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.SEQUENCE_NUMBER, TitledItem.TitledItemOrientation.NORTH);
            this.dailyOpsPaxColumn = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.DAILY_OPS_PAX_COLUMN, TitledItem.TitledItemOrientation.NORTH);
            this.paxGroup = new TitledItem<TextField>(new TextField(), Words.PAX_GROUP, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.crewClass);
            this.add(this.showSeparatelyOnReports);
            this.add(this.sequenceNumber);
            this.add(this.dailyOpsPaxColumn);
            this.add(this.paxGroup);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.code);
            CheckedListAdder.addToList(focusList, this.description);
            CheckedListAdder.addToList(focusList, this.crewClass);
            CheckedListAdder.addToList(focusList, this.showSeparatelyOnReports);
            CheckedListAdder.addToList(focusList, this.sequenceNumber);
            CheckedListAdder.addToList(focusList, this.dailyOpsPaxColumn);
            CheckedListAdder.addToList(focusList, this.paxGroup);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.crewClass.setVisibleContainer(pane);
            this.showSeparatelyOnReports.setVisibleContainer(pane);
            this.sequenceNumber.setVisibleContainer(pane);
            this.dailyOpsPaxColumn.setVisibleContainer(pane);
            this.paxGroup.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.crewClass.kill();
            this.sequenceNumber.kill();
            this.dailyOpsPaxColumn.kill();
            this.showSeparatelyOnReports.kill();
            this.paxGroup.kill();
            this.paxGroup = null;
            this.code = null;
            this.description = null;
            this.crewClass = null;
            this.sequenceNumber = null;
            this.dailyOpsPaxColumn = null;
            this.showSeparatelyOnReports = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.paxGroup.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.crewClass.setEnabled(b);
            this.sequenceNumber.setEnabled(b);
            this.dailyOpsPaxColumn.setEnabled(b);
            this.showSeparatelyOnReports.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(CabinClassComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(CabinClassComplete_.description));
            this.crewClass.getElement().setNode(node.getChildNamed(CabinClassComplete_.crewClass));
            this.sequenceNumber.getElement().setNode(node.getChildNamed(CabinClassComplete_.sequenceNumber));
            this.dailyOpsPaxColumn.getElement().setNode(node.getChildNamed(CabinClassComplete_.dailyOpsPaxColumn));
            this.showSeparatelyOnReports.getElement().setNode(node.getChildNamed(CabinClassComplete_.showSeparatelyOnReports));
            this.paxGroup.getElement().setNode(node.getChildNamed(CabinClassComplete_.paxGroup));
            this.setEnabled(true);
            CabinClassConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return CabinClassComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                CabinClassConfigPanel.this.code.setLocation(CabinClassConfig.this.masterDataTable.getCellPadding(), CabinClassConfig.this.masterDataTable.getCellPadding());
                CabinClassConfigPanel.this.code.setSize(200, (int)CabinClassConfigPanel.this.code.getPreferredSize().getHeight());
                CabinClassConfigPanel.this.description.setLocation(CabinClassConfig.this.masterDataTable.getCellPadding(), CabinClassConfigPanel.this.code.getY() + CabinClassConfigPanel.this.code.getHeight() + CabinClassConfig.this.masterDataTable.getCellPadding());
                CabinClassConfigPanel.this.description.setSize(200, (int)CabinClassConfigPanel.this.description.getPreferredSize().getHeight());
                CabinClassConfigPanel.this.crewClass.setLocation(CabinClassConfig.this.masterDataTable.getCellPadding(), CabinClassConfigPanel.this.description.getY() + CabinClassConfigPanel.this.description.getHeight() + CabinClassConfig.this.masterDataTable.getCellPadding());
                CabinClassConfigPanel.this.crewClass.setSize(CabinClassConfigPanel.this.crewClass.getPreferredSize());
                CabinClassConfigPanel.this.showSeparatelyOnReports.setLocation(CabinClassConfig.this.masterDataTable.getCellPadding(), CabinClassConfigPanel.this.crewClass.getY() + CabinClassConfigPanel.this.crewClass.getHeight() + CabinClassConfig.this.masterDataTable.getCellPadding());
                CabinClassConfigPanel.this.showSeparatelyOnReports.setSize(CabinClassConfigPanel.this.showSeparatelyOnReports.getPreferredSize());
                CabinClassConfigPanel.this.sequenceNumber.setLocation(CabinClassConfig.this.masterDataTable.getCellPadding(), CabinClassConfigPanel.this.showSeparatelyOnReports.getY() + CabinClassConfigPanel.this.showSeparatelyOnReports.getHeight() + CabinClassConfig.this.masterDataTable.getCellPadding());
                CabinClassConfigPanel.this.sequenceNumber.setSize(CabinClassConfigPanel.this.sequenceNumber.getPreferredSize());
                CabinClassConfigPanel.this.dailyOpsPaxColumn.setLocation(CabinClassConfig.this.masterDataTable.getCellPadding(), CabinClassConfigPanel.this.sequenceNumber.getY() + CabinClassConfigPanel.this.sequenceNumber.getHeight() + CabinClassConfig.this.masterDataTable.getCellPadding());
                CabinClassConfigPanel.this.dailyOpsPaxColumn.setSize(CabinClassConfigPanel.this.dailyOpsPaxColumn.getPreferredSize());
                CabinClassConfigPanel.this.paxGroup.setLocation(CabinClassConfig.this.masterDataTable.getCellPadding(), CabinClassConfigPanel.this.dailyOpsPaxColumn.getY() + CabinClassConfigPanel.this.dailyOpsPaxColumn.getHeight() + CabinClassConfig.this.masterDataTable.getCellPadding());
                CabinClassConfigPanel.this.paxGroup.setSize(CabinClassConfigPanel.this.paxGroup.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

