/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.utils.panels.BackgroundedContainer;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.util.List;

public abstract class DefaultDataInsert
extends BackgroundedContainer
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    protected LoadingAnimation animation;
    protected LoadingState currentState;
    protected AbstractDataInsertModule editPanel;
    protected boolean isInserted = false;

    public DefaultDataInsert(AbstractDataInsertModule parent) {
        this.editPanel = parent;
    }

    public abstract Node getNode();

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.editPanel != null) {
            this.editPanel.setSelectionEnabled(isEnabled);
        }
    }

    public void changeLoadingState(String t) {
        if (this.animation != null) {
            this.animation.stateChanged(t);
        }
    }

    public abstract List<ScreenValidationObject> validateInsert();

    public void saveIt() {
        this.currentState = LoadingState.SAVE;
        this.startAnimation(Words.SAVE_DATA);
    }

    public void loadData() {
        this.currentState = LoadingState.LOAD;
        this.startAnimation(Words.LOAD_DATA);
    }

    protected void updateNode(Node n, ADTO dto) {
        if (dto != null) {
            n.removeExistingValues();
            n.setValue((Object)dto, 0L);
            n.updateNode();
        }
    }

    public void startAnimation(String t) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.add((Component)this.animation, 0);
        }
        this.animation.stateChanged(t);
        this.animation.fadeIn();
        this.animation.start();
        this.revalidate();
    }

    public void changeAnimationState(String text) {
        if (this.animation != null) {
            this.animation.stateChanged(text);
        }
    }

    public void stopAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation.stop();
        }
        this.animation = null;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.stopAnimation();
        if (!this.isInserted) {
            this.insertElements();
            this.isInserted = true;
        }
        if (this.getParent() == null) {
            return;
        }
        this.getParent().setEnabled(true);
        if (this.editPanel != null) {
            this.editPanel.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 7735);
        }
        if (this.editPanel != null) {
            this.editPanel.dataSaved();
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.stopAnimation();
        this.setEnabled(true);
        if (this.getParent() == null) {
            this.getParent().setEnabled(true);
        }
        if (this.editPanel != null) {
            this.editPanel.dataSaved();
        }
        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)this);
    }

    public abstract void insertElements();

    public void layoutAnimation(Container parent) {
        if (this.animation != null) {
            this.animation.setLocation((int)(((double)parent.getWidth() - this.animation.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - this.animation.getPreferredSize().getHeight()) / 2.0));
            this.animation.setSize(this.animation.getPreferredSize());
        }
    }

    public abstract String getInsertName();

    protected static enum LoadingState {
        LOAD,
        SAVE;

    }
}

