/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.migros;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.exchange.migros.MigrosExchangeServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosArticleImportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosArticleImportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosDataComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosDataTypeE;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosInvoiceAvisImportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosInvoiceExportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosOrderAvisExportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosOrderImportReference;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosStoreImportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosStoreImportReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class MigrosTransferModuleDataHandler
extends DefaultDataHandler<MigrosDataComplete, MigrosDataComplete> {
    public MigrosTransferModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<MigrosDataComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<MigrosDataComplete> createEmptyNode() {
        MigrosArticleImportComplete articleImportComplete = new MigrosArticleImportComplete();
        articleImportComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
        articleImportComplete.setValidityDate(new Date(System.currentTimeMillis()));
        articleImportComplete.setValidity(Boolean.valueOf(false));
        articleImportComplete.setProcessed(Boolean.valueOf(false));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)articleImportComplete, false, false);
    }

    @Override
    public void createNewData(final Node<MigrosDataComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        this.showMessage(l, Words.CREATE_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MigrosDataComplete migrosData = (MigrosDataComplete)node.getValue(MigrosDataComplete.class);
                if (migrosData instanceof MigrosArticleImportComplete) {
                    node.commit(MigrosArticleImportComplete.class);
                    MigrosArticleImportComplete articleImport = (MigrosArticleImportComplete)node.getValue(MigrosArticleImportComplete.class);
                    articleImport = (MigrosArticleImportComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).createArticleImport(articleImport).getValue();
                    node.removeExistingValues();
                    node.setValue((Object)articleImport, 0L);
                    node.updateNode();
                } else if (migrosData instanceof MigrosStoreImportComplete) {
                    node.commit(MigrosStoreImportComplete.class);
                    MigrosStoreImportComplete storeImport = (MigrosStoreImportComplete)node.getValue(MigrosStoreImportComplete.class);
                    storeImport = (MigrosStoreImportComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).createStoreImport(storeImport).getValue();
                    node.removeExistingValues();
                    node.setValue((Object)storeImport, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return MigrosTransferModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MigrosDataComplete complete = (MigrosDataComplete)node.getValue(MigrosDataComplete.class);
                if (complete.getDataType() == MigrosDataTypeE.Order) {
                    complete = (MigrosDataComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getOrder(new MigrosOrderImportReference(complete.getId())).getValue();
                }
                if (complete.getDataType() == MigrosDataTypeE.OrderAvis) {
                    complete = (MigrosDataComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getOrderAvis(new MigrosOrderAvisExportReference(complete.getId())).getValue();
                }
                if (complete.getDataType() == MigrosDataTypeE.Invoice) {
                    complete = (MigrosDataComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getInvoice(new MigrosInvoiceExportReference(complete.getId())).getValue();
                }
                if (complete.getDataType() == MigrosDataTypeE.InvoiceAvis) {
                    complete = (MigrosDataComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getInvoiceAvis(new MigrosInvoiceAvisImportReference(complete.getId())).getValue();
                }
                if (complete.getDataType() == MigrosDataTypeE.ArticleData) {
                    complete = (MigrosDataComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getArticleImport(new MigrosArticleImportReference(complete.getId())).getValue();
                }
                if (complete.getDataType() == MigrosDataTypeE.Store) {
                    complete = (MigrosDataComplete)((MigrosExchangeServiceManager)ServiceManagerRegistry.getService(MigrosExchangeServiceManager.class)).getStoreImport(new MigrosStoreImportReference(complete.getId())).getValue();
                }
                node.removeExistingValues();
                node.setValue((Object)complete, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<MigrosDataComplete> resetData(Node<MigrosDataComplete> node) {
        return null;
    }

    @Override
    public Class<MigrosDataComplete> getCommittingClass() {
        return MigrosDataComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<MigrosDataComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

