/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.productcatalog;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.ProductCatalogTypeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.productcatalog.ProductCatalogModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.ProductsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.SettingsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.SettingsDetailsPanel2;
import ch.icit.pegasus.client.gui.modules.productcatalog.details.TemplateDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ProductCatalogSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.dtos.search.ProductCatalogSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ProductCatalogModule
extends ScreenTableView<ProductCatalogLight, ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "name_filter";
    private static final String FILTER_CUSTOMER = "customer_filter";
    private static final String FILTER_PERIOD = "period";
    private static final String FILTER_TYPE = "typeFilter";
    private static final String FILTER_STATE = "state";
    private String searchCriteria1 = null;
    private CustomerLight searchCriteria2 = null;
    private TitledPeriodEditor searchCriteria3 = null;
    private TitledPeriodEditor periodEditor;
    private ProductCatalogTypeE searchCriteria4 = null;
    private ModificationStateE searchCriteria5 = null;
    private ComboBox typeCombo;
    private ComboBox stateCombo;

    public ProductCatalogModule() {
        super(ProductCatalogLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.periodEditor.kill();
        if (this.searchCriteria3 != null) {
            this.searchCriteria3.kill();
        }
        this.typeCombo.kill();
        this.stateCombo.kill();
        this.periodEditor = null;
        this.searchCriteria3 = null;
        this.typeCombo = null;
        this.stateCombo = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return ProductCatalogAccess.MODULE_PRODUCT_CATALOG;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NAME, Words.NAME_OR_NUMBER, "");
        this.stateCombo = new ComboBox(null, null, ConverterRegistry.getConverter(ModificationStateEConverter.class));
        this.filterChain.addSelectionComboBox(this.stateCombo, 90, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        this.typeCombo = new ComboBox(null, null, ConverterRegistry.getConverter(ProductCatalogTypeConverter.class));
        this.filterChain.addSelectionComboBox(this.typeCombo, 100, FILTER_TYPE, Words.TYPE, Words.ALL);
        this.periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), "", true);
        this.periodEditor.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.typeCombo.refreshPossibleValues(NodeToolkit.getAffixList(ProductCatalogTypeE.class));
        this.typeCombo.addItem(Words.ALL);
        this.stateCombo.refreshPossibleValues(NodeToolkit.getAffixList(ModificationStateE.class));
        this.stateCombo.addItem(Words.ALL);
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<ProductCatalogLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ProductCatalogSearchAlgorithm.class);
    }

    @Override
    public ASearchConfiguration<ProductCatalogLight, ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
            this.searchCriteria3 = null;
            this.searchCriteria4 = null;
            this.searchCriteria5 = null;
            if (this.periodEditor != null) {
                this.periodEditor.setCheckBoxChecked(false);
            }
        } else if (name == FILTER_NAME) {
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_CUSTOMER) {
            this.searchCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        } else if (name == FILTER_PERIOD) {
            this.searchCriteria3 = (TitledPeriodEditor)value;
        } else if (name == FILTER_TYPE) {
            if (value instanceof Node) {
                this.searchCriteria4 = (ProductCatalogTypeE)((Node)value).getValue();
            } else if (value instanceof String) {
                this.searchCriteria4 = null;
            }
        } else if (name == FILTER_STATE) {
            if (value instanceof String) {
                this.searchCriteria5 = null;
            } else if (value instanceof ModificationStateE) {
                this.searchCriteria5 = (ModificationStateE)value;
            } else if (value instanceof Node) {
                this.searchCriteria5 = (ModificationStateE)((Node)value).getValue();
            }
        }
        ProductCatalogSearchConfiguration c = new ProductCatalogSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        try {
            int number = Integer.valueOf(this.searchCriteria1);
            c.setNumber(Integer.valueOf(number));
        }
        catch (NumberFormatException number) {
            // empty catch block
        }
        c.setName(this.searchCriteria1);
        c.setCustomer((CustomerReference)this.searchCriteria2);
        c.setType(this.searchCriteria4);
        c.setState(this.searchCriteria5);
        if (this.searchCriteria3 != null) {
            PeriodComplete p = new PeriodComplete(this.searchCriteria3.getStartDate(), this.searchCriteria3.getEndDate());
            c.setPeriod(p);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<ProductCatalogLight> model) {
        if (screen.getInvokingName().equals(ProductCatalogAccess.PRINT_PRODUCT_CATALOG.getIdentifier())) {
            ProductCatalogLight catalog = (ProductCatalogLight)model.getNode().getValue();
            RDProvider provider = this.createProvider(false);
            boolean printAnyWay = provider.isWritable(ProductCatalogAccess.PRINT_CATALOG_ANYWAY);
            if (printAnyWay) {
                return true;
            }
            return Boolean.TRUE.equals(catalog.getReleasedForPrinting());
        }
        return model != null;
    }

    @Override
    public Object getValidationAttributes(RowPanel<ProductCatalogLight> p) {
        return null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<ProductCatalogLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<ProductCatalogLight> rowEditor = new MessageProvidedRowEditor<ProductCatalogLight>(model, Words.REMOVE_EMPTY_ENTRIES_BEFORE_SAVE);
            RDProvider p = this.createProvider(model.isAddRow());
            TemplateDetailsPanel d0 = null;
            SettingsDetailsPanel d1 = new SettingsDetailsPanel((RowEditor<ProductCatalogLight>)rowEditor, p);
            SettingsDetailsPanel2 d12 = new SettingsDetailsPanel2(rowEditor, p, d1);
            CombinedDetailsParagraph dd = new CombinedDetailsParagraph();
            dd.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 0.0));
            dd.add((Component)d12, new TableLayoutConstraint(1, 0, 0.5, 0.0));
            ProductsDetailsPanel d2 = new ProductsDetailsPanel(rowEditor, p, d1, d12);
            if (model.isAddRow()) {
                d0 = new TemplateDetailsPanel((RowEditor<ProductCatalogLight>)rowEditor, p);
                rowEditor.add(d0, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(dd, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 2, 1.0, 0.0));
                rowEditor.addToFocusQueue(d0);
            } else {
                rowEditor.add(dd, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
            }
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d12);
            rowEditor.addToFocusQueue(d2);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new ProductCatalogModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN.NUMBER, ProductCatalogLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columns.add(new TableColumnInfo(Words.STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN.STATE, ProductCatalogLight_.state, TableColumnInfo.state2, TableColumnInfo.state2, TableColumnInfo.state2));
        columns.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN.NAME, ProductCatalogLight_.title, 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN.CUSTOMER, ProductCatalogLight_.customer, 80, 80, 80));
        columns.add(new TableColumnInfo(Words.TYPE, "", (Class)ProductCatalogTypeConverter.class, (Enum<?>)ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN.TYPE, ProductCatalogLight_.catalogType, 120, 120, 120));
        columns.add(new TableColumnInfo(Words.VALIDITY, "", (Class)DateConverter.class, (Enum<?>)ProductCatalogSearchConfiguration.PRODUCT_CATALOG_COLUMN.START_DATE, "startDate-endDate", TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        return columns;
    }
}

