/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.profitandloss.details;

import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ALocalizedDeletableDTO_;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.profitandloss.ProfitAndLossComplete_;
import ch.icit.pegasus.server.core.dtos.profitandloss.ProfitAndLossLight;
import ch.icit.pegasus.server.core.dtos.profitandloss.ProfitAndLossLight_;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends StateDependantDetailsPanel<ProfitAndLossLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDComboBox> state;
    private TitledItem<RDMultiLocationComboBox> location;
    private TitledItem<RDTextField> name;
    private TitledPeriodEditor plPeriod;
    private TitledPeriodEditor flightPeriod;
    private TitledItem<RDSearchTextField2<InventoryLight>> startInventory;
    private TitledItem<RDSearchTextField2<InventoryLight>> endInventory;

    public SpecificationDetailsPanel(RowEditor<ProfitAndLossLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setOpaque(false);
        this.setCustomLayouter(new Layout());
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATION, TitledItem.TitledItemOrientation.NORTH);
        }
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(ModificationStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.plPeriod = new TitledPeriodEditor(null, true, provider);
        this.plPeriod.setTitleText("P+L Period from", "To");
        this.plPeriod.getStartDateChooser().setOverrideName(ProfitAndLossLight_.plPeriod);
        this.plPeriod.getEndDateChooser().setOverrideName(ProfitAndLossLight_.plPeriod);
        this.flightPeriod = new TitledPeriodEditor(null, true, provider);
        this.flightPeriod.setTitleText("Flight Period from", "To");
        this.flightPeriod.getStartDateChooser().setOverrideName(ProfitAndLossLight_.flightPeriod);
        this.flightPeriod.getEndDateChooser().setOverrideName(ProfitAndLossLight_.flightPeriod);
        this.startInventory = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.INVENTORY), Words.START_INVENTORY, TitledItem.TitledItemOrientation.NORTH);
        this.endInventory = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.INVENTORY), Words.END_INVENTORY, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.location);
        }
        this.addToView(this.number);
        this.addToView(this.state);
        this.addToView(this.name);
        this.addToView(this.plPeriod);
        this.addToView(this.flightPeriod);
        this.addToView(this.startInventory);
        this.addToView(this.endInventory);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ProfitAndLossLight_.plState;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.plPeriod);
        CheckedListAdder.addToList(focusList, this.flightPeriod);
        CheckedListAdder.addToList(focusList, this.startInventory);
        CheckedListAdder.addToList(focusList, this.endInventory);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.kill();
        }
        this.name.kill();
        this.plPeriod.kill();
        this.state.kill();
        this.number.kill();
        this.flightPeriod.kill();
        this.startInventory.kill();
        this.endInventory.kill();
        this.location = null;
        this.state = null;
        this.number = null;
        this.plPeriod = null;
        this.name = null;
        this.flightPeriod = null;
        this.startInventory = null;
        this.endInventory = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean b = isEnabled && isDraft;
        super.setEnabled(b);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.setEnabled(b);
        }
        this.state.setEnabled(b);
        this.number.setEnabled(b);
        this.name.setEnabled(b);
        this.plPeriod.setEnabled(b);
        this.flightPeriod.setEnabled(b);
        this.startInventory.setEnabled(b);
        this.endInventory.setEnabled(b);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            ProfitAndLossLight dto = (ProfitAndLossLight)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location.getElement().setNode(this.editor.getModel().getNode().getChildNamed(ALocalizedDeletableDTO_.eligibleLocations));
        }
        this.number.getElement().setNode(node.getChildNamed(ProfitAndLossLight_.number));
        this.name.getElement().setNode(node.getChildNamed(ProfitAndLossLight_.name));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ModificationStateE.class));
        this.state.getElement().setNode(node.getChildNamed(ProfitAndLossLight_.plState));
        this.plPeriod.setNode((Node<PeriodComplete>)node.getChildNamed(ProfitAndLossLight_.plPeriod));
        this.flightPeriod.setNode((Node<PeriodComplete>)node.getChildNamed(ProfitAndLossLight_.flightPeriod));
        this.startInventory.getElement().setNode(node.getChildNamed(ProfitAndLossComplete_.startInventory));
        this.endInventory.getElement().setNode(node.getChildNamed(ProfitAndLossComplete_.endInventory));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && (this.editor.getModel().getNode().getChildNamed(RestaurantComplete_.name).getValue() == null || this.editor.getModel().getNode().getChildNamed(RestaurantComplete_.name).getValue().equals(""))) {
            this.name.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        if (this.startInventory.getElement().isWritable() && this.editor.getModel().getNode().getChildNamed(ProfitAndLossComplete_.startInventory).getValue() == null) {
            this.startInventory.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Start Inventory is sete"));
        }
        if (this.endInventory.getElement().isWritable() && this.editor.getModel().getNode().getChildNamed(ProfitAndLossComplete_.endInventory).getValue() == null) {
            this.endInventory.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure End Inventory is sete"));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.location.getElement().isWritable() && this.location.getElement().getNode().getChildCount() < 1) {
            this.location.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(120, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(180, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            int cy = SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.location.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy);
                SpecificationDetailsPanel.this.location.setSize(180, (int)SpecificationDetailsPanel.this.location.getPreferredSize().getHeight());
                cy = SpecificationDetailsPanel.this.location.getY() + SpecificationDetailsPanel.this.location.getHeight() + SpecificationDetailsPanel.this.verticalBorder;
            }
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy);
            SpecificationDetailsPanel.this.state.setSize(180, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.plPeriod.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.plPeriod.setSize(SpecificationDetailsPanel.this.plPeriod.getPreferredSize());
            SpecificationDetailsPanel.this.flightPeriod.setLocation(SpecificationDetailsPanel.this.plPeriod.getX() + SpecificationDetailsPanel.this.plPeriod.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.plPeriod.getY());
            SpecificationDetailsPanel.this.flightPeriod.setSize(SpecificationDetailsPanel.this.flightPeriod.getPreferredSize());
            SpecificationDetailsPanel.this.startInventory.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.flightPeriod.getY() + SpecificationDetailsPanel.this.flightPeriod.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.startInventory.setSize(200, (int)SpecificationDetailsPanel.this.startInventory.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.endInventory.setLocation(SpecificationDetailsPanel.this.startInventory.getX() + SpecificationDetailsPanel.this.startInventory.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.startInventory.getY());
            SpecificationDetailsPanel.this.endInventory.setSize(200, (int)SpecificationDetailsPanel.this.endInventory.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + SpecificationDetailsPanel.this.location.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.verticalBorder;
            }
            h = (int)((double)h + SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.plPeriod.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.startInventory.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

