/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.approval.PurchaseApprovalRequestComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.approval.PurchaseApprovalStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PurchaseApprovalDetailsPanel
extends TableDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;

    public PurchaseApprovalDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider) {
        super(editor, provider, false);
        this.setTitleText("Approval History");
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding(), TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding(), TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding()));
        columns.add(new TableColumnInfo(Words.USER, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 90, 90, 90));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        return p;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        OrderReviewStateE o = (OrderReviewStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).getValue();
        if (o == null) {
            o = OrderReviewStateE.UNCHECKED;
            this.editor.getModel().getNode().getChildNamed(new String[]{"reviewState"}).setValue((Object)o, 0L);
        }
        boolean isApproved = o.equals((Object)OrderReviewStateE.APPROVED);
        super.setEnabled(isEnabled && !isApproved);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(PurchaseOrderComplete_.approvalRequests));
    }

    @Override
    public void layoutContainer(Container parent) {
        this.table.setLocation(0, 0);
        this.table.setSize(parent.getWidth(), parent.getHeight());
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        return new Dimension(0, 200);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel user;
        private TextLabel date;
        private TextLabel comment;
        private TextLabel state;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            UserLight user = (UserLight)m.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approvalUser).getValue(UserLight.class);
            if (user != null) {
                m.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approvalUser).removeExistingValues();
                m.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approvalUser).setValue((Object)user, 0L);
            }
            this.user = new TextLabel(m.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approvalUser), ConverterRegistry.getConverter(UserConverter.class));
            this.date = new TextLabel(m.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approvalDate), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.comment = new TextLabel(m.getNode().getChildNamed(PurchaseApprovalRequestComplete_.comment));
            this.state = new TextLabel();
            PurchaseApprovalStateE stateValue = (PurchaseApprovalStateE)m.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approved).getValue();
            switch (stateValue) {
                case PENDING: {
                    this.state.setText("Pending");
                    break;
                }
                case APPROVED: {
                    this.state.setText("Approved");
                    break;
                }
                case REJECTED: {
                    this.state.setText("Rejected");
                }
            }
            this.setLayout(new InnerLayout());
            this.add(this.user);
            this.add(this.date);
            this.add(this.comment);
            this.add(this.state);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approvalDate).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approvalUser).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(PurchaseApprovalRequestComplete_.comment).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(PurchaseApprovalRequestComplete_.approved).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.user.setEnabled(isEnabled);
            this.date.setEnabled(isEnabled);
            this.comment.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.user.kill();
            this.date.kill();
            this.comment.kill();
            this.state.kill();
            this.user = null;
            this.date = null;
            this.comment = null;
            this.state = null;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.date.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                int currentX = w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.user.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.user.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
            }
        }
    }
}

