/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.details;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.TableRowDateSorter;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.DetailsEditorParagraph;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public abstract class AVariantDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T>
implements Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    protected Table2 table;
    protected Table2RowPanel selectedPanel;

    public AVariantDetailsPanel(RowEditor editor, RDProvider provider) {
        super(editor, provider, true, true);
        this.setTitleText(Words.VARIANTS);
        this.table = new Table2(false, "", false, false);
        this.table.setComparator(ComparatorRegistry.getComparator(TableRowDateSorter.class));
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                AVariantDetailsPanel.this.editor.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                AVariantDetailsPanel.this.editor.revalidate();
            }
        });
        this.table.setModel(new Table2Model(this.getColumns(), model -> {
            Table2RowPanel p = this.getTableRow(model);
            p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            return p;
        }));
        this.setCustomLayouter(new Layout());
        this.table.getModel().addTableSelectionListener(this);
        this.addToView(this.table);
    }

    public abstract List<TableColumnInfo> getColumns();

    @Override
    public abstract List<ScreenValidationObject> validateParagraph();

    public abstract Table2RowPanel getTableRow(Table2RowModel var1);

    public abstract void reloadVariant(Node var1, Table2RowPanel var2);

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.table.setEnabled(true);
        this.table.setEditable(isEnabled);
        this.table.enableAddButton(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    public abstract boolean isVariantParent(Node<?> var1);

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor != null && this.editor.getModel() != null && this.editor.getModel().getNode() != null) {
            Node n = this.editor.getModel().getNode().getChildNamed(new String[]{"currentVariant"});
            if (node != null && this.isVariantParent(node)) {
                this.editor.getModel().getNode().getChildNamed(new String[]{"variants"}).getAllChildAddEventsFor(null, new String[0]);
                if (this.table != null) {
                    this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(new String[]{"variants"}));
                    if (n.getValue() == null) {
                        n = this.editor.getModel().getNode().getChildNamed(new String[]{"variants"}).getChildAt(0);
                    }
                    for (Table2RowPanel i : this.table.getRows()) {
                        if (!i.getModel().getNode().getValue().equals(n.getValue())) continue;
                        this.table.getModel().selectRow(i, true, false, 3);
                    }
                    this.table.updateOrder();
                }
            }
        }
    }

    public abstract Class getCommittingClass(Node<?> var1);

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel == null) {
            return;
        }
        if (this.selectedPanel != null) {
            this.selectedPanel.getModel().getNode().commitThis(this.getCommittingClass(this.selectedPanel.getModel().getNode()));
        }
        this.selectedPanel = panel;
        Node n = panel.getModel().getNode();
        this.reloadVariant(n, panel);
    }

    public void updatePanels(Node<?> node, Table2RowPanel panel) {
        for (DetailsEditorParagraph p : this.editor.getParagraphs()) {
            if (p.equals(this)) continue;
            p.setNode(node);
        }
        this.editor.hideCommittingAnimation();
        this.editor.setEnabled(true);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 180);
        }

        @Override
        public void layoutContainer(Container parent) {
            AVariantDetailsPanel.this.table.setLocation(0, 0);
            AVariantDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight() - 1);
        }
    }
}

