/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.flight.rim.waybills;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.List;

public class ActionRemoveWayBillComponent
extends DefaultScrollablePrintPopup2<FlightLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> node;
    private TitledItem<TextField> wayBillToRemove;

    public ActionRemoveWayBillComponent(Node<FlightLight> node) {
        super(false, false, false, false, null);
        this.node = node;
        this.insertElements();
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.reportTypesLoaded = true;
        this.createComponents();
        Node dateNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(((FlightLight)this.node.getValue()).getStd().getTime()), false, false);
        this.wayBillToRemove = new TitledItem<TextField>(new TextField(null, TextFieldType.NORMAL), Words.WAY_BILL_TO_REMOVE, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.wayBillToRemove);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.node.getChildNamed(FlightLight_.outboundCode).getValue() == null) {
            return "-";
        }
        return "" + (String)this.node.getChildNamed(FlightLight_.outboundCode).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a = super.validateBeforePrint();
        if (this.wayBillToRemove.getElement().getText().isEmpty()) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_WAY_BILL_IS_SET));
        }
        return a;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightLight flight = (FlightLight)ActionRemoveWayBillComponent.this.node.getValue();
                String waybill = ((TextField)ActionRemoveWayBillComponent.this.wayBillToRemove.getElement()).getText();
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).removeWayBill(flight, waybill);
                FlightComplete flightC = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(flight.getId())).getValue();
                ActionRemoveWayBillComponent.this.node.removeExistingValues();
                ActionRemoveWayBillComponent.this.node.setValue((Object)flightC, 0L);
                ActionRemoveWayBillComponent.this.node.updateNode();
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionRemoveWayBillComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.node;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionRemoveWayBillComponent.this.layoutInheritedComponents(parent);
            ActionRemoveWayBillComponent.this.wayBillToRemove.setLocation(ActionRemoveWayBillComponent.this.border, y);
            ActionRemoveWayBillComponent.this.wayBillToRemove.setSize(200, (int)ActionRemoveWayBillComponent.this.wayBillToRemove.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ActionRemoveWayBillComponent.this.getInheritedComponentsHeight();
            h += ActionRemoveWayBillComponent.this.border;
            if (ActionRemoveWayBillComponent.this.animation != null) {
                h = (int)((double)h + ActionRemoveWayBillComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(ActionRemoveWayBillComponent.this.border * 2) + ActionRemoveWayBillComponent.this.animation.getPreferredSize().getWidth()), h += ActionRemoveWayBillComponent.this.border);
            }
            h = (int)((double)h + ActionRemoveWayBillComponent.this.wayBillToRemove.getPreferredSize().getHeight());
            return new Dimension(0, h += ActionRemoveWayBillComponent.this.border);
        }
    }
}

