/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.purchase.approval;

import ch.icit.pegasus.client.actions.impl.SendPurchaseOrderAction;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.ordering.approval.PurchaseApprovalStateE;
import ch.icit.pegasus.server.core.dtos.system.PurchaseApprovalSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ActionApprovePOOrderComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextField> field;
    private TextButton approve;
    private TextButton reject;
    private Node node;
    private PurchaseApprovalStateE stateE = PurchaseApprovalStateE.PENDING;
    private final RowModel model;

    public ActionApprovePOOrderComponent(Node node, RowModel model) {
        super(false, false);
        this.node = node;
        this.model = model;
        this.getViewContainer().setLayout(new Layout());
        this.field = new TitledItem<TextField>(new TextField(), "Approve Purchase Order?", TitledItem.TitledItemOrientation.NORTH);
        this.field.setIgnorePrefHeight(true);
        this.approve = new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.OK);
        this.approve.setText("Approve");
        this.approve.addButtonListener((source, x, y) -> {
            this.stateE = PurchaseApprovalStateE.APPROVED;
            this.enterPressed(PopupAction.OK_FOREGROUND);
        });
        this.reject = new TablePanelAddSaveButton(TextButton.BUTTON_TYPES.CANCEL);
        this.reject.setText("Reject");
        this.reject.addButtonListener((source, x, y) -> {
            this.stateE = PurchaseApprovalStateE.REJECTED;
            this.enterPressed(PopupAction.OK_FOREGROUND);
        });
        this.getViewContainer().add(this.field);
        this.getViewContainer().add(this.approve);
        this.getViewContainer().add(this.reject);
    }

    @Override
    protected String getProgressText() {
        return Words.PROCESSING;
    }

    @Override
    protected String getFinishedText() {
        return Words.APPROVED;
    }

    @Override
    protected void startPrinting() {
        this.startPrinting2();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (ActionApprovePOOrderComponent.this.node != null) {
                    PurchaseOrderLight order = (PurchaseOrderLight)ActionApprovePOOrderComponent.this.node.getValue(PurchaseOrderLight.class);
                    PurchaseOrderComplete updatedOrder = (PurchaseOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).approveOrder(new PurchaseOrderReference(order.getId()), ActionApprovePOOrderComponent.this.stateE, ((TextField)ActionApprovePOOrderComponent.this.field.getElement()).getText()).getValue();
                    PurchaseApprovalSettingsComplete approvalSettingsComplete = (PurchaseApprovalSettingsComplete)NodeToolkit.getAffixClass(PurchaseApprovalSettingsComplete.class).getValue();
                    if (Boolean.TRUE.equals(approvalSettingsComplete.getAutoSendPurchaseOrderToSupplier()) && updatedOrder.getApproved() == PurchaseApprovalStateE.APPROVED) {
                        new SendPurchaseOrderAction().performAction(ActionApprovePOOrderComponent.this, null, updatedOrder, updatedOrder.getPlaceUser());
                    }
                    ActionApprovePOOrderComponent.this.node.removeExistingValues();
                    ActionApprovePOOrderComponent.this.node.setValue((Object)updatedOrder, 0L);
                    ActionApprovePOOrderComponent.this.model.setNode(ActionApprovePOOrderComponent.this.node);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionApprovePOOrderComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.field.setVisible(false);
        this.approve.setVisible(false);
        this.reject.setVisible(false);
    }

    @Override
    public List<Component> getFocusComponents() {
        return super.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleString() {
        return "";
    }

    @Override
    public String getTitleValue() {
        return "";
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(200, ActionApprovePOOrderComponent.this.getInheritedComponentsHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ActionApprovePOOrderComponent.this.layoutInheritedComponents(parent);
            int border = 10;
            ActionApprovePOOrderComponent.this.field.setLocation(border, border);
            ActionApprovePOOrderComponent.this.field.setSize(parent.getWidth() - 2 * border, (int)ActionApprovePOOrderComponent.this.field.getPreferredSize().getHeight());
            ActionApprovePOOrderComponent.this.approve.setLocation(border * 3, ActionApprovePOOrderComponent.this.field.getY() + ActionApprovePOOrderComponent.this.field.getHeight() + border * 3);
            ActionApprovePOOrderComponent.this.approve.setSize(ActionApprovePOOrderComponent.this.approve.getPreferredSize());
            ActionApprovePOOrderComponent.this.reject.setLocation((int)((double)parent.getWidth() - ((double)(3 * border) + ActionApprovePOOrderComponent.this.reject.getPreferredSize().getWidth())), ActionApprovePOOrderComponent.this.approve.getY());
            ActionApprovePOOrderComponent.this.reject.setSize(ActionApprovePOOrderComponent.this.reject.getPreferredSize());
        }
    }
}

