/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.store.restore;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.QuantityConverter2Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TableSearchStateListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.SaveButton;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StockTransactionSearchAlgorithm2;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockConsumptionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockConsumptionComplete_;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class RestoreConsumedStockActionComponent
extends DefaultScrollablePrintPopup2<StoreLight>
implements TableSearchStateListener {
    private static final long serialVersionUID = 1L;
    private PageableTable2 table;
    private boolean isLoadingLatest = false;
    private final Node<StoreLight> store;

    public RestoreConsumedStockActionComponent(Node<StoreLight> currentNode) {
        super(false, false, false, false, false, null);
        this.store = currentNode;
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
        this.isLoadingLatest = true;
        this.remoteObjectLoaded((Node)null);
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingLatest) {
            this.removeAnimation(false);
            this.createComponents();
            this.createInners();
            this.table.setSortedColumn(0);
            this.table.setSortDirection(true);
            this.table.getModel().setNode((Node)new ViewNode("transactions"));
            this.popup.enableCancelButton(true);
            this.table.invokeDefaultSearch();
            this.isLoadingLatest = false;
        } else {
            super.remoteObjectLoaded(node);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new PageableTable2("", true, true, false){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return SearchAlgorithmRegistry.getSearchAlgorithm(StockTransactionSearchAlgorithm2.class);
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                StockTransactionSearchConfiguration c = new StockTransactionSearchConfiguration();
                c.setNumResults(this.numberOfShownResults);
                c.setStore((StoreReference)RestoreConsumedStockActionComponent.this.store.getValue());
                c.setType(StockTransactionTypeE.STOCKCONSUMPTION);
                c.setSortDirection(SortDirection.DESCENDING);
                c.setSortColumn((Enum)StockTransactionSearchConfiguration.TRANSACTION_COLUMN.DATE);
                c.setPageNumber(this.pagination.getCurrentPage() - 1);
                if (c.getPageNumber() < 0) {
                    c.setPageNumber(0);
                }
                return c;
            }

            @Override
            public void fillFilterChain() {
            }
        };
        this.table.addTableSearchStateListener(this);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding()));
        columns.add(new TableColumnInfo(Words.CHARGE, null, null, null, "", TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.NAME, null, null, null, "", 40, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", TableColumnInfo.priceColumnWidth));
        columns.add(new TableColumnInfo(Words.TARGET, null, null, null, "", 40, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.RESTORE, null, null, null, "", 42));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.getViewContainer().add(this.table);
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public void popupClosed() {
        super.popupClosed();
    }

    @Override
    protected String getProgressText() {
        return Words.getFirstCapitalLetter((String)Words.PRINT);
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.store.getValue()).getCode();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RestoreConsumedStockActionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (super.isInnerComponent(c)) {
            return true;
        }
        return this.table.isInnerComponent(c);
    }

    @Override
    public Node getCurrentNode() {
        return this.store;
    }

    @Override
    public void insertElements() {
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public BatchJob createBatchJob(Node value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    protected void setEnabledFromRemoteLoad(boolean isEnabled) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.table != null) {
            this.table.setEnabled(isEnabled);
        }
        super.setEnabled(isEnabled);
    }

    @Override
    public void searchStarted() {
    }

    @Override
    public void searchFinished() {
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel when;
        private TextLabel charge;
        private TextLabel name;
        private QuantityRenderer quantity;
        private StorePositionSearchBox store;
        private SaveButton saveButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.when = new TextLabel(m.getNode().getChildNamed(StockTransactionComplete_.date), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.charge = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StockConsumptionComplete_.charge, ArticleChargeLight_.number}), ConverterRegistry.getConverter(IntegerConverter.class));
            this.name = new TextLabel(m.getNode().getChildNamed(new DtoField[]{StockConsumptionComplete_.charge, ArticleChargeLight_.basicArticle, BasicArticleLight_.name}));
            this.quantity = new QuantityRenderer((Node<?>)m.getNode().getChildNamed(StockTransactionComplete_.amount), (Converter<?, ?>)ConverterRegistry.getConverter(QuantityConverter2Decimal.class));
            this.store = new StorePositionSearchBox();
            StockConsumptionComplete value = (StockConsumptionComplete)m.getNode().getValue();
            Node storeNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)value.getStorePosition(), false, true);
            this.store.setNode((Node<StorePositionLight>)storeNode);
            this.saveButton = new SaveButton();
            this.saveButton.addButtonListener((source, x, y) -> {
                RestoreConsumedStockActionComponent.this.table.setEnabled(false);
                RestoreConsumedStockActionComponent.this.table.showLoadingAnimation("Restore");
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        TableRowImpl.this.saveRestore();
                        return null;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                ScreenValidationObject consumption_restored = new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, "Consumption restored");
                                InnerPopupFactory.showDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{consumption_restored}), "Success", "", "", null, RestoreConsumedStockActionComponent.this, PopupType.NORMAL);
                                RestoreConsumedStockActionComponent.this.table.setEnabled(true);
                                RestoreConsumedStockActionComponent.this.table.hideLoadingAnimation();
                                RestoreConsumedStockActionComponent.this.table.invokeDefaultSearch();
                            }

                            public void errorOccurred(ClientException exception) {
                                InnerPopupFactory.showErrorDialog((Exception)exception, (Component)RestoreConsumedStockActionComponent.this);
                                RestoreConsumedStockActionComponent.this.table.setEnabled(true);
                                RestoreConsumedStockActionComponent.this.table.hideLoadingAnimation();
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            });
            this.setLayout(new InnerLayout());
            this.add(this.when);
            this.add(this.charge);
            this.add(this.name);
            this.add(this.quantity);
            this.add(this.store);
            this.add(this.saveButton);
        }

        @Override
        public boolean isInnerComponent(Component c) {
            if (super.isInnerComponent(c)) {
                return true;
            }
            return this.store.isInnerComponent(c);
        }

        private void saveRestore() {
            StockConsumptionComplete transaction = (StockConsumptionComplete)this.model.getNode().getValue();
            StorePositionLight position = (StorePositionLight)this.store.getPositionNode().getValue();
            if (position != null) {
                try {
                    ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).restoreTransaction(transaction, position);
                }
                catch (ClientServerCallException e) {
                    InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)RestoreConsumedStockActionComponent.this);
                }
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"date"}).getValue();
                }
                case 1: {
                    return this.charge.getText();
                }
                case 2: {
                    return this.name.getText();
                }
                case 3: {
                    return this.quantity.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.when.setEnabled(isEnabled);
            this.charge.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.store.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            super.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.when.kill();
            this.charge.kill();
            this.name.kill();
            this.quantity.kill();
            this.store.kill();
            this.saveButton.kill();
            this.when = null;
            this.charge = null;
            this.name = null;
            this.quantity = null;
            this.store = null;
            this.saveButton = null;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.when.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.when.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.when.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.when.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.charge.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.charge.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.charge.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.charge.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                TableRowImpl.this.store.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.store.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.store.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.store.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(5);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.saveButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.saveButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.saveButton.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.saveButton.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = RestoreConsumedStockActionComponent.this.layoutInheritedComponents(parent);
            cy += RestoreConsumedStockActionComponent.this.border;
            if (RestoreConsumedStockActionComponent.this.table != null) {
                RestoreConsumedStockActionComponent.this.table.setLocation(RestoreConsumedStockActionComponent.this.border, cy);
                RestoreConsumedStockActionComponent.this.table.setSize(parent.getWidth() - 2 * RestoreConsumedStockActionComponent.this.border, parent.getHeight() - (cy + RestoreConsumedStockActionComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = RestoreConsumedStockActionComponent.this.getInheritedComponentsHeight() + RestoreConsumedStockActionComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

