/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.export.remote_new.product;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.export.AsyncSimpleExportPopupInsert;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.product.ProductExportAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class ProductExportAnalysisComponent
extends AsyncSimpleExportPopupInsert<ProductComplete> {
    private static final long serialVersionUID = 1L;
    private boolean isNoPro;
    private boolean showProductionCosts;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> includeAllVariants;
    private TitledItem<CheckBox> includeCosts;
    private TitledItem<CheckBox> includeSobData;
    private TitledItem<CheckBox> includeTenderData;
    private TitledItem<CheckBox> includeDepartmentCheck;

    public ProductExportAnalysisComponent(AnalysisSmartExternalOpenTool<ProductComplete> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        Node dn = new Node();
        dn.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dn), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        if (!this.isNoPro) {
            this.includeAllVariants = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALL_VARIANTS, TitledItem.TitledItemOrientation.EAST);
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            boolean restaurantUser = false;
            if (Boolean.TRUE.equals(currentUser.getRestaurantUser())) {
                restaurantUser = true;
            }
            if (!restaurantUser) {
                this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
                this.includeSobData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SOB_DATA, TitledItem.TitledItemOrientation.EAST);
                this.includeTenderData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TENDER, TitledItem.TitledItemOrientation.EAST);
                this.includeDepartmentCheck = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_DEPARTMENT_CHECK, TitledItem.TitledItemOrientation.EAST);
            }
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllVariants, "allVariants"));
            if (!restaurantUser) {
                this.addOptionsItem(new CheckBoxAnalysisItem(this.includeCosts, "includeCosts"));
                this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSobData, "includeSob"));
                this.addOptionsItem(new CheckBoxAnalysisItem(this.includeTenderData, "tender"));
                this.addOptionsItem(new CheckBoxAnalysisItem(this.includeDepartmentCheck, "departmentCheck"));
            }
        }
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.Product;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        ProductExportAnalysisReportConfiguration conf = new ProductExportAnalysisReportConfiguration();
        if (this.isNoPro) {
            conf.setShowProductionCosts(false);
            conf.setValidityDate((Date)this.validityDate.getElement().getNode().getValue());
            conf.setIncludeAllVariants(false);
            conf.setIncludeCosts(false);
            conf.setIncludeSobData(false);
            conf.setIncludeTender(false);
            conf.setIncludeDepartmentCheck(Boolean.valueOf(false));
        } else {
            this.showProductionCosts = ProductToolkit.canExportProductCosts(false);
            conf.setShowProductionCosts(this.showProductionCosts);
            Date date = (Date)this.validityDate.getElement().getNode().getValue();
            conf.setValidityDate(date);
            conf.setIncludeAllVariants(this.includeAllVariants.getElement().isChecked());
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            boolean restaurantUser = false;
            if (Boolean.TRUE.equals(currentUser.getRestaurantUser())) {
                restaurantUser = true;
            }
            if (!restaurantUser) {
                conf.setIncludeCosts(this.includeCosts.getElement().isChecked());
                conf.setIncludeSobData(this.includeSobData.getElement().isChecked());
                conf.setIncludeTender(this.includeTenderData.getElement().isChecked());
                conf.setIncludeDepartmentCheck(Boolean.valueOf(this.includeDepartmentCheck.getElement().isChecked()));
            } else {
                conf.setIncludeCosts(false);
                conf.setIncludeSobData(false);
                conf.setIncludeTender(false);
                conf.setIncludeDepartmentCheck(Boolean.valueOf(false));
            }
        }
        return conf;
    }
}

