/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.matdispo;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.export.AsyncSimpleExportPopupInsert;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.TextFieldAnalysisItem;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.analysis.FlightExportAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public class FlightMaterialDispositionExportAnalysisComponent
extends AsyncSimpleExportPopupInsert<FlightLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextField> defaultLoad;
    private TitledItem<CheckBox> includeProductFactSheets;
    private TitledItem<CheckBox> showCosts;
    private TitledItem<CheckBox> resolveRecipesToArticles;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> useTender;
    private TitledItem<CheckBox> includeAllArticleSheet;
    private TitledItem<CheckBox> includeAllArticlesInKG;
    private TitledItem<CheckBox> includeAllArticlesInPIECE;
    private TitledItem<CheckBox> includeAllArticlesInReportUnit;
    private TitledItem<CheckBox> includeAllRecipeSheet;
    private TitledItem<CheckBox> includeAllProductSheet;
    private TitledItem<CheckBox> includeAllArticleByDaySheet;
    private TitledItem<CheckBox> includeAllRecipeByDaySheet;
    private TitledItem<CheckBox> includeAllProductByDaySheet;
    private TitledItem<CheckBox> includeAllArticleByProduct;
    private TitledItem<CheckBox> includeAllRecipeByProduct;
    private TitledItem<CheckBox> includeArticleByRecipe;
    private TitledItem<CheckBox> includeAllArticleByProductByDay;
    private TitledItem<CheckBox> includeAllRecipeByProductByDay;
    private TitledItem<CheckBox> includeArticleByRecipeByDay;

    public FlightMaterialDispositionExportAnalysisComponent(AnalysisSmartExternalOpenTool<FlightLight> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        this.defaultLoad = new TitledItem<TextField>(new TextField(null, TextFieldType.DOUBLE), Words.LOAD_FOR_PLANNED_FLIGHTS_IN_PERCENT, TitledItem.TitledItemOrientation.NORTH);
        this.defaultLoad.getElement().setText("80");
        this.addOptionsItem(new TextFieldAnalysisItem(this.defaultLoad, "defaultLoad"));
        this.includeProductFactSheets = new TitledItem<CheckBox>(new CheckBox(), "Include Product Fact Sheets", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeProductFactSheets, "factSheets"));
        this.showCosts = new TitledItem<CheckBox>(new CheckBox(), "Include Costs on Fact Sheets", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.showCosts, "costs"));
        this.resolveRecipesToArticles = new TitledItem<CheckBox>(new CheckBox(), "Resolve Recipes to Article on Fact Sheets", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.resolveRecipesToArticles, "article4Recipes"));
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(), "Fact Sheets Due Date", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
        this.useTender = new TitledItem<CheckBox>(new CheckBox(), "Use Tender", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.useTender, "useTender"));
        this.includeAllArticleSheet = new TitledItem<CheckBox>(new CheckBox(), "Include Article Sheet (Store Unit)", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllArticleSheet, "allSheetsSU"));
        this.includeAllArticlesInKG = new TitledItem<CheckBox>(new CheckBox(), "Include Article Sheet (kg)", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllArticlesInKG, "allSheetsKG"));
        this.includeAllArticlesInPIECE = new TitledItem<CheckBox>(new CheckBox(), "Include Article Sheet (Piece)", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllArticlesInPIECE, "allSheetsKG"));
        this.includeAllArticlesInReportUnit = new TitledItem<CheckBox>(new CheckBox(), "Include Article Sheet (Report Unit)", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllArticlesInReportUnit, "allSheetsKG"));
        this.includeAllRecipeSheet = new TitledItem<CheckBox>(new CheckBox(), "Include Recipe Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllRecipeSheet, "recipeSheet"));
        this.includeAllProductSheet = new TitledItem<CheckBox>(new CheckBox(), "Include Product Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllProductSheet, "productSheet"));
        this.includeAllArticleByDaySheet = new TitledItem<CheckBox>(new CheckBox(), "Include Article by Day Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllArticleByDaySheet, "articlePerDay"));
        this.includeAllRecipeByDaySheet = new TitledItem<CheckBox>(new CheckBox(), "Include Recipe by Day Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllRecipeByDaySheet, "recipePerDay"));
        this.includeAllProductByDaySheet = new TitledItem<CheckBox>(new CheckBox(), "Include Product by Day Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllProductByDaySheet, "productPerDay"));
        this.includeAllArticleByProduct = new TitledItem<CheckBox>(new CheckBox(), "Include Article by Product Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllArticleByProduct, "articlePerProduct"));
        this.includeAllRecipeByProduct = new TitledItem<CheckBox>(new CheckBox(), "Include Recipe by Product Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllRecipeByProduct, "recipePerProduct"));
        this.includeArticleByRecipe = new TitledItem<CheckBox>(new CheckBox(), "Include Article by Recipe Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeArticleByRecipe, "articlePerRecipe"));
        this.includeAllArticleByProductByDay = new TitledItem<CheckBox>(new CheckBox(), "Include Article by Product by Day Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllArticleByProductByDay, "articlePerProductPerDay"));
        this.includeAllRecipeByProductByDay = new TitledItem<CheckBox>(new CheckBox(), "Include Recipe by Product by Day Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeAllRecipeByProductByDay, "recipePerProductPerDay"));
        this.includeArticleByRecipeByDay = new TitledItem<CheckBox>(new CheckBox(), "Include Article by Recipe by Day Sheet", TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeArticleByRecipeByDay, "articlePerRecipePerDay"));
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        boolean selected = false;
        if (this.includeAllArticleSheet.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllArticlesInKG.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllArticlesInPIECE.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllArticlesInReportUnit.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllRecipeSheet.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllProductSheet.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllArticleByDaySheet.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllRecipeByDaySheet.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllProductByDaySheet.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllArticleByProduct.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllRecipeByProduct.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeArticleByRecipe.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllArticleByProductByDay.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeAllRecipeByProductByDay.getElement().isChecked()) {
            selected = true;
        }
        if (this.includeArticleByRecipeByDay.getElement().isChecked()) {
            selected = true;
        }
        if (selected) {
            return null;
        }
        return Collections.singletonList(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Select at least one Sheet"));
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.FlightMatDisposition;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        FlightExportAnalysisReportConfiguration config = new FlightExportAnalysisReportConfiguration();
        config.setReportType(GenericAnalysisReportType.FlightMatDisposition);
        config.setIncludeProductFactSheets(Boolean.valueOf(this.includeProductFactSheets.getElement().isChecked()));
        config.setShowCosts(Boolean.valueOf(this.showCosts.getElement().isChecked()));
        config.setResolveRecipesToArticles(Boolean.valueOf(this.resolveRecipesToArticles.getElement().isChecked()));
        Date dueDate = (Date)this.validityDate.getElement().getNode().getValue();
        config.setValidityDate(new Timestamp(dueDate.getTime()));
        config.setIncludeAllArticleSheet(Boolean.valueOf(this.includeAllArticleSheet.getElement().isChecked()));
        config.setIncludeAllArticleSheetKG(this.includeAllArticlesInKG.getElement().isChecked());
        config.setIncludeAllArticleSheetPIECE(this.includeAllArticlesInPIECE.getElement().isChecked());
        config.setIncludeAllArticleSheetReportUnit(this.includeAllArticlesInReportUnit.getElement().isChecked());
        config.setIncludeAllRecipeSheet(Boolean.valueOf(this.includeAllRecipeSheet.getElement().isChecked()));
        config.setIncludeAllProductSheet(Boolean.valueOf(this.includeAllProductSheet.getElement().isChecked()));
        config.setIncludeAllArticleByDaySheet(Boolean.valueOf(this.includeAllArticleByDaySheet.getElement().isChecked()));
        config.setIncludeAllRecipeByDaySheet(Boolean.valueOf(this.includeAllRecipeByDaySheet.getElement().isChecked()));
        config.setIncludeAllProductByDaySheet(Boolean.valueOf(this.includeAllProductByDaySheet.getElement().isChecked()));
        config.setIncludeAllArticleByProduct(Boolean.valueOf(this.includeAllArticleByProduct.getElement().isChecked()));
        config.setIncludeAllRecipeByProduct(Boolean.valueOf(this.includeAllRecipeByProduct.getElement().isChecked()));
        config.setIncludeArticleByRecipe(Boolean.valueOf(this.includeArticleByRecipe.getElement().isChecked()));
        config.setIncludeAllArticleByProductByDay(Boolean.valueOf(this.includeAllArticleByProductByDay.getElement().isChecked()));
        config.setIncludeAllRecipeByProductByDay(Boolean.valueOf(this.includeAllRecipeByProductByDay.getElement().isChecked()));
        config.setIncludeArticleByRecipeByDay(Boolean.valueOf(this.includeArticleByRecipeByDay.getElement().isChecked()));
        config.setUseTender(this.useTender.getElement().isChecked());
        try {
            double d = Double.valueOf(this.defaultLoad.getElement().getText());
            config.setDefaultLoadForPlannedFlights(d / 100.0);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return config;
    }
}

