/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.returnscount;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.ReturnsCountReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReturnsCountReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class ExportReturnsCountComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<ReturnsCountReportConfiguration> configNode;
    private TitledDateTimePeriodChooser periodEditor;
    private TitledItem<SearchTextField2<CustomerLight>> customer;

    public ExportReturnsCountComponent() {
        super(false, false, ReportTypeE.EXPORT_RETURNS_COUNT);
        ReturnsCountReportConfiguration config = new ReturnsCountReportConfiguration(ReportTypeE.EXPORT_RETURNS_COUNT, ReportingOutputFormatE.PDF, null);
        config.setPeriod(new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public boolean getIsPreviewAnyway() {
        return true;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.customer);
        return focusList;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.periodEditor = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)this.configNode.getChildNamed(ReturnsCountReportConfiguration_.period));
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.configNode.getChildNamed(ReturnsCountReportConfiguration_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.periodEditor);
        this.getViewContainer().add(this.customer);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.periodEditor != null) {
            this.periodEditor.setEnabled(isEnabled);
        }
        if (this.customer != null) {
            this.customer.setEnabled(isEnabled);
        }
    }

    @Override
    protected String getProgressText() {
        return Words.EXPORT;
    }

    @Override
    public String getTitleString() {
        return Words.RETURNS_COUNT;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return Words.FLIGHTS;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.periodEditor != null) {
            this.periodEditor.kill();
        }
        if (this.customer != null) {
            this.customer.kill();
        }
        this.customer = null;
        this.periodEditor = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.periodEditor != null) {
            this.periodEditor.setVisible(true);
        }
        if (this.customer != null) {
            this.customer.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.periodEditor != null) {
            this.periodEditor.setVisible(false);
        }
        if (this.customer != null) {
            this.customer.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = ExportReturnsCountComponent.this.getSelectedReport();
                ExportReturnsCountComponent.this.configNode.commit();
                ReturnsCountReportConfiguration config = (ReturnsCountReportConfiguration)ExportReturnsCountComponent.this.configNode.getValue();
                config.setStylesheet(file);
                config.setFormat(ReportingOutputFormatE.XLSX);
                config.setPeriod(ExportReturnsCountComponent.this.periodEditor.getTimePeriod());
                FlightSearchConfiguration fs = new FlightSearchConfiguration();
                fs.setCustomer(config.getCustomer());
                fs.setDayPeriod(new PeriodComplete(new Date(ExportReturnsCountComponent.this.periodEditor.getTimePeriod().getStartTime().getTime()), new Date(ExportReturnsCountComponent.this.periodEditor.getTimePeriod().getEndTime().getTime())));
                fs.getLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                SearchResultIterator si = new SearchResultIterator((ASearchConfiguration)fs);
                while (si.hasNext()) {
                    FlightLight f = (FlightLight)si.next();
                    if (f.getId() == null || f.getStd().getTime() < ExportReturnsCountComponent.this.periodEditor.getTimePeriod().getStartTime().getTime() || f.getStd().getTime() > ExportReturnsCountComponent.this.periodEditor.getTimePeriod().getEndTime().getTime()) continue;
                    config.getFlights().add(new FlightReference(f.getId()));
                }
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createReturnsCountExport(config).getValue();
                ExportReturnsCountComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ExportReturnsCountComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ExportReturnsCountComponent.this.layoutInheritedComponents(parent) + ExportReturnsCountComponent.this.border;
            if (ExportReturnsCountComponent.this.periodEditor != null) {
                ExportReturnsCountComponent.this.periodEditor.setLocation(ExportReturnsCountComponent.this.border, y + ExportReturnsCountComponent.this.border / 2);
                ExportReturnsCountComponent.this.periodEditor.setSize(parent.getWidth() - 2 * ExportReturnsCountComponent.this.border, (int)ExportReturnsCountComponent.this.periodEditor.getPreferredSize().getHeight());
                ExportReturnsCountComponent.this.customer.setLocation(ExportReturnsCountComponent.this.border, ExportReturnsCountComponent.this.periodEditor.getY() + ExportReturnsCountComponent.this.periodEditor.getHeight() + ExportReturnsCountComponent.this.border / 2);
                ExportReturnsCountComponent.this.customer.setSize(parent.getWidth() - 2 * ExportReturnsCountComponent.this.border, (int)ExportReturnsCountComponent.this.customer.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ExportReturnsCountComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (ExportReturnsCountComponent.this.periodEditor != null) {
                h = (int)((double)h + ExportReturnsCountComponent.this.periodEditor.getPreferredSize().getHeight());
                h += ExportReturnsCountComponent.this.border / 2;
                h = (int)((double)h + ExportReturnsCountComponent.this.customer.getPreferredSize().getHeight());
                h += ExportReturnsCountComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

