/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.invoice.remote.summary;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InvoiceReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.search.InvoiceSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;

public class AnalysisInvoiceSummaryComponent
extends DefaultServerSideAnalysisComponent<InvoiceLight, InvoiceReference> {
    private static final long serialVersionUID = 1L;
    private CheckBox groupCustomerCheckbox;
    private boolean isNoPro;

    public AnalysisInvoiceSummaryComponent(AnalysisSmartExternalOpenTool<InvoiceLight> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (!this.isNoPro) {
            this.groupCustomerCheckbox = new CheckBox();
            this.addOptionsItem(new CheckBoxAnalysisItem(new TitledItem<CheckBox>(this.groupCustomerCheckbox, "Group by Customer", TitledItem.TitledItemOrientation.EAST), "groupCustomer"));
        }
    }

    @Override
    public String getTitleString() {
        return Words.INVOICE_SUMMARY;
    }

    @Override
    public String getTitleValue() {
        return Words.INVOICE;
    }

    @Override
    public InvoiceReference createReference(InvoiceLight item) {
        return new InvoiceReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        InvoiceSearchConfiguration invoiceSearch = (InvoiceSearchConfiguration)this.getSearchConfiguration();
        if (invoiceSearch == null) {
            invoiceSearch = (InvoiceSearchConfiguration)this.externalOpenTool.getEmptyConfig();
            invoiceSearch.setSearchtype(ASearchConfiguration.SearchType.Full);
            invoiceSearch.setPageNumber(0);
            invoiceSearch.setNumResults(Integer.MAX_VALUE);
            invoiceSearch.setNumbers(this.getNumbers());
        }
        boolean groupByCustomer = !this.isNoPro ? this.groupCustomerCheckbox.isChecked() : false;
        PegasusFileComplete file = (PegasusFileComplete)((InvoiceReportServiceManager)ServiceManagerRegistry.getService(InvoiceReportServiceManager.class)).createInvoiceSummary(invoiceSearch, groupByCustomer).getValue();
        return file;
    }
}

