/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.productcatalog.articles;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.report.ProductRecipeSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class AnalysisArticlesDetailsComponent
extends DefaultServerSideAnalysisComponent<ProductCatalogLight, ProductCatalogReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> showGroupNames;
    private TitledItem<CheckBox> showCosts;
    private TitledItem<CheckBox> includeTender;

    public AnalysisArticlesDetailsComponent(AnalysisSmartExternalOpenTool<ProductCatalogLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.showGroupNames = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_PRODUCT_GROUP_AND_RECIPE, TitledItem.TitledItemOrientation.EAST);
        this.includeTender = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_TENDER, TitledItem.TitledItemOrientation.EAST);
        boolean canExportCosts = ProductToolkit.canExportProductCosts(true);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.showGroupNames, "showGroup"));
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeTender, "tender"));
        if (canExportCosts) {
            this.showCosts = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.showCosts, "costs"));
        }
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_CATALOG_ARTICLES;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT_CATALOG;
    }

    @Override
    public ProductCatalogReference createReference(ProductCatalogLight item) {
        return new ProductCatalogReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        Timestamp ts = new Timestamp(date.getTime());
        boolean group = this.showGroupNames.getElement().isChecked();
        List references = this.loadItemReferences();
        ProductRecipeSheetReportConfiguration config = new ProductRecipeSheetReportConfiguration(null);
        config.setShowProductGroupAndRecipes(Boolean.valueOf(group));
        config.setIncludeTender(Boolean.valueOf(this.includeTender.getElement().isChecked()));
        if (this.showCosts != null) {
            config.setIncludeCost(Boolean.valueOf(this.showCosts.getElement().isChecked()));
        }
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductCatalogsArticleReport(new ListWrapper(references), config, new TimestampWrapper(ts)).getValue();
        return file;
    }
}

