/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.dailyops;

import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.ContactComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderOpenPositionReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.List;

public class PrintOrderDailyOpsComponent
extends DefaultScrollablePrintPopup2<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor periodEditor;
    private TitledItem<ComboBox> deliveryAddresses;
    private TitledItem<ComboBox> filterBonded;
    private TitledItem<CheckBox> includeClosedPositions;
    private TitledItem<CheckBox> includeOverDuePositions;

    public PrintOrderDailyOpsComponent() {
        super(false, true, ReportTypeE.PURCHASE_ORDER_DAILY_OPS);
    }

    @Override
    public void insertElements() {
        this.createComponents();
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (isNoPro) {
            PeriodComplete periodComplete = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
            Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)periodComplete, false, false);
            this.periodEditor = new TitledPeriodEditor((Node<Date>)periodNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)periodNode.getChildNamed(PeriodComplete_.endDate), true, null);
            this.periodEditor.setVisible(true);
            this.getViewContainer().setLayout(new Layout());
            this.getViewContainer().add(this.periodEditor);
        } else {
            PeriodComplete periodComplete = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
            Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)periodComplete, false, false);
            this.periodEditor = new TitledPeriodEditor((Node<Date>)periodNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)periodNode.getChildNamed(PeriodComplete_.endDate), true, null);
            this.deliveryAddresses = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(SystemSettingsComplete_.deliveryAddresses), ConverterRegistry.getConverter(StandaloneContactConverter.class)), Words.DELIVERY_ADDRESS, TitledItem.TitledItemOrientation.NORTH);
            if (this.deliveryAddresses.getElement().getItemCount() > 1) {
                this.deliveryAddresses.getElement().setSelectedIndex(0);
            }
            this.deliveryAddresses.getElement().addItem(Words.ALL);
            this.filterBonded = new TitledItem<ComboBox>(new ComboBox(), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
            this.filterBonded.getElement().addItem(BondedStateE.ALL);
            this.filterBonded.getElement().addItem(BondedStateE.NOT_BONDED);
            this.filterBonded.getElement().addItem(BondedStateE.ONLY_BONDED);
            this.filterBonded.getElement().selectItem(BondedStateE.ALL);
            this.includeClosedPositions = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CLOSED_POSITIONS, TitledItem.TitledItemOrientation.EAST);
            this.includeOverDuePositions = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_OVERDUE_POSITIONS, TitledItem.TitledItemOrientation.EAST);
            this.periodEditor.setVisible(true);
            this.deliveryAddresses.setVisible(true);
            this.filterBonded.setVisible(true);
            this.includeOverDuePositions.setVisible(true);
            this.getViewContainer().setLayout(new Layout());
            this.getViewContainer().add(this.periodEditor);
            this.getViewContainer().add(this.deliveryAddresses);
            this.getViewContainer().add(this.filterBonded);
            this.getViewContainer().add(this.includeClosedPositions);
            this.getViewContainer().add(this.includeOverDuePositions);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (isNoPro) {
            return reportFile.getFileName().trim().equals("PurchaseOrderDailyOpsSheet");
        }
        if (reportFile.getFileName().contains("CACP")) {
            return false;
        }
        if (reportFile.getFileName().contains("HACCP")) {
            return false;
        }
        return super.isReportAllowed(reportFile);
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.periodEditor.setVisible(true);
        if (this.deliveryAddresses != null) {
            this.deliveryAddresses.setVisible(true);
            this.filterBonded.setVisible(true);
            this.includeClosedPositions.setVisible(true);
            this.includeOverDuePositions.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.periodEditor.setVisible(false);
        if (this.deliveryAddresses != null) {
            this.deliveryAddresses.setVisible(false);
            this.filterBonded.setVisible(false);
            this.includeClosedPositions.setVisible(false);
            this.includeOverDuePositions.setVisible(false);
        }
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (super.isInnerComponent(c)) {
            return true;
        }
        if (this.deliveryAddresses != null && this.deliveryAddresses.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.deliveryAddresses.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                PurchaseOrderOpenPositionReportConfiguration p = new PurchaseOrderOpenPositionReportConfiguration();
                if (((RadioButton)PrintOrderDailyOpsComponent.this.asPDF.getElement()).isChecked()) {
                    p.setFormat(ReportingOutputFormatE.PDF);
                } else {
                    p.setFormat(ReportingOutputFormatE.XLSX);
                }
                p.setStylesheet(PrintOrderDailyOpsComponent.this.getSelectedReport());
                if (PrintOrderDailyOpsComponent.this.deliveryAddresses != null && ((ComboBox)PrintOrderDailyOpsComponent.this.deliveryAddresses.getElement()).getNode().getValue() != null) {
                    p.setDeliveryAddress((ContactComplete)((ComboBox)PrintOrderDailyOpsComponent.this.deliveryAddresses.getElement()).getNode().getValue());
                }
                p.setPeriod(PrintOrderDailyOpsComponent.this.periodEditor.getPeriod());
                if (PrintOrderDailyOpsComponent.this.includeClosedPositions != null) {
                    p.setOnlyOpenPositions(!((CheckBox)PrintOrderDailyOpsComponent.this.includeClosedPositions.getElement()).isChecked());
                }
                if (PrintOrderDailyOpsComponent.this.includeOverDuePositions != null) {
                    p.setIncludeOverDuePositions(((CheckBox)PrintOrderDailyOpsComponent.this.includeOverDuePositions.getElement()).isChecked());
                }
                if (PrintOrderDailyOpsComponent.this.filterBonded != null) {
                    switch ((BondedStateE)((ComboBox)PrintOrderDailyOpsComponent.this.filterBonded.getElement()).getSelectedItem()) {
                        case ALL: {
                            p.setBonded(null);
                            break;
                        }
                        case ONLY_BONDED: {
                            p.setBonded(Boolean.valueOf(true));
                            break;
                        }
                        case NOT_BONDED: {
                            p.setBonded(Boolean.valueOf(false));
                            break;
                        }
                        default: {
                            p.setBonded(null);
                        }
                    }
                }
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createDailyOpsSheet(p).getValue();
                PrintOrderDailyOpsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintOrderDailyOpsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<PurchaseOrderLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<PurchaseOrderLight> createBatchJob(Node<PurchaseOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public String getTitleString() {
        return Words.ORDER_POSITIONS;
    }

    @Override
    public String getTitleValue() {
        return Words.OPEN_POSITIONS;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.deliveryAddresses);
        CheckedListAdder.addToList(focusList, this.includeClosedPositions);
        CheckedListAdder.addToList(focusList, this.includeOverDuePositions);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.periodEditor != null) {
            this.periodEditor.kill();
        }
        if (this.deliveryAddresses != null) {
            this.deliveryAddresses.kill();
        }
        if (this.filterBonded != null) {
            this.filterBonded.kill();
        }
        if (this.includeClosedPositions != null) {
            this.includeClosedPositions.kill();
        }
        if (this.includeOverDuePositions != null) {
            this.includeOverDuePositions.kill();
        }
        this.periodEditor = null;
        this.deliveryAddresses = null;
        this.filterBonded = null;
        this.includeClosedPositions = null;
        this.includeOverDuePositions = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintOrderDailyOpsComponent.this.getInheritedComponentsHeight();
            h += PrintOrderDailyOpsComponent.this.border;
            h = (int)((double)h + PrintOrderDailyOpsComponent.this.periodEditor.getPreferredSize().getHeight());
            if (PrintOrderDailyOpsComponent.this.deliveryAddresses != null) {
                h += PrintOrderDailyOpsComponent.this.border / 2;
                h = (int)((double)h + PrintOrderDailyOpsComponent.this.deliveryAddresses.getPreferredSize().getHeight());
                h += PrintOrderDailyOpsComponent.this.border;
                h = (int)((double)h + PrintOrderDailyOpsComponent.this.filterBonded.getPreferredSize().getHeight());
                h += PrintOrderDailyOpsComponent.this.border;
                h = (int)((double)h + PrintOrderDailyOpsComponent.this.includeClosedPositions.getPreferredSize().getHeight());
                h += PrintOrderDailyOpsComponent.this.border;
                h = (int)((double)h + PrintOrderDailyOpsComponent.this.includeOverDuePositions.getPreferredSize().getHeight());
            }
            return new Dimension(0, h += PrintOrderDailyOpsComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintOrderDailyOpsComponent.this.layoutInheritedComponents(parent);
            PrintOrderDailyOpsComponent.this.periodEditor.setLocation(PrintOrderDailyOpsComponent.this.border, y += PrintOrderDailyOpsComponent.this.border);
            PrintOrderDailyOpsComponent.this.periodEditor.setSize(PrintOrderDailyOpsComponent.this.periodEditor.getPreferredSize());
            if (PrintOrderDailyOpsComponent.this.deliveryAddresses != null) {
                PrintOrderDailyOpsComponent.this.deliveryAddresses.setLocation(PrintOrderDailyOpsComponent.this.border, PrintOrderDailyOpsComponent.this.periodEditor.getY() + PrintOrderDailyOpsComponent.this.periodEditor.getHeight() + PrintOrderDailyOpsComponent.this.border / 2);
                PrintOrderDailyOpsComponent.this.deliveryAddresses.setSize(parent.getWidth() - 2 * PrintOrderDailyOpsComponent.this.border, (int)PrintOrderDailyOpsComponent.this.deliveryAddresses.getPreferredSize().getHeight());
                PrintOrderDailyOpsComponent.this.filterBonded.setLocation(PrintOrderDailyOpsComponent.this.border, PrintOrderDailyOpsComponent.this.deliveryAddresses.getY() + PrintOrderDailyOpsComponent.this.deliveryAddresses.getHeight() + PrintOrderDailyOpsComponent.this.border / 2);
                PrintOrderDailyOpsComponent.this.filterBonded.setSize(parent.getWidth() - 2 * PrintOrderDailyOpsComponent.this.border, ((PrintOrderDailyOpsComponent)PrintOrderDailyOpsComponent.this).filterBonded.getPreferredSize().height);
                PrintOrderDailyOpsComponent.this.includeClosedPositions.setLocation(PrintOrderDailyOpsComponent.this.border, PrintOrderDailyOpsComponent.this.filterBonded.getY() + PrintOrderDailyOpsComponent.this.filterBonded.getHeight() + PrintOrderDailyOpsComponent.this.border);
                PrintOrderDailyOpsComponent.this.includeClosedPositions.setSize(parent.getWidth() - 2 * PrintOrderDailyOpsComponent.this.border, ((PrintOrderDailyOpsComponent)PrintOrderDailyOpsComponent.this).includeClosedPositions.getPreferredSize().height);
                PrintOrderDailyOpsComponent.this.includeOverDuePositions.setLocation(PrintOrderDailyOpsComponent.this.border, PrintOrderDailyOpsComponent.this.includeClosedPositions.getY() + PrintOrderDailyOpsComponent.this.includeClosedPositions.getHeight() + PrintOrderDailyOpsComponent.this.border);
                PrintOrderDailyOpsComponent.this.includeOverDuePositions.setSize(parent.getWidth() - 2 * PrintOrderDailyOpsComponent.this.border, ((PrintOrderDailyOpsComponent)PrintOrderDailyOpsComponent.this).includeOverDuePositions.getPreferredSize().height);
            }
        }
    }
}

