/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.positionsdetails;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.AsynchronusAnalysisPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.analysis.PurchaseDetailsAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;

public class PositionsDetailsAnalysisComponent
extends AsynchronusAnalysisPopupInsert<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> filterBonded;

    public PositionsDetailsAnalysisComponent(AnalysisSmartExternalOpenTool<PurchaseOrderLight> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        this.filterBonded = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(BondedStateE.class), (Converter)new Converter<BondedStateE, String>(){

            public String convert(BondedStateE o, Node<BondedStateE> currentNode, Object ... param) {
                switch (o) {
                    case ALL: {
                        return Words.ALL_ORDERS;
                    }
                    case ONLY_BONDED: {
                        return Words.ORDERS_WITH_BONDED;
                    }
                    case NOT_BONDED: {
                        return Words.ORDERS_WITHOUT_BONDED;
                    }
                }
                return "";
            }

            public Class<? extends BondedStateE> getParameterClass() {
                return BondedStateE.class;
            }
        }), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new ComboBoxAnalysisItem(this.filterBonded, "bonded"));
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        PurchaseDetailsAnalysisReportConfiguration a = new PurchaseDetailsAnalysisReportConfiguration();
        BondedStateE bondedState = (BondedStateE)((Node)this.filterBonded.getElement().getSelectedItem()).getValue();
        a.setReportFormatType(ReportingOutputFormatE.XLSX);
        switch (bondedState) {
            case ALL: {
                a.setBondedState(null);
                break;
            }
            case NOT_BONDED: {
                a.setBondedState(Boolean.valueOf(false));
                break;
            }
            case ONLY_BONDED: {
                a.setBondedState(Boolean.valueOf(true));
                break;
            }
        }
        return a;
    }
}

