/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.recipe.transaction;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.RecipeReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;

public class RecipeTransactionsAnalysisComponent
extends DefaultServerSideAnalysisComponent<RecipeComplete, RecipeReference> {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor period;

    public RecipeTransactionsAnalysisComponent(AnalysisSmartExternalOpenTool<RecipeComplete> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        PeriodComplete p = new PeriodComplete();
        p.setStartDate(new Date(System.currentTimeMillis()));
        p.setEndDate(new Date(System.currentTimeMillis()));
        Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.period = new TitledPeriodEditor((Node<Date>)periodNode.getChildNamed(PeriodComplete_.startDate), (Node<Date>)periodNode.getChildNamed(PeriodComplete_.endDate), true, null);
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.period, "period"));
    }

    @Override
    public String getTitleString() {
        return Words.TRANSACTIONS;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public RecipeReference createReference(RecipeComplete item) {
        return new RecipeReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        PeriodComplete selectedPeriod = this.period.getPeriod();
        ArrayList<RecipeReference> references = new ArrayList<RecipeReference>();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(this.createReference((RecipeComplete)s.next()));
        }
        PegasusFileComplete file = (PegasusFileComplete)((RecipeReportServiceManager)ServiceManagerRegistry.getService(RecipeReportServiceManager.class)).createTransactionReport(new ListWrapper(references), selectedPeriod).getValue();
        return file;
    }
}

