/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.recipecard;

import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.print.product.recipecard.ReformulateConverter;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.report.ProductRecipeSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductRecipeSheetReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PrintProductRecipeCardComponent
extends DefaultScrollablePrintPopup2<ProductComplete>
implements ButtonListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductComplete> currentProduct;
    private final Node configNode;
    private boolean isNoPro;
    private TitledItem<DateChooser> dueDate;
    private HorizontalSeparator sep5;
    private TextLabel printOptionTitle;
    private TitledItem<CheckBox> includeCosts;
    private TitledItem<CheckBox> includeGross;
    private TitledItem<CheckBox> includeAllergens;
    private TitledItem<CheckBox> includeTraces;
    private TitledItem<CheckBox> includeAdditives;
    private TitledItem<CheckBox> includeOthers;
    private TitledItem<CheckBox> includeImage;
    private TitledItem<CheckBox> includePurchaseWaste;
    private TitledItem<TextLabel> reformulate;
    private TitledItem<CheckBox> checkRecalc;
    private ArrowConnectorIcon connector;
    private TextLabel targetText;
    private TextField targetAmount;
    private HorizontalSeparator sep6;
    private TitledItem<TitledItem<CheckBox>> selectAll;
    private Table2 table;
    private boolean showProductionCosts;

    public PrintProductRecipeCardComponent(Node<ProductComplete> node) {
        super(false, false, ReportTypeE.RECIPECARD);
        this.currentProduct = node;
        Runnable r = () -> {
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            ModuleAccessRightComplete r1 = HUDToolkit.getCurrentAccessRight(ProductAccess.MODULE_PRODUCT, user);
            for (DataFieldAccessRightComplete a : r1.getFieldAccessRights()) {
                if (!a.getField().getName().equals(ProductAccess.SHOW_PRODUCTION_COSTS.getFieldName())) continue;
                this.showProductionCosts = true;
            }
            ProductComplete p = (ProductComplete)this.currentProduct.getValue();
            try {
                List ret = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantsByReferences(new ListWrapper(p.getVariants())).getList();
                ArrayList refs = new ArrayList();
                refs.addAll(ret);
                this.currentProduct.getChildNamed(ProductComplete_.variants).removeExistingValues();
                this.currentProduct.getChildNamed(ProductComplete_.variants).setValue(refs, 0L);
                this.currentProduct.getChildNamed(ProductComplete_.variants).updateNode();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        };
        this.loadBeforeShowing(r);
        ProductRecipeSheetReportConfiguration config = new ProductRecipeSheetReportConfiguration(null);
        config.setTargetCount(Integer.valueOf(1));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        if (this.isNoPro) {
            return;
        }
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "costs": {
                    this.includeCosts.getElement().setChecked(b != false && this.showProductionCosts);
                    break;
                }
                case "allergens": {
                    this.includeAllergens.getElement().setChecked(b);
                    break;
                }
                case "additives": {
                    this.includeAdditives.getElement().setChecked(b);
                    break;
                }
                case "traces": {
                    this.includeTraces.getElement().setChecked(b);
                    break;
                }
                case "others": {
                    this.includeOthers.getElement().setChecked(b);
                    break;
                }
                case "brutto": {
                    this.includeGross.getElement().setChecked(b);
                    break;
                }
                case "image": {
                    this.includeImage.getElement().setChecked(b);
                    break;
                }
                case "waste": {
                    this.includePurchaseWaste.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        if (this.isNoPro) {
            return null;
        }
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("costs", "" + this.includeCosts.getElement().isChecked());
        conf.addProperty("allergens", "" + this.includeAllergens.getElement().isChecked());
        conf.addProperty("additives", "" + this.includeAdditives.getElement().isChecked());
        conf.addProperty("traces", "" + this.includeTraces.getElement().isChecked());
        conf.addProperty("others", "" + this.includeOthers.getElement().isChecked());
        conf.addProperty("brutto", "" + this.includeGross.getElement().isChecked());
        conf.addProperty("image", "" + this.includeImage.getElement().isChecked());
        conf.addProperty("waste", "" + this.includePurchaseWaste.getElement().isChecked());
        return conf;
    }

    @Override
    public void insertElements() {
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.dueDate).setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.dueDate)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.dueDate).addNodeListener((NodeListener)this);
        if (!this.isNoPro) {
            this.sep5 = new HorizontalSeparator();
            this.printOptionTitle = new TextLabel(Words.OPTIONS);
            this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
            this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
            this.includeCosts = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.includeCost)), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.includeCosts.setTitleFont(f);
            this.includeCosts.setTitleForeground(fb);
            this.includeCosts.getElement().setChecked(this.showProductionCosts);
            this.includeGross = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.includeBrutto)), Words.INCLUDE_GROSS, TitledItem.TitledItemOrientation.EAST);
            this.includeGross.setTitleFont(f);
            this.includeGross.setTitleForeground(fb);
            this.includeGross.getElement().setChecked(true);
            this.includeAllergens = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ALLERGENS, TitledItem.TitledItemOrientation.EAST);
            this.includeAllergens.setTitleFont(f);
            this.includeAllergens.setTitleForeground(fb);
            this.includeAllergens.getElement().setChecked(true);
            this.includeTraces = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_TRACES, TitledItem.TitledItemOrientation.EAST);
            this.includeTraces.setTitleFont(f);
            this.includeTraces.setTitleForeground(fb);
            this.includeTraces.getElement().setChecked(true);
            this.includeAdditives = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ADDITIVES, TitledItem.TitledItemOrientation.EAST);
            this.includeAdditives.setTitleFont(f);
            this.includeAdditives.setTitleForeground(fb);
            this.includeAdditives.getElement().setChecked(true);
            this.includeOthers = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_OTHER_DECLARATION, TitledItem.TitledItemOrientation.EAST);
            this.includeOthers.setTitleFont(f);
            this.includeOthers.setTitleForeground(fb);
            this.includeOthers.getElement().setChecked(true);
            this.includeImage = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.includeImage)), Words.INCLUDE_IMAGE, TitledItem.TitledItemOrientation.EAST);
            this.includeImage.setTitleFont(f);
            this.includeImage.setTitleForeground(fb);
            this.includeImage.getElement().setChecked(true);
            this.includePurchaseWaste = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.includePurchaseWaste)), Words.INCLUDE_PURCHASE_WASTE, TitledItem.TitledItemOrientation.EAST);
            this.includePurchaseWaste.setTitleFont(f);
            this.includePurchaseWaste.setTitleForeground(fb);
            this.includePurchaseWaste.getElement().setChecked(true);
            this.reformulate = new TitledItem<TextLabel>(new TextLabel(this.currentProduct, ConverterRegistry.getConverter(ReformulateConverter.class)), Words.REFORMULATE, TitledItem.TitledItemOrientation.NORTH);
            this.checkRecalc = new TitledItem<CheckBox>(new CheckBox(), Words.RECALCULATE, TitledItem.TitledItemOrientation.EAST);
            this.checkRecalc.setInnerGap(5);
            this.checkRecalc.getTitle().setFont(f);
            this.checkRecalc.getTitle().setForeground(fb);
            this.connector = new ArrowConnectorIcon();
            this.targetText = new TextLabel(Words.TARGET);
            this.targetAmount = new NumberTextField(this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.targetCount), TextFieldType.INT);
            this.targetAmount.setEnabled(false);
            this.checkRecalc.getElement().addButtonListener(this);
            this.sep6 = new HorizontalSeparator();
            TitledItem<CheckBox> sb = new TitledItem<CheckBox>(new CheckBox(), Words.SELECT_ALL, TitledItem.TitledItemOrientation.EAST);
            sb.getTitle().setFont(f);
            sb.getTitle().setForeground(fb);
            sb.setInnerGap(5);
            sb.getElement().addButtonListener(this);
            this.selectAll = new TitledItem<TitledItem<CheckBox>>(sb, Words.RECIPE_SELECTION, TitledItem.TitledItemOrientation.NORTH);
            this.selectAll.getElement().getElement().addButtonListener(this);
            this.table = new Table2(false, "", true, false);
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            int tw = 60;
            columns.add(new TableColumnInfo(Words.PRINT, null, null, null, "", tw, tw, tw));
            columns.add(new TableColumnInfo(Words.RECIPE, null, null, null, "", 30, 30, 30));
            ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
            this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        }
        this.valueChanged(this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.dueDate));
        this.getViewContainer().add(this.dueDate);
        if (!this.isNoPro) {
            this.getViewContainer().add(this.sep5);
            this.getViewContainer().add(this.printOptionTitle);
            this.getViewContainer().add(this.includeCosts);
            this.getViewContainer().add(this.includeAllergens);
            this.getViewContainer().add(this.includeAdditives);
            this.getViewContainer().add(this.includeTraces);
            this.getViewContainer().add(this.includeOthers);
            this.getViewContainer().add(this.includeGross);
            this.getViewContainer().add(this.includeImage);
            this.getViewContainer().add(this.includePurchaseWaste);
            this.getViewContainer().add(this.reformulate);
            this.getViewContainer().add(this.checkRecalc);
            this.getViewContainer().add(this.connector);
            this.getViewContainer().add(this.targetText);
            this.getViewContainer().add(this.targetAmount);
            this.getViewContainer().add(this.sep6);
            this.getViewContainer().add(this.selectAll);
            this.getViewContainer().add(this.table);
        }
    }

    private void reloadRecipes(final Node e) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = e;
                Node dd = PrintProductRecipeCardComponent.this.configNode.getChildNamed(ProductRecipeSheetReportConfiguration_.dueDate);
                Map ids = ((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getSubRecipes((ProductReference)PrintProductRecipeCardComponent.this.currentProduct.getValue(), new TimestampWrapper((Timestamp)dd.getValue())).getMap();
                Node idNode = PrintProductRecipeCardComponent.this.currentProduct.getChildNamed(new String[]{"suprecipes"});
                if (idNode == null) {
                    idNode = new Node();
                    idNode.setName("suprecipes");
                    PrintProductRecipeCardComponent.this.currentProduct.addChild(idNode, 0L);
                }
                idNode.removeExistingValues();
                idNode.setValue((Object)ids, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (PrintProductRecipeCardComponent.this.isKilled()) {
                            return;
                        }
                        PrintProductRecipeCardComponent.this.updateRecipeTable();
                        PrintProductRecipeCardComponent.this.ensureSelectAllState();
                    }

                    public void errorOccurred(ClientException exception) {
                        PrintProductRecipeCardComponent.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void updateRecipeTable() {
        if (!this.isNoPro) {
            this.table.getModel().setNode(this.createRecipeList());
        }
    }

    private Node createRecipeList() {
        ViewNode list = new ViewNode("List");
        Node n = this.currentProduct.getChildNamed(new String[]{"suprecipes"});
        if (n != null) {
            for (Map.Entry e : ((Map)n.getValue()).entrySet()) {
                ViewNode nn = new ViewNode("");
                nn.setValue(e, 0L);
                list.addChild((Node)nn, 0L);
            }
        }
        return list;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
        if (!this.isNoPro) {
            this.sep5.setEnabled(isEnabled);
            this.printOptionTitle.setEnabled(isEnabled);
            this.includeCosts.setEnabled(isEnabled && this.showProductionCosts);
            this.includeGross.setEnabled(isEnabled);
            this.includeAllergens.setEnabled(isEnabled);
            this.includeAdditives.setEnabled(isEnabled);
            this.includeTraces.setEnabled(isEnabled);
            this.includeOthers.setEnabled(isEnabled);
            this.includeImage.setEnabled(isEnabled);
            this.includePurchaseWaste.setEnabled(isEnabled);
            this.reformulate.setEnabled(isEnabled);
            this.checkRecalc.setEnabled(isEnabled);
            this.connector.setEnabled(isEnabled);
            this.targetText.setEnabled(isEnabled);
            this.targetAmount.setEnabled(isEnabled);
            this.sep6.setEnabled(isEnabled);
            this.selectAll.setEnabled(isEnabled);
            this.table.setEnabled(isEnabled);
        }
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_RECIPE_SHEET;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(new DtoField[]{ProductComplete_.currentVariant, ProductVariantLight_.name}).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        this.dueDate = null;
        if (this.sep5 != null) {
            this.sep5.kill();
        }
        this.sep5 = null;
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        this.printOptionTitle = null;
        if (this.includeCosts != null) {
            this.includeCosts.kill();
        }
        this.includeCosts = null;
        if (this.includeAllergens != null) {
            this.includeAllergens.kill();
        }
        this.includeAllergens = null;
        if (this.includeAdditives != null) {
            this.includeAdditives.kill();
        }
        this.includeAdditives = null;
        if (this.includeTraces != null) {
            this.includeTraces.kill();
        }
        this.includeTraces = null;
        if (this.includeOthers != null) {
            this.includeOthers.kill();
        }
        this.includeOthers = null;
        if (this.includeGross != null) {
            this.includeGross.kill();
        }
        this.includeGross = null;
        if (this.includeImage != null) {
            this.includeImage.kill();
        }
        this.includeImage = null;
        if (this.reformulate != null) {
            this.reformulate.kill();
        }
        this.reformulate = null;
        if (this.checkRecalc != null) {
            this.checkRecalc.kill();
        }
        this.checkRecalc = null;
        if (this.connector != null) {
            this.connector.kill();
        }
        this.connector = null;
        if (this.targetText != null) {
            this.targetText.kill();
        }
        this.targetText = null;
        if (this.targetAmount != null) {
            this.targetAmount.kill();
        }
        this.targetAmount = null;
        if (this.sep6 != null) {
            this.sep6.kill();
        }
        this.sep6 = null;
        if (this.selectAll != null) {
            this.selectAll.kill();
        }
        this.selectAll = null;
        if (this.table != null) {
            this.table.kill();
        }
        this.table = null;
        if (this.includePurchaseWaste != null) {
            this.includePurchaseWaste.kill();
        }
        this.includePurchaseWaste = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.dueDate.setVisible(true);
        if (!this.isNoPro) {
            this.sep5.setVisible(true);
            this.printOptionTitle.setVisible(true);
            this.includeGross.setVisible(true);
            this.includeAllergens.setVisible(true);
            this.includeTraces.setVisible(true);
            this.includeAdditives.setVisible(true);
            this.includeOthers.setVisible(true);
            this.includeCosts.setVisible(true);
            this.includeImage.setVisible(true);
            this.includePurchaseWaste.setVisible(true);
            this.reformulate.setVisible(true);
            this.checkRecalc.setVisible(true);
            this.connector.setVisible(true);
            this.targetText.setVisible(true);
            this.targetAmount.setVisible(true);
            this.sep6.setVisible(true);
            this.selectAll.setVisible(true);
            this.table.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.dueDate.setVisible(false);
        if (!this.isNoPro) {
            this.sep5.setVisible(false);
            this.printOptionTitle.setVisible(false);
            this.includeGross.setVisible(false);
            this.includeAllergens.setVisible(false);
            this.includeTraces.setVisible(false);
            this.includeAdditives.setVisible(false);
            this.includeOthers.setVisible(false);
            this.includeCosts.setVisible(false);
            this.includeImage.setVisible(false);
            this.includePurchaseWaste.setVisible(false);
            this.reformulate.setVisible(false);
            this.checkRecalc.setVisible(false);
            this.connector.setVisible(false);
            this.targetText.setVisible(false);
            this.targetAmount.setVisible(false);
            this.sep6.setVisible(false);
            this.selectAll.setVisible(false);
            this.table.setVisible(false);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.selectAll.getElement().getElement()) {
            if (this.selectAll.getElement().getElement().isChecked()) {
                for (Table2RowPanel p : this.table.getRows()) {
                    TableRowImpl l = (TableRowImpl)p;
                    l.selectCheckBox();
                }
            } else {
                for (Table2RowPanel p : this.table.getRows()) {
                    TableRowImpl l = (TableRowImpl)p;
                    l.deselectBox();
                }
            }
            this.ensureSelectAllState();
        } else if (source == this.checkRecalc.getElement()) {
            this.targetAmount.setEnabled(this.checkRecalc.getElement().isChecked());
        }
    }

    private void ensureSelectAllState() {
        if (!this.isNoPro) {
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl i = (TableRowImpl)p;
                if (i.isChecked()) continue;
                this.selectAll.getElement().getElement().setChecked(false);
                return;
            }
            if (this.table.getRows().size() == 0) {
                this.selectAll.setEnabled(false);
                this.table.setEnabled(false);
            } else {
                this.selectAll.setEnabled(true);
                this.table.setEnabled(true);
            }
            this.selectAll.getElement().getElement().setChecked(true);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintProductRecipeCardComponent.this.getSelectedReport();
                if (file == null) {
                    throw new ClientCreateReportException("Report not loaded correctly. Please reopen Tool.", null);
                }
                PrintProductRecipeCardComponent.this.configNode.commit();
                ProductRecipeSheetReportConfiguration config = (ProductRecipeSheetReportConfiguration)PrintProductRecipeCardComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (!PrintProductRecipeCardComponent.this.isNoPro) {
                    config.setIncludeAllergens(Boolean.valueOf(((CheckBox)PrintProductRecipeCardComponent.this.includeAllergens.getElement()).isChecked()));
                    config.setIncludeTraces(Boolean.valueOf(((CheckBox)PrintProductRecipeCardComponent.this.includeTraces.getElement()).isChecked()));
                    config.setIncludeAdditives(Boolean.valueOf(((CheckBox)PrintProductRecipeCardComponent.this.includeAdditives.getElement()).isChecked()));
                    config.setIncludeOthers(Boolean.valueOf(((CheckBox)PrintProductRecipeCardComponent.this.includeOthers.getElement()).isChecked()));
                    config.setIncludeNetto(Boolean.valueOf(true));
                    Iterator it = PrintProductRecipeCardComponent.this.table.getModel().getNode().getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        config.getSubRecipes().add(new RecipeReference((Long)((Map.Entry)n.getValue()).getKey()));
                    }
                } else {
                    config.setIncludeAllergens(Boolean.valueOf(false));
                    config.setIncludeTraces(Boolean.valueOf(false));
                    config.setIncludeAdditives(Boolean.valueOf(false));
                    config.setIncludeOthers(Boolean.valueOf(false));
                    config.setIncludeNetto(Boolean.valueOf(true));
                }
                ProductReference productRef = new ProductReference(((ProductComplete)PrintProductRecipeCardComponent.this.currentProduct.getValue()).getId());
                PegasusFileComplete t = null;
                t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductRecipeCard(productRef, config).getValue();
                PrintProductRecipeCardComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductRecipeCardComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductComplete> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ProductComplete> createBatchJob(Node<ProductComplete> value, ThreadSafeExecutable job) {
        return null;
    }

    public void valueChanged(Node<?> node) {
        this.reloadRecipes(node);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private CheckBox print;
        private TextLabel label;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.print = new CheckBox();
            this.print.setChecked(true);
            this.label = new TextLabel((String)((Map.Entry)m.getNode().getValue()).getValue());
            this.print.addButtonListener(this);
            this.print.setProgress(1.0f);
            this.label.setProgress(1.0f);
            this.setLayout(new InnerLayout());
            this.add(this.print);
            this.add(this.label);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.print.getStringValue();
                }
                case 1: {
                    return this.label.getText();
                }
            }
            return null;
        }

        public Long getCurrentId() {
            if (this.print.isChecked()) {
                return (Long)((Map.Entry)this.model.getNode().getValue()).getKey();
            }
            return null;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.print.kill();
            this.print = null;
            this.label.kill();
            this.label = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.print.setEnabled(isEnabled);
            this.label.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.print.getFocusComponents();
        }

        public void deselectBox() {
            this.print.setChecked(false);
        }

        public void selectCheckBox() {
            this.print.setChecked(true);
        }

        public boolean isChecked() {
            return this.print.isChecked();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            PrintProductRecipeCardComponent.this.ensureSelectAllState();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.print.setLocation((int)((double)w - TableRowImpl.this.print.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - TableRowImpl.this.print.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.print.setSize(TableRowImpl.this.print.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.label.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.label.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.label.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.label.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductRecipeCardComponent.this.layoutInheritedComponents(parent);
            if (PrintProductRecipeCardComponent.this.dueDate != null) {
                PrintProductRecipeCardComponent.this.dueDate.setLocation(PrintProductRecipeCardComponent.this.border, y + PrintProductRecipeCardComponent.this.border);
                PrintProductRecipeCardComponent.this.dueDate.setSize(parent.getWidth() - 2 * PrintProductRecipeCardComponent.this.border, (int)PrintProductRecipeCardComponent.this.dueDate.getPreferredSize().getHeight());
                y = PrintProductRecipeCardComponent.this.dueDate.getY() + PrintProductRecipeCardComponent.this.dueDate.getHeight();
                if (!PrintProductRecipeCardComponent.this.isNoPro) {
                    if (PrintProductRecipeCardComponent.this.sep5 != null) {
                        PrintProductRecipeCardComponent.this.sep5.setLocation(0, y + PrintProductRecipeCardComponent.this.border / 2);
                        PrintProductRecipeCardComponent.this.sep5.setSize(parent.getWidth(), (int)PrintProductRecipeCardComponent.this.sep5.getPreferredSize().getHeight());
                        y = PrintProductRecipeCardComponent.this.sep5.getY() + PrintProductRecipeCardComponent.this.sep5.getHeight();
                    }
                    PrintProductRecipeCardComponent.this.printOptionTitle.setLocation(PrintProductRecipeCardComponent.this.border, y + PrintProductRecipeCardComponent.this.border);
                    PrintProductRecipeCardComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintProductRecipeCardComponent.this.border, (int)PrintProductRecipeCardComponent.this.printOptionTitle.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.includeCosts.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.printOptionTitle.getY() + PrintProductRecipeCardComponent.this.printOptionTitle.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.includeCosts.setSize(parent.getWidth() - 2 * PrintProductRecipeCardComponent.this.border, (int)PrintProductRecipeCardComponent.this.includeCosts.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.includeAllergens.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.includeCosts.getY() + PrintProductRecipeCardComponent.this.includeCosts.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.includeAllergens.setSize((parent.getWidth() - 3 * PrintProductRecipeCardComponent.this.border) / 2, (int)PrintProductRecipeCardComponent.this.includeAllergens.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.includeTraces.setLocation(PrintProductRecipeCardComponent.this.includeAllergens.getX() + PrintProductRecipeCardComponent.this.includeAllergens.getWidth() + PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.includeCosts.getY() + PrintProductRecipeCardComponent.this.includeCosts.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.includeTraces.setSize((parent.getWidth() - 3 * PrintProductRecipeCardComponent.this.border) / 2, (int)PrintProductRecipeCardComponent.this.includeTraces.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.includeAdditives.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.includeAllergens.getY() + PrintProductRecipeCardComponent.this.includeAllergens.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.includeAdditives.setSize((parent.getWidth() - 3 * PrintProductRecipeCardComponent.this.border) / 2, (int)PrintProductRecipeCardComponent.this.includeAdditives.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.includeOthers.setLocation(PrintProductRecipeCardComponent.this.includeTraces.getX(), PrintProductRecipeCardComponent.this.includeAllergens.getY() + PrintProductRecipeCardComponent.this.includeAllergens.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.includeOthers.setSize((parent.getWidth() - 3 * PrintProductRecipeCardComponent.this.border) / 2, (int)PrintProductRecipeCardComponent.this.includeOthers.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.includeGross.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.includeAdditives.getY() + PrintProductRecipeCardComponent.this.includeAdditives.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.includeGross.setSize(parent.getWidth() - 2 * PrintProductRecipeCardComponent.this.border, (int)PrintProductRecipeCardComponent.this.includeGross.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.includeImage.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.includeGross.getY() + PrintProductRecipeCardComponent.this.includeGross.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.includeImage.setSize(parent.getWidth() - 2 * PrintProductRecipeCardComponent.this.border, (int)PrintProductRecipeCardComponent.this.includeImage.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.includePurchaseWaste.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.includeImage.getY() + PrintProductRecipeCardComponent.this.includeImage.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.includePurchaseWaste.setSize(parent.getWidth() - 2 * PrintProductRecipeCardComponent.this.border, (int)PrintProductRecipeCardComponent.this.includePurchaseWaste.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.reformulate.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.includePurchaseWaste.getY() + PrintProductRecipeCardComponent.this.includePurchaseWaste.getHeight() + PrintProductRecipeCardComponent.this.border);
                    PrintProductRecipeCardComponent.this.reformulate.setSize(parent.getWidth() - 2 * PrintProductRecipeCardComponent.this.border, (int)PrintProductRecipeCardComponent.this.reformulate.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.checkRecalc.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.reformulate.getY() + PrintProductRecipeCardComponent.this.reformulate.getHeight() + PrintProductRecipeCardComponent.this.border / 2);
                    PrintProductRecipeCardComponent.this.checkRecalc.setSize(PrintProductRecipeCardComponent.this.checkRecalc.getPreferredSize());
                    PrintProductRecipeCardComponent.this.connector.setLocation(PrintProductRecipeCardComponent.this.checkRecalc.getX() + PrintProductRecipeCardComponent.this.checkRecalc.getWidth() + 20, (int)((double)PrintProductRecipeCardComponent.this.checkRecalc.getY() + (PrintProductRecipeCardComponent.this.checkRecalc.getPreferredSize().getHeight() - PrintProductRecipeCardComponent.this.connector.getPreferredSize().getHeight()) / 2.0) - 4);
                    PrintProductRecipeCardComponent.this.connector.setSize(PrintProductRecipeCardComponent.this.connector.getPreferredSize());
                    PrintProductRecipeCardComponent.this.targetText.setLocation(PrintProductRecipeCardComponent.this.connector.getX() + PrintProductRecipeCardComponent.this.connector.getWidth() + 20, (int)((double)PrintProductRecipeCardComponent.this.checkRecalc.getY() + (PrintProductRecipeCardComponent.this.checkRecalc.getPreferredSize().getHeight() - PrintProductRecipeCardComponent.this.targetText.getPreferredSize().getHeight()) / 2.0) - 4);
                    PrintProductRecipeCardComponent.this.targetText.setSize(PrintProductRecipeCardComponent.this.targetText.getPreferredSize());
                    PrintProductRecipeCardComponent.this.targetAmount.setLocation(PrintProductRecipeCardComponent.this.targetText.getX() + PrintProductRecipeCardComponent.this.targetText.getWidth() + 20, (int)((double)PrintProductRecipeCardComponent.this.checkRecalc.getY() + (PrintProductRecipeCardComponent.this.checkRecalc.getPreferredSize().getHeight() - PrintProductRecipeCardComponent.this.targetAmount.getPreferredSize().getHeight()) / 2.0) - 4);
                    PrintProductRecipeCardComponent.this.targetAmount.setSize(PrintProductRecipeCardComponent.this.targetAmount.getPreferredSize());
                    PrintProductRecipeCardComponent.this.sep6.setLocation(0, PrintProductRecipeCardComponent.this.targetAmount.getY() + PrintProductRecipeCardComponent.this.targetAmount.getHeight() + PrintProductRecipeCardComponent.this.border);
                    PrintProductRecipeCardComponent.this.sep6.setSize(parent.getWidth(), (int)PrintProductRecipeCardComponent.this.sep6.getPreferredSize().getHeight());
                    PrintProductRecipeCardComponent.this.selectAll.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.sep6.getY() + PrintProductRecipeCardComponent.this.sep6.getHeight() + PrintProductRecipeCardComponent.this.border);
                    PrintProductRecipeCardComponent.this.selectAll.setSize(PrintProductRecipeCardComponent.this.selectAll.getPreferredSize());
                    PrintProductRecipeCardComponent.this.table.setLocation(PrintProductRecipeCardComponent.this.border, PrintProductRecipeCardComponent.this.selectAll.getY() + PrintProductRecipeCardComponent.this.selectAll.getHeight() + PrintProductRecipeCardComponent.this.border);
                    PrintProductRecipeCardComponent.this.table.setSize(parent.getWidth() - 2 * PrintProductRecipeCardComponent.this.border, parent.getHeight() - (PrintProductRecipeCardComponent.this.table.getY() + PrintProductRecipeCardComponent.this.border));
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductRecipeCardComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintProductRecipeCardComponent.this.dueDate != null) {
                h += PrintProductRecipeCardComponent.this.border;
                h = (int)((double)h + PrintProductRecipeCardComponent.this.dueDate.getPreferredSize().getHeight());
                h += PrintProductRecipeCardComponent.this.border / 2;
                if (!PrintProductRecipeCardComponent.this.isNoPro) {
                    h = (int)((double)h + PrintProductRecipeCardComponent.this.sep5.getPreferredSize().getHeight());
                    h += PrintProductRecipeCardComponent.this.border;
                    h = (int)((double)h + PrintProductRecipeCardComponent.this.printOptionTitle.getPreferredSize().getHeight());
                    h += PrintProductRecipeCardComponent.this.border / 2;
                    h = (int)((double)h + PrintProductRecipeCardComponent.this.includeCosts.getPreferredSize().getHeight());
                    h += PrintProductRecipeCardComponent.this.border / 2;
                    h = (int)((double)h + PrintProductRecipeCardComponent.this.includeAllergens.getPreferredSize().getHeight());
                    h += PrintProductRecipeCardComponent.this.border / 2;
                    h = (int)((double)h + PrintProductRecipeCardComponent.this.includeAdditives.getPreferredSize().getHeight());
                    h += PrintProductRecipeCardComponent.this.border / 2;
                    h = (int)((double)h + PrintProductRecipeCardComponent.this.includeGross.getPreferredSize().getHeight());
                    h += PrintProductRecipeCardComponent.this.border / 2;
                    h = (int)((double)h + PrintProductRecipeCardComponent.this.includeImage.getPreferredSize().getHeight());
                    h += PrintProductRecipeCardComponent.this.border;
                    h = (int)((double)h + PrintProductRecipeCardComponent.this.includePurchaseWaste.getPreferredSize().getHeight());
                    h += PrintProductRecipeCardComponent.this.border;
                    h = (int)((double)h + (PrintProductRecipeCardComponent.this.reformulate.getPreferredSize().getHeight() + (double)PrintProductRecipeCardComponent.this.border));
                    h = (int)((double)h + (PrintProductRecipeCardComponent.this.checkRecalc.getPreferredSize().getHeight() + (double)PrintProductRecipeCardComponent.this.border));
                    h = (int)((double)h + (PrintProductRecipeCardComponent.this.sep6.getPreferredSize().getHeight() + (double)PrintProductRecipeCardComponent.this.border));
                    h = (int)((double)h + (PrintProductRecipeCardComponent.this.selectAll.getPreferredSize().getHeight() + (double)PrintProductRecipeCardComponent.this.border));
                    h += 200;
                }
            }
            return new Dimension(w, h);
        }
    }
}

