/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.productcatalog.ais;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.print.flight.allergeninfosheet.PrintAllergenInfoSheetComponent;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.CatalogEntryComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight_;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.exception.ValidationException;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.util.ArrayList;

public class PrintProductCatalogAISComponent
extends DefaultScrollablePrintPopup2<ProductCatalogLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final Node<ProductCatalogLight> currentProduct;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> includeAllergenCodeIndex;

    public PrintProductCatalogAISComponent(Node<ProductCatalogLight> node) {
        super(false, false, PrintAllergenInfoSheetComponent.showImage((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()) ? ReportTypeE.FLIGHT_ALLERGEN_DETAILS_SHEET_WITHIMAGE : ReportTypeE.FLIGHT_ALLERGEN_DETAILS_SHEET_WITHOUTIMAGE);
        this.currentProduct = node;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        Date d = new Date(System.currentTimeMillis());
        Node nd = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(nd), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        this.includeAllergenCodeIndex = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALLERGEN_CODE_INDEX, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.dueDate);
        this.getViewContainer().add(this.includeAllergenCodeIndex);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
        this.includeAllergenCodeIndex.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("dueDate")) {
                this.dueDate.getElement().loadState(v, "dueDate");
                continue;
            }
            if (!n.equals("includeAllergenCodeIndex")) continue;
            this.includeAllergenCodeIndex.getElement().loadState(v, "includeAllergenCodeIndex");
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("dueDate", "" + ((Date)this.dueDate.getElement().getNode().getValue()).getTime());
        conf.addProperty("includeAllergenCodeIndex", "" + this.includeAllergenCodeIndex.getElement().isChecked());
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.PRODUCT_ALLERGEN_INFO__SHEET;
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentProduct.getChildNamed(ProductCatalogLight_.title).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        this.dueDate = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.includeAllergenCodeIndex != null) {
            this.includeAllergenCodeIndex.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.includeAllergenCodeIndex != null) {
            this.includeAllergenCodeIndex.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductCatalogLight productRef = (ProductCatalogLight)PrintProductCatalogAISComponent.this.currentProduct.getValue();
                Date ts = (Date)((DateChooser)PrintProductCatalogAISComponent.this.dueDate.getElement()).getNode().getValue();
                ArrayList<ProductComplete> pList = new ArrayList<ProductComplete>();
                ProductCatalogComplete cc = (ProductCatalogComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductCatalog(new ProductCatalogReference(productRef.getId())).getValue();
                for (ProductCatalogProductGroupComplete g : cc.getGroups()) {
                    for (CatalogEntryComplete e : g.getEntries()) {
                        pList.add(e.getProduct());
                    }
                }
                PegasusFileComplete t = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getProductAllergenInfoSheet(new ListWrapper(pList), new DateWrapper(ts), ((CheckBox)PrintProductCatalogAISComponent.this.includeAllergenCodeIndex.getElement()).isChecked(), PrintProductCatalogAISComponent.this.getSelectedReport()).getValue();
                if (t == null) {
                    throw new ValidationException(Words.NO_ALLERGENS_FOUND);
                }
                PrintProductCatalogAISComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintProductCatalogAISComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<ProductCatalogLight> getCurrentNode() {
        return this.currentProduct;
    }

    @Override
    public BatchJob<ProductCatalogLight> createBatchJob(Node<ProductCatalogLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintProductCatalogAISComponent.this.layoutInheritedComponents(parent);
            if (PrintProductCatalogAISComponent.this.dueDate != null) {
                PrintProductCatalogAISComponent.this.dueDate.setLocation(PrintProductCatalogAISComponent.this.border, y + PrintProductCatalogAISComponent.this.border / 2);
                PrintProductCatalogAISComponent.this.dueDate.setSize(parent.getWidth() - 2 * PrintProductCatalogAISComponent.this.border, (int)PrintProductCatalogAISComponent.this.dueDate.getPreferredSize().getHeight());
                y = PrintProductCatalogAISComponent.this.dueDate.getY() + PrintProductCatalogAISComponent.this.dueDate.getHeight();
            }
            if (PrintProductCatalogAISComponent.this.includeAllergenCodeIndex != null) {
                PrintProductCatalogAISComponent.this.includeAllergenCodeIndex.setLocation(PrintProductCatalogAISComponent.this.border, y + PrintProductCatalogAISComponent.this.border / 2);
                PrintProductCatalogAISComponent.this.includeAllergenCodeIndex.setSize(PrintProductCatalogAISComponent.this.includeAllergenCodeIndex.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintProductCatalogAISComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintProductCatalogAISComponent.this.border;
            if (PrintProductCatalogAISComponent.this.dueDate != null) {
                h = (int)((double)h + PrintProductCatalogAISComponent.this.dueDate.getPreferredSize().getHeight());
                h += PrintProductCatalogAISComponent.this.border / 2;
            }
            if (PrintProductCatalogAISComponent.this.includeAllergenCodeIndex != null) {
                h = (int)((double)h + PrintProductCatalogAISComponent.this.includeAllergenCodeIndex.getPreferredSize().getHeight());
                h += PrintProductCatalogAISComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

